<?php
/**
 * Тест виджета с экспертной оценкой от GPT-4 (OpenRouter)
 */

// Конфигурация
$widgetKey = 'ekamedcenter';
$apiUrl = 'https://ekamedcenter.ru/api/query-section.php';
$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash'; // Gemini 2.5 Flash

// 10 тестовых вопросов
$questions = [
    "Острая боль в спине",
    "Головокружение при ходьбе",
    "Тошнота после еды",
    "Одышка при нагрузке",
    "Повышенная температура",
    "Боль в груди",
    "Потеря аппетита",
    "Бессонница",
    "Частое мочеиспускание",
    "Кровотечение из носа"
];

$timestamp = date('Y-m-d_H-i-s');
$reportFile = "/root/ai_expert_review_{$timestamp}.txt";
$summaryFile = "/root/ai_expert_summary_{$timestamp}.txt";

// Функция для запроса к виджету (через wrapper)
function queryWidget($question, $apiUrl, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [];
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        
        // Убираем debug строку
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$section])) {
            $result[$section] = $decoded['data'][$section];
        } else {
            $result[$section] = [];
        }
        
        usleep(100000); // 0.1 sec pause
    }
    
    return $result;
}

// Функция для запроса к OpenRouter GPT-4
function askExpert($question, $widgetResponse, $openrouterKey, $model) {
    $specialists = $widgetResponse['specialists'] ?? [];
    $services = $widgetResponse['services'] ?? [];
    $specializations = $widgetResponse['specializations'] ?? [];
    
    // Формируем текст для анализа
    $widgetData = "ЗАПРОС ПАЦИЕНТА: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $widgetData .= "СПЕЦИАЛИСТЫ (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specialists, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без имени') . 
                          " - " . ($spec['description'] ?? 'Без специальности') . "\n";
        }
        if (count($specialists) > 5) {
            $widgetData .= "  ... и ещё " . (count($specialists) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nУСЛУГИ (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($services, 0, 5) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'Без названия') . "\n";
        }
        if (count($services) > 5) {
            $widgetData .= "  ... и ещё " . (count($services) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nСПЕЦИАЛИЗАЦИИ (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach ($specializations as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без названия') . "\n";
        }
    }
    
    // Промпт для GPT-4
    $prompt = "Ты - медицинский эксперт, оценивающий работу AI-виджета для медицинской клиники.\n\n";
    $prompt .= $widgetData . "\n\n";
    $prompt .= "ЗАДАЧА:\n";
    $prompt .= "Оцени качество ответа виджета по следующим критериям:\n\n";
    $prompt .= "1. РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ (0-10 баллов)\n";
    $prompt .= "   - Правильно ли определены специалисты для данного запроса?\n";
    $prompt .= "   - Есть ли лишние/нерелевантные специалисты?\n\n";
    $prompt .= "2. РЕЛЕВАНТНОСТЬ УСЛУГ (0-10 баллов)\n";
    $prompt .= "   - Соответствуют ли услуги запросу пациента?\n";
    $prompt .= "   - Есть ли консультация специалиста в списке?\n";
    $prompt .= "   - Нужны ли дополнительные услуги?\n\n";
    $prompt .= "3. КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ (0-10 баллов)\n";
    $prompt .= "   - Правильно ли определена медицинская специализация?\n\n";
    $prompt .= "4. ПОЛНОТА ОТВЕТА (0-10 баллов)\n";
    $prompt .= "   - Получит ли пациент всю необходимую помощь?\n\n";
    $prompt .= "ФОРМАТ ОТВЕТА:\n";
    $prompt .= "```\n";
    $prompt .= "ОЦЕНКА: X/10\n";
    $prompt .= "РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ: X/10 - [краткое объяснение]\n";
    $prompt .= "РЕЛЕВАНТНОСТЬ УСЛУГ: X/10 - [краткое объяснение]\n";
    $prompt .= "КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ: X/10 - [краткое объяснение]\n";
    $prompt .= "ПОЛНОТА ОТВЕТА: X/10 - [краткое объяснение]\n\n";
    $prompt .= "ВЕРДИКТ: [ОТЛИЧНО/ХОРОШО/УДОВЛЕТВОРИТЕЛЬНО/ПЛОХО]\n\n";
    $prompt .= "РЕКОМЕНДАЦИИ: [что улучшить, если есть замечания]\n";
    $prompt .= "```\n\n";
    $prompt .= "Будь объективным и конструктивным!";
    
    // Запрос к OpenRouter
    $data = [
        'model' => $model,
        'messages' => [
            [
                'role' => 'user',
                'content' => $prompt
            ]
        ],
        'temperature' => 0.3,
        'max_tokens' => 1000
    ];
    
    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $openrouterKey,
            'Content-Type: application/json',
            'HTTP-Referer: https://ekamedcenter.ru',
            'X-Title: EKA Med Center AI Widget Test'
        ],
        CURLOPT_TIMEOUT => 60
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return "ОШИБКА: HTTP {$httpCode}\n{$response}";
    }
    
    $result = json_decode($response, true);
    return $result['choices'][0]['message']['content'] ?? 'Ошибка парсинга ответа';
}

// Основной процесс
echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║       ТЕСТИРОВАНИЕ С ЭКСПЕРТНОЙ ОЦЕНКОЙ GPT-4 (10 ВОПРОСОВ)            ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

$results = [];
$totalScore = 0;
$maxScore = 0;

file_put_contents($reportFile, "");
file_put_contents($summaryFile, "");

foreach ($questions as $index => $question) {
    $num = $index + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС {$num}/10: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Шаг 1: Запрос к виджету
    echo "  → Запрос к виджету... ";
    $widgetResponse = queryWidget($question, $apiUrl, $widgetKey);
    
    if (!$widgetResponse) {
        echo "ОШИБКА!\n\n";
        continue;
    }
    
    $specCount = count($widgetResponse['specialists'] ?? []);
    $servCount = count($widgetResponse['services'] ?? []);
    $spezCount = count($widgetResponse['specializations'] ?? []);
    
    echo "OK ({$specCount} спец., {$servCount} усл., {$spezCount} спез.)\n";
    
    // Шаг 2: Экспертная оценка
    echo "  → Запрос к GPT-4 эксперту... ";
    $expertReview = askExpert($question, $widgetResponse, $openrouterKey, $openrouterModel);
    echo "OK\n\n";
    
    // Извлекаем оценку
    preg_match('/ОЦЕНКА:\s*(\d+)\/10/i', $expertReview, $matches);
    $score = isset($matches[1]) ? (int)$matches[1] : 0;
    
    preg_match('/ВЕРДИКТ:\s*(.+)/i', $expertReview, $verdictMatches);
    $verdict = isset($verdictMatches[1]) ? trim($verdictMatches[1]) : 'N/A';
    
    echo "  ⭐ ОЦЕНКА: {$score}/10 | ВЕРДИКТ: {$verdict}\n\n";
    
    $totalScore += $score;
    $maxScore += 10;
    
    $results[] = [
        'question' => $question,
        'score' => $score,
        'verdict' => $verdict,
        'widget' => $widgetResponse,
        'review' => $expertReview
    ];
    
    // Сохраняем в файл
    $report = "\n" . str_repeat("=", 80) . "\n";
    $report .= "ВОПРОС {$num}/10: {$question}\n";
    $report .= str_repeat("=", 80) . "\n\n";
    
    $report .= "ОТВЕТ ВИДЖЕТА:\n";
    $report .= str_repeat("-", 80) . "\n";
    $report .= "Специалисты: {$specCount}\n";
    $report .= "Услуги: {$servCount}\n";
    $report .= "Специализации: {$spezCount}\n\n";
    
    $report .= "ЭКСПЕРТНАЯ ОЦЕНКА GPT-4:\n";
    $report .= str_repeat("-", 80) . "\n";
    $report .= $expertReview . "\n\n";
    
    file_put_contents($reportFile, $report, FILE_APPEND);
    
    sleep(1); // Небольшая пауза между запросами
}

// Формируем итоговую сводку
$avgScore = $maxScore > 0 ? ($totalScore / $maxScore) * 10 : 0;

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "ИТОГОВАЯ СТАТИСТИКА\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

$verdictCount = [
    'ОТЛИЧНО' => 0,
    'ХОРОШО' => 0,
    'УДОВЛЕТВОРИТЕЛЬНО' => 0,
    'ПЛОХО' => 0
];

foreach ($results as $result) {
    $v = strtoupper($result['verdict']);
    if (strpos($v, 'ОТЛИЧНО') !== false) $verdictCount['ОТЛИЧНО']++;
    elseif (strpos($v, 'ХОРОШО') !== false) $verdictCount['ХОРОШО']++;
    elseif (strpos($v, 'УДОВЛЕТВОРИТЕЛЬНО') !== false) $verdictCount['УДОВЛЕТВОРИТЕЛЬНО']++;
    elseif (strpos($v, 'ПЛОХО') !== false) $verdictCount['ПЛОХО']++;
}

echo sprintf("Средняя оценка: %.1f/10\n", $avgScore);
echo sprintf("Общий балл: %d/%d\n\n", $totalScore, $maxScore);

echo "Распределение вердиктов:\n";
echo sprintf("  • ОТЛИЧНО: %d\n", $verdictCount['ОТЛИЧНО']);
echo sprintf("  • ХОРОШО: %d\n", $verdictCount['ХОРОШО']);
echo sprintf("  • УДОВЛЕТВОРИТЕЛЬНО: %d\n", $verdictCount['УДОВЛЕТВОРИТЕЛЬНО']);
echo sprintf("  • ПЛОХО: %d\n\n", $verdictCount['ПЛОХО']);

// Топ-3 лучших
echo "TOP-3 ЛУЧШИХ ОТВЕТА:\n";
echo str_repeat("-", 80) . "\n";
usort($results, function($a, $b) { return $b['score'] - $a['score']; });
foreach (array_slice($results, 0, 3) as $i => $r) {
    echo sprintf("%d. %s - %d/10 (%s)\n", $i+1, $r['question'], $r['score'], $r['verdict']);
}
echo "\n";

// Топ-3 худших
echo "TOP-3 ПРОБЛЕМНЫХ ОТВЕТА:\n";
echo str_repeat("-", 80) . "\n";
foreach (array_slice(array_reverse($results), 0, 3) as $i => $r) {
    echo sprintf("%d. %s - %d/10 (%s)\n", $i+1, $r['question'], $r['score'], $r['verdict']);
}
echo "\n";

// Сохраняем сводку
$summary = "╔══════════════════════════════════════════════════════════════════════════╗\n";
$summary .= "║           СВОДКА ЭКСПЕРТНОЙ ОЦЕНКИ GPT-4 (10 ВОПРОСОВ)                 ║\n";
$summary .= "╚══════════════════════════════════════════════════════════════════════════╝\n\n";
$summary .= sprintf("Дата: %s\n", date('Y-m-d H:i:s'));
$summary .= sprintf("Модель: %s\n\n", $openrouterModel);
$summary .= sprintf("Средняя оценка: %.1f/10\n", $avgScore);
$summary .= sprintf("Общий балл: %d/%d\n\n", $totalScore, $maxScore);
$summary .= "Распределение:\n";
$summary .= sprintf("  • ОТЛИЧНО: %d (%.0f%%)\n", $verdictCount['ОТЛИЧНО'], ($verdictCount['ОТЛИЧНО']/10)*100);
$summary .= sprintf("  • ХОРОШО: %d (%.0f%%)\n", $verdictCount['ХОРОШО'], ($verdictCount['ХОРОШО']/10)*100);
$summary .= sprintf("  • УДОВЛЕТВОРИТЕЛЬНО: %d (%.0f%%)\n", $verdictCount['УДОВЛЕТВОРИТЕЛЬНО'], ($verdictCount['УДОВЛЕТВОРИТЕЛЬНО']/10)*100);
$summary .= sprintf("  • ПЛОХО: %d (%.0f%%)\n\n", $verdictCount['ПЛОХО'], ($verdictCount['ПЛОХО']/10)*100);

file_put_contents($summaryFile, $summary);

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ ТЕСТ ЗАВЕРШЕН!\n\n";
echo "📁 Детальный отчет: {$reportFile}\n";
echo "📁 Краткая сводка: {$summaryFile}\n\n";

