<?php
$question = 'Приступ удушья';
$widgetKey = 'ekamedcenter';

foreach (['specialists', 'services', 'specializations'] as $section) {
    $cmd = sprintf(
        'php /root/api-wrapper.php %s %s %s 2>&1',
        escapeshellarg($widgetKey),
        escapeshellarg($question),
        escapeshellarg($section)
    );
    
    $output = shell_exec($cmd);
    $lines = explode("\n", $output);
    $jsonLine = '';
    foreach ($lines as $line) {
        if (strpos($line, '{') === 0) {
            $jsonLine = $line;
            break;
        }
    }
    
    $decoded = json_decode($jsonLine, true);
    
    echo "=== {$section} ===\n";
    if ($decoded && isset($decoded['data'][$section])) {
        echo "Количество: " . count($decoded['data'][$section]) . "\n";
        if ($section === 'services' && count($decoded['data'][$section]) < 3) {
            echo "Детали:\n";
            foreach ($decoded['data'][$section] as $item) {
                echo "  - {$item['name']}\n";
            }
        }
        if ($section === 'specialists' && count($decoded['data'][$section]) > 0) {
            echo "Детали:\n";
            foreach (array_slice($decoded['data'][$section], 0, 3) as $item) {
                echo "  - {$item['name']} ({$item['description']})\n";
            }
        }
    } else {
        echo "ERROR: " . $jsonLine . "\n";
    }
    echo "\n";
}
