<?php
/**
 * Тест трех проблемных запросов с детальной отладкой
 */

$problematicQueries = [
    'Боль в шейно-воротниковой зоне',
    'Боль в спине после сна',
    'Общий анализ крови сдать'
];

$widgetKey = 'ekamedcenter';

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║  ТЕСТ ТРЕХ ПРОБЛЕМНЫХ ЗАПРОСОВ С ОТЛАДКОЙ                              ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

foreach ($problematicQueries as $index => $query) {
    $num = $index + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ЗАПРОС {$num}/3: {$query}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Тест 1: Прямой curl через shell
    echo "1️⃣ Тест через shell curl:\n";
    $shellCmd = "curl -s -X POST https://wtest.medmaps.ru/api/query-stage1.php -H 'Content-Type: application/json' -d '{\"widget_key\":\"{$widgetKey}\",\"question\":\"{$query}\"}'";
    $shellResponse = shell_exec($shellCmd);
    echo "   Длина ответа: " . strlen($shellResponse) . " байт\n";
    if (!empty($shellResponse)) {
        $shellDecoded = json_decode($shellResponse, true);
        if ($shellDecoded && isset($shellDecoded['text'])) {
            echo "   ✅ Текст получен: " . mb_substr($shellDecoded['text'], 0, 100) . "...\n";
            echo "   Provider: " . ($shellDecoded['provider'] ?? 'unknown') . "\n";
        } else {
            echo "   ❌ JSON ошибка: " . json_last_error_msg() . "\n";
            echo "   Ответ: " . substr($shellResponse, 0, 200) . "\n";
        }
    } else {
        echo "   ❌ Пустой ответ\n";
    }
    echo "\n";
    
    // Тест 2: PHP curl с разными настройками
    echo "2️⃣ Тест через PHP curl (обычные настройки):\n";
    $ch1 = curl_init('https://wtest.medmaps.ru/api/query-stage1.php');
    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch1, CURLOPT_POST, true);
    curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode(['widget_key' => $widgetKey, 'question' => $query]));
    curl_setopt($ch1, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch1, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
    
    $phpResponse1 = curl_exec($ch1);
    $phpHttpCode1 = curl_getinfo($ch1, CURLINFO_HTTP_CODE);
    $phpError1 = curl_error($ch1);
    curl_close($ch1);
    
    echo "   HTTP код: $phpHttpCode1\n";
    echo "   Длина ответа: " . strlen($phpResponse1) . " байт\n";
    if ($phpError1) {
        echo "   ⚠️ CURL ошибка: $phpError1\n";
    }
    if (!empty($phpResponse1)) {
        $phpDecoded1 = json_decode($phpResponse1, true);
        if ($phpDecoded1 && isset($phpDecoded1['text'])) {
            echo "   ✅ Текст получен: " . mb_substr($phpDecoded1['text'], 0, 100) . "...\n";
        } else {
            echo "   ❌ JSON ошибка: " . json_last_error_msg() . "\n";
            echo "   Ответ (первые 200 символов): " . substr($phpResponse1, 0, 200) . "\n";
        }
    } else {
        echo "   ❌ Пустой ответ\n";
    }
    echo "\n";
    
    // Тест 3: PHP curl с увеличенным таймаутом
    echo "3️⃣ Тест через PHP curl (таймаут 60 сек):\n";
    $ch2 = curl_init('https://wtest.medmaps.ru/api/query-stage1.php');
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch2, CURLOPT_POST, true);
    curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode(['widget_key' => $widgetKey, 'question' => $query]));
    curl_setopt($ch2, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch2, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch2, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch2, CURLOPT_SSL_VERIFYHOST, false);
    
    $startTime = microtime(true);
    $phpResponse2 = curl_exec($ch2);
    $endTime = microtime(true);
    $phpHttpCode2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
    $phpError2 = curl_error($ch2);
    $curlInfo = curl_getinfo($ch2);
    curl_close($ch2);
    
    echo "   HTTP код: $phpHttpCode2\n";
    echo "   Время выполнения: " . round($endTime - $startTime, 2) . " сек\n";
    echo "   Длина ответа: " . strlen($phpResponse2) . " байт\n";
    echo "   CURL total_time: " . ($curlInfo['total_time'] ?? 'N/A') . " сек\n";
    if ($phpError2) {
        echo "   ⚠️ CURL ошибка: $phpError2\n";
    }
    if (!empty($phpResponse2)) {
        $phpDecoded2 = json_decode($phpResponse2, true);
        if ($phpDecoded2 && isset($phpDecoded2['text'])) {
            echo "   ✅ Текст получен: " . mb_substr($phpDecoded2['text'], 0, 100) . "...\n";
            echo "   Provider: " . ($phpDecoded2['provider'] ?? 'unknown') . "\n";
        } else {
            echo "   ❌ JSON ошибка: " . json_last_error_msg() . "\n";
            echo "   Ответ (первые 500 символов): " . substr($phpResponse2, 0, 500) . "\n";
        }
    } else {
        echo "   ❌ Пустой ответ\n";
    }
    echo "\n";
    
    // Тест 4: Проверка через file_get_contents
    echo "4️⃣ Тест через file_get_contents (stream context):\n";
    $postData = json_encode(['widget_key' => $widgetKey, 'question' => $query]);
    $context = stream_context_create([
        'http' => [
            'method' => 'POST',
            'header' => "Content-Type: application/json\r\n" .
                       "Content-Length: " . strlen($postData) . "\r\n",
            'content' => $postData,
            'timeout' => 60
        ]
    ]);
    
    $startTime2 = microtime(true);
    $fileResponse = @file_get_contents('https://wtest.medmaps.ru/api/query-stage1.php', false, $context);
    $endTime2 = microtime(true);
    
    echo "   Время выполнения: " . round($endTime2 - $startTime2, 2) . " сек\n";
    echo "   Длина ответа: " . strlen($fileResponse ?: '') . " байт\n";
    if (!empty($fileResponse)) {
        $fileDecoded = json_decode($fileResponse, true);
        if ($fileDecoded && isset($fileDecoded['text'])) {
            echo "   ✅ Текст получен: " . mb_substr($fileDecoded['text'], 0, 100) . "...\n";
        } else {
            echo "   ❌ JSON ошибка: " . json_last_error_msg() . "\n";
            echo "   Ответ (первые 200 символов): " . substr($fileResponse, 0, 200) . "\n";
        }
    } else {
        echo "   ❌ Пустой ответ\n";
    }
    echo "\n";
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Небольшая пауза между запросами
    sleep(2);
}

echo "✅ Тестирование завершено\n";

