<?php
/**
 * Прямой тест определения специальностей
 */

require_once __DIR__ . '/config.php';

$testQueries = [
    'Частое мочеиспускание',
    'Кровотечение из носа',
    'Боль в груди'
];

echo "╔═══════════════════════════════════════════════════════════════════════════════╗\n";
echo "║         ТЕСТ ОПРЕДЕЛЕНИЯ СПЕЦИАЛЬНОСТЕЙ И ПОИСКА КОНСУЛЬТАЦИЙ               ║\n";
echo "╚═══════════════════════════════════════════════════════════════════════════════╝\n\n";

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT * FROM widgets WHERE widget_key = ?");
$stmt->execute(['ekamedcenter']);
$widget = $stmt->fetch();

if (!$widget) {
    echo "❌ ERROR: Widget not found\n";
    exit(1);
}

foreach ($testQueries as $question) {
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ЗАПРОС: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Проверяем какие специальности определяются
    $questionLower = mb_strtolower($question);
    $relevantSpecialties = [];
    
    if (preg_match('/(бессонн|невролог|голов|головокруж|мигрен|головн.*бол|нервн|тремор|онемен|защемл)/ui', $question)) {
        $relevantSpecialties[] = 'невролог';
    }
    if (preg_match('/(температур|просту|грипп|орви|орз|кашель|насморк|слабость|терапевт|одышк|аппетит)/ui', $question)) {
        $relevantSpecialties[] = 'терапевт';
    }
    if (preg_match('/(сердц|давлен|гипертон|аритми|тахикарди|кардиолог|одышк|груд.*бол|боль.*груд)/ui', $question)) {
        $relevantSpecialties[] = 'кардиолог';
    }
    if (preg_match('/(живот|желуд|гастрит|язв|тошнот|рвот|изжог|пищеварен|гастроэнтеролог|аппетит)/ui', $question)) {
        $relevantSpecialties[] = 'гастроэнтеролог';
    }
    if (preg_match('/(кож|сыпь|зуд|прыщ|акне|псориаз|розацеа|дерматолог|дерматит)/ui', $question)) {
        $relevantSpecialties[] = 'дерматолог';
    }
    if (preg_match('/(мочеиспускан|урина|уролог|моч[еа]|почк|мочевой пузырь|цистит|пиелонефрит|простат)/ui', $question)) {
        $relevantSpecialties[] = 'уролог';
    }
    if (preg_match('/(нос|горл|ухо|лор|оториноларинголог|ангин|фарингит|тонзиллит|ринит|синусит|гайморит|отит|кровотечение.*нос|носов.*кровотечен)/ui', $question)) {
        $relevantSpecialties[] = 'лор';
    }
    if (preg_match('/(аллерг|аллерголог|аллергическ|крапивниц)/ui', $question)) {
        $relevantSpecialties[] = 'аллерголог';
    }
    if (preg_match('/(глаз|зрен|офтальмолог|конъюнктивит|катаракт|глауком)/ui', $question)) {
        $relevantSpecialties[] = 'офтальмолог';
    }
    
    echo "✅ Определенные специальности: " . (empty($relevantSpecialties) ? '❌ НЕТ' : implode(', ', $relevantSpecialties)) . "\n\n";
    
    if (empty($relevantSpecialties)) {
        echo "❌ КРИТИЧНО: Не определены специальности!\n\n";
        continue;
    }
    
    // Маппинг
    $specialtyMapping = [
        'лор' => 'оториноларинголог',
        'невролог' => 'невролог',
        'терапевт' => 'терапевт',
        'кардиолог' => 'кардиолог',
        'гастроэнтеролог' => 'гастроэнтеролог',
        'дерматолог' => 'дерматолог',
        'уролог' => 'уролог',
        'аллерголог' => 'аллерголог',
        'офтальмолог' => 'офтальмолог'
    ];
    
    // Ищем консультации
    $consultationIds = [];
    foreach ($relevantSpecialties as $specialty) {
        $searchSpecialty = $specialtyMapping[$specialty] ?? $specialty;
        echo "Ищем консультацию: '$specialty' → '$searchSpecialty'\n";
        
        $stmtConsult = $db->prepare("
            SELECT DISTINCT pi.id, pf.field_value as name,
                CASE 
                    WHEN LOWER(pf.field_value) LIKE '%первичная%' THEN 1
                    WHEN LOWER(pf.field_value) LIKE '%повторная%' THEN 2
                    ELSE 3
                END as sort_order
            FROM parsed_items pi
            JOIN parsed_fields pf ON pi.id = pf.item_id
            WHERE pi.widget_id = ? 
            AND pi.section_name = 'services'
            AND pf.field_name = 'name'
            AND LOWER(pf.field_value) LIKE ?
            AND LOWER(pf.field_value) LIKE '%консультация%'
            AND pi.is_duplicate = 0
            ORDER BY sort_order
            LIMIT 2
        ");
        $stmtConsult->execute([$widget['id'], '%' . $searchSpecialty . '%']);
        
        $found = 0;
        while ($row = $stmtConsult->fetch()) {
            $consultationIds[] = (int)$row['id'];
            echo "  ✅ Найдена: " . $row['name'] . " (ID: " . $row['id'] . ", sort: " . $row['sort_order'] . ")\n";
            $found++;
        }
        
        if ($found === 0) {
            echo "  ❌ НЕ НАЙДЕНО консультаций для '$searchSpecialty'\n";
            
            // Попробуем найти хотя бы что-то для проверки
            $stmtCheck = $db->prepare("
                SELECT pi.id, pf.field_value as name
                FROM parsed_items pi
                JOIN parsed_fields pf ON pi.id = pf.item_id
                WHERE pi.widget_id = ? 
                AND pi.section_name = 'services'
                AND pf.field_name = 'name'
                AND LOWER(pf.field_value) LIKE '%консультация%'
                AND pi.is_duplicate = 0
                LIMIT 5
            ");
            $stmtCheck->execute([$widget['id']]);
            echo "  ℹ️  Примеры консультаций в базе:\n";
            while ($row = $stmtCheck->fetch()) {
                echo "     - " . $row['name'] . "\n";
            }
        }
    }
    
    echo "\n";
    echo "📊 ИТОГО:\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "Найдено консультаций: " . count($consultationIds) . "\n";
    
    if (empty($consultationIds)) {
        echo "❌ КРИТИЧНО: Консультации не найдены!\n";
    } else {
        echo "✅ Консультации успешно найдены\n";
    }
    
    echo "\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "ТЕСТИРОВАНИЕ ЗАВЕРШЕНО\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

