<?php
/**
 * Быстрый тест на самых проблемных вопросах
 */

$problematicQuestions = [
    'Боль в сердце колющая',
    'Холецистит боль справа',
    'Колики у новорожденного',
    'Гастроскопия ФГДС',
    'Промывание носа кукушка',
    'Корь у детей',
    'Ангина гнойная',
];

$widgetKey = 'ekamedcenter';
$apiUrl = 'https://wtest.medmaps.ru/api/query-stage1_1.php';

echo "БЫСТРЫЙ ТЕСТ (7 ВОПРОСОВ)\n";
echo str_repeat("=", 70) . "\n\n";

foreach ($problematicQuestions as $index => $question) {
    $num = $index + 1;
    echo "{$num}. {$question}\n";
    
    $data = ['widget_key' => $widgetKey, 'question' => $question];
    
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $text = '';
    if ($httpCode === 200 && $response) {
        $decoded = json_decode($response, true);
        $text = $decoded['text'] ?? '';
    }
    
    // Проверки
    $issues = [];
    
    // Обрыв на середине
    if (preg_match('/\s+(или|и|таких|включая|непереносимость|воспаление)\s*[-\.]?\s*$/ui', $text)) {
        $issues[] = 'Обрыв на середине';
    }
    
    // Незавершенность
    if (!preg_match('/[.!?]\s*$/u', $text)) {
        $issues[] = 'Не завершен';
    }
    
    // Английские слова
    if (preg_match('/\b(hands|feet|are|is|the|and|or)\b/i', $text)) {
        $issues[] = 'Английские слова';
    }
    
    // Артефакты ```
    if (preg_match('/```/', $text)) {
        $issues[] = 'Артефакт ```';
    }
    
    $status = empty($issues) ? '✅' : '❌';
    
    echo "   {$status} " . mb_substr($text, 0, 120) . (mb_strlen($text) > 120 ? '...' : '') . "\n";
    if (!empty($issues)) {
        echo "   ⚠️  " . implode(', ', $issues) . "\n";
    }
    echo "\n";
    
    usleep(500000);
}
