#!/usr/bin/env php
<?php

// Самые проблемные вопросы из ПЛОХО категории
$testQuestions = [
    'Увеличение лимфоузлов подмышками',
    'Отеки ног к вечеру',
    'Приступ удушья',
    'Горечь во рту',
    'Сухость во рту',
    'Метеоризм газообразование',
    'Утренняя скованность суставов',
    'Подагра приступ'
];

$widgetKey = 'ekamedcenter';
$section = 'specialists';

echo "\n📊 ТЕСТ УЛУЧШЕННОГО ПРОМПТА (8 проблемных вопросов)\n";
echo str_repeat("━", 80) . "\n\n";

$totalTests = count($testQuestions);
$passedTests = 0;
$results = [];

foreach ($testQuestions as $idx => $question) {
    $num = $idx + 1;
    echo "🔍 Вопрос {$num}/{$totalTests}: {$question}\n";
    
    $result = callWidgetAPI($question, $section, $widgetKey);
    
    $specialistsCount = count($result['specialists'] ?? []);
    $servicesCount = count($result['services'] ?? []);
    $specializationsCount = count($result['specializations'] ?? []);
    
    $passed = ($specialistsCount >= 2 && $servicesCount >= 3 && $specializationsCount >= 1);
    if ($passed) {
        $passedTests++;
        echo "   ✅ УСПЕХ: {$specialistsCount} спец., {$servicesCount} усл., {$specializationsCount} спец.\n";
    } else {
        echo "   ❌ ПРОБЛЕМА: {$specialistsCount} спец., {$servicesCount} усл., {$specializationsCount} спец.\n";
    }
    
    $results[] = [
        'question' => $question,
        'specialists' => $specialistsCount,
        'services' => $servicesCount,
        'specializations' => $specializationsCount,
        'passed' => $passed
    ];
    
    echo "\n";
}

echo str_repeat("━", 80) . "\n";
echo "📊 ИТОГО: {$passedTests}/{$totalTests} тестов пройдено (" . round(($passedTests/$totalTests)*100, 1) . "%)\n";
echo str_repeat("━", 80) . "\n\n";

// Детальные результаты
echo "📋 ДЕТАЛЬНЫЕ РЕЗУЛЬТАТЫ:\n\n";
foreach ($results as $r) {
    $status = $r['passed'] ? '✅' : '❌';
    echo "{$status} {$r['question']}\n";
    echo "   Специалисты: {$r['specialists']}, Услуги: {$r['services']}, Специализации: {$r['specializations']}\n\n";
}

function callWidgetAPI($question, $section, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [];
    
    foreach ($sections as $sec) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($sec)
        );
        
        $output = shell_exec($cmd);
        
        // Убираем debug строку
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$sec])) {
            $result[$sec] = $decoded['data'][$sec];
        } else {
            $result[$sec] = [];
        }
        
        usleep(100000); // 0.1 sec pause
    }
    
    return $result;
}

