<?php
/**
 * Тест ПРОБЛЕМНЫХ вопросов с экспертной оценкой GPT-4o
 * 127 вопросов с оценкой УДОВЛЕТВОРИТЕЛЬНО или ПЛОХО
 */

// Конфигурация
$widgetKey = 'ekamedcenter';
$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash';

// Загружаем проблемные вопросы
$questions = json_decode(file_get_contents('/root/problem-questions.json'), true);

$timestamp = date('Y-m-d_H-i-s');
$reportFile = "/root/problem_questions_review_{$timestamp}.txt";
$summaryFile = "/root/problem_questions_summary_{$timestamp}.txt";

// Функция для запроса к виджету
function queryWidget($question, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [];
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$section])) {
            $result[$section] = $decoded['data'][$section];
        } else {
            $result[$section] = [];
        }
        
        usleep(100000);
    }
    
    return $result;
}

// Функция для запроса к GPT-4o
function askExpert($question, $widgetResponse, $openrouterKey, $model) {
    $specialists = $widgetResponse['specialists'] ?? [];
    $services = $widgetResponse['services'] ?? [];
    $specializations = $widgetResponse['specializations'] ?? [];
    
    $widgetData = "ЗАПРОС: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "Специалисты (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (нет)\n";
    } else {
        foreach (array_slice($specialists, 0, 3) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'N/A') . 
                          " - " . ($spec['description'] ?? 'N/A') . "\n";
        }
        if (count($specialists) > 3) $widgetData .= "  ... и ещё " . (count($specialists) - 3) . "\n";
    }
    
    $widgetData .= "\nУслуги (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (нет)\n";
    } else {
        foreach (array_slice($services, 0, 3) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'N/A') . "\n";
        }
        if (count($services) > 3) $widgetData .= "  ... и ещё " . (count($services) - 3) . "\n";
    }
    
    $widgetData .= "\nСпециализации (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (нет)\n";
    } else {
        foreach (array_slice($specializations, 0, 3) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'N/A') . "\n";
        }
        if (count($specializations) > 3) $widgetData .= "  ... и ещё " . (count($specializations) - 3) . "\n";
    }
    
    $prompt = "Ты - медицинский эксперт. Оцени релевантность ответа виджета клиники. " .
              "Оцени по 4 критериям (0-10): РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ, РЕЛЕВАНТНОСТЬ УСЛУГ, КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ, ПОЛНОТА ОТВЕТА. " .
              "Формат: ОЦЕНКА: X/40\nРЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ: Y/10 - [комментарий]\nРЕЛЕВАНТНОСТЬ УСЛУГ: Z/10 - [комментарий]\nКОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ: A/10 - [комментарий]\nПОЛНОТА ОТВЕТА: B/10 - [комментарий]\n\nВЕРДИКТ: [ОТЛИЧНО/ХОРОШО/УДОВЛЕТВОРИТЕЛЬНО/ПЛОХО]\n\nРЕКОМЕНДАЦИИ: [текст]\n\n" .
              $widgetData;

    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $openrouterKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'model' => $model,
        'messages' => [['role' => 'user', 'content' => $prompt]]
    ]));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || $response === false) {
        return "Ошибка запроса к GPT-4o";
    }

    $decodedResponse = json_decode($response, true);
    return $decodedResponse['choices'][0]['message']['content'] ?? 'Ошибка парсинга';
}

// Статистика
$totalScore = 0;
$verdictCounts = ['ОТЛИЧНО' => 0, 'ХОРОШО' => 0, 'УДОВЛЕТВОРИТЕЛЬНО' => 0, 'ПЛОХО' => 0];
$improved = 0; // Улучшенные (было ПЛОХО, стало лучше)
$startTime = time();

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║       ПОВТОРНЫЙ ТЕСТ ПРОБЛЕМНЫХ ВОПРОСОВ (127 шт.)                      ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

$reportHandle = fopen($reportFile, 'w');

foreach ($questions as $index => $question) {
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС " . ($index + 1) . "/127: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    fwrite($reportHandle, "ВОПРОС " . ($index + 1) . "/127: {$question}\n");
    fwrite($reportHandle, "================================================================================\n\n");

    echo "  → Запрос к виджету...\n";
    $widgetResponse = queryWidget($question, $widgetKey);
    
    $specialistsCount = count($widgetResponse['specialists'] ?? []);
    $servicesCount = count($widgetResponse['services'] ?? []);
    $specializationsCount = count($widgetResponse['specializations'] ?? []);
    
    echo "  → OK ({$specialistsCount} спец., {$servicesCount} усл., {$specializationsCount} спец.)\n";
    
    fwrite($reportHandle, "ОТВЕТ ВИДЖЕТА:\n");
    fwrite($reportHandle, "Специалисты: {$specialistsCount}, Услуги: {$servicesCount}, Специализации: {$specializationsCount}\n\n");

    echo "  → Запрос к GPT-4o...\n";
    $expertReview = askExpert($question, $widgetResponse, $openrouterKey, $openrouterModel);
    echo "  → OK\n\n";

    fwrite($reportHandle, "ЭКСПЕРТНАЯ ОЦЕНКА:\n{$expertReview}\n\n\n");

    // Парсинг
    $score = 0;
    $verdict = 'ПЛОХО';
    if (preg_match('/ОЦЕНКА:\s*(\d+)\/40/u', $expertReview, $matches)) {
        $score = (int)$matches[1];
    }
    if (preg_match('/ВЕРДИКТ:\s*(ОТЛИЧНО|ХОРОШО|УДОВЛЕТВОРИТЕЛЬНО|ПЛОХО)/u', $expertReview, $matches)) {
        $verdict = $matches[1];
    }

    $totalScore += $score;
    $verdictCounts[$verdict]++;
    
    // Считаем улучшенные (было 0-20 баллов, стало > 20)
    if ($score > 20 && $index < 42) { // Первые 42 были с оценкой ПЛОХО
        $improved++;
    }

    echo "  ⭐ ОЦЕНКА: {$score}/40 | ВЕРДИКТ: {$verdict}\n";
    
    $elapsed = time() - $startTime;
    $avgTimePerQ = $elapsed / ($index + 1);
    $remaining = (127 - ($index + 1)) * $avgTimePerQ;
    $remainingMin = round($remaining / 60);
    echo "  📊 Прогресс: " . ($index + 1) . "/127 (" . round(($index + 1) / 127 * 100, 1) . "%) | ~{$remainingMin} мин. осталось\n\n";
    
    usleep(1000000);
}

fclose($reportHandle);

// Сводка
$averageScore = round($totalScore / count($questions), 1);
$elapsedTotal = time() - $startTime;
$elapsedMin = round($elapsedTotal / 60, 1);

$summary = "ИТОГОВАЯ СТАТИСТИКА (127 ПРОБЛЕМНЫХ ВОПРОСОВ)\n";
$summary .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
$summary .= "Средняя оценка: {$averageScore}/40\n";
$summary .= "Общий балл: {$totalScore}/" . (count($questions) * 40) . "\n";
$summary .= "Время: {$elapsedMin} минут\n\n";
$summary .= "Распределение вердиктов:\n";
foreach ($verdictCounts as $v => $c) {
    $percent = round($c / count($questions) * 100, 1);
    $summary .= "  • {$v}: {$c} ({$percent}%)\n";
}
$summary .= "\n✅ Улучшено вопросов (было ПЛОХО, стало лучше): {$improved}\n\n";
$summary .= "📁 Детальный отчет: {$reportFile}\n";
$summary .= "📁 Сводка: {$summaryFile}\n";

file_put_contents($summaryFile, $summary);
echo "\n" . $summary;

?>

