<?php
/**
 * Быстрый тест проблемных вопросов после исправлений
 */

$problemQuestions = [
    'Бессонница что делать',
    'Подбор очков',
    'Ночная потливость',
    'Высокий холестерин',
    'Запор что делать',
    'Покраснение глаз',
    'Сухость во рту'
];

$widgetKey = 'ekamedcenter';
$apiUrl = 'https://wtest.medmaps.ru/api/query-section.php';
$sections = ['specialists', 'services', 'specializations'];

echo "╔══════════════════════════════════════════════════════════════════╗\n";
echo "║        ТЕСТ ПРОБЛЕМНЫХ ВОПРОСОВ ПОСЛЕ НОВЫХ ИСПРАВЛЕНИЙ         ║\n";
echo "╚══════════════════════════════════════════════════════════════════╝\n\n";

foreach ($problemQuestions as $i => $question) {
    $num = $i + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС {$num}: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $results = [];
    
    foreach ($sections as $section) {
        $data = [
            'widget_key' => $widgetKey,
            'question' => $question,
            'section_name' => $section,
            '_debug' => false
        ];
        
        $ch = curl_init($apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200 && $response) {
            $result = json_decode($response, true);
            if (isset($result['data'][$section])) {
                $count = count($result['data'][$section]);
                $results[$section] = $count;
                
                if ($count > 0) {
                    $names = array_slice(array_column($result['data'][$section], 'name'), 0, 2);
                    echo "  ✅ {$section}: {$count} (";
                    echo implode(', ', array_map(function($n) { return mb_substr($n, 0, 35); }, $names));
                    if ($count > 2) echo "...";
                    echo ")\n";
                } else {
                    echo "  ❌ {$section}: 0 (ПУСТО)\n";
                }
            }
        } else {
            echo "  ⚠️  {$section}: ERROR (HTTP {$httpCode})\n";
            $results[$section] = 0;
        }
        
        usleep(200000); // 200ms
    }
    
    // Проверка улучшений
    $spec = $results['specialists'] ?? 0;
    $serv = $results['services'] ?? 0;
    $special = $results['specializations'] ?? 0;
    
    if ($spec == 0 && $serv == 0 && $special == 0) {
        echo "  ⚠️  КРИТИЧНО: Все еще пустой (0/0/0)\n";
    } elseif ($spec > 0 && $serv > 0 && $special > 0) {
        echo "  🎉 ОТЛИЧНО: Все категории заполнены!\n";
    } elseif ($spec > 0 || $serv > 0) {
        echo "  ✅ УЛУЧШЕНО: Есть результаты\n";
    }
    
    echo "\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ Тестирование завершено!\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";



