<?php
/**
 * Тестовый скрипт для проверки логирования проблемных вопросов
 */

// Устанавливаем переменные окружения для обхода проверок
$_SERVER['REQUEST_METHOD'] = 'POST';

require_once '/root/config.php';

// Загружаем только функции, минуя проверки API
require_once '/root/config.php';

// Проблемные вопросы из последнего теста
$problematicQuestions = [
    'Отеки ног к вечеру',
    'Рентген костей',
];

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║  ТЕСТ ЛОГИРОВАНИЯ ПРОБЛЕМНЫХ ВОПРОСОВ                                   ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

// Загружаем функции напрямую из файла
$apiFile = file_get_contents('/root/api/query-stage1_1.php');
// Удаляем проверку REQUEST_METHOD в начале файла
$apiFile = preg_replace('/if\s*\(\s*!\s*isset\s*\(\s*\$_SERVER\[\'REQUEST_METHOD\'\]\s*\)\s*\)\s*\{[^}]*\}/s', '', $apiFile);
eval('?>' . $apiFile);

foreach ($problematicQuestions as $question) {
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС: $question\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    try {
        // Получаем виджет из БД
        $db = getDatabase();
        $stmt = $db->prepare("SELECT w.*, ws.* FROM widgets w LEFT JOIN widget_settings ws ON w.id = ws.widget_id WHERE w.widget_key = ? AND w.active = 1");
        $stmt->execute(['ekamedcenter']);
        $widget = $stmt->fetch();
        
        if (!$widget) {
            echo "ОШИБКА: Виджет не найден\n\n";
            continue;
        }
        
        // Вызываем executeStage1 напрямую
        $model = normalizeModelName($widget['stage1_model'] ?? 'meta-llama/llama-3.2-1b-instruct');
        $systemPrompt = $widget['stage1_prompt'] ?? null;
        
        $result = executeStage1($question, $model, $systemPrompt);
        
        echo "Результат:\n";
        echo "  Provider: " . ($result['provider'] ?? 'unknown') . "\n";
        echo "  Длина текста: " . mb_strlen($result['text'] ?? '') . "\n";
        echo "  Текст: " . mb_substr($result['text'] ?? 'ПУСТО', 0, 200) . "\n";
        echo "\n";
        
    } catch (Exception $e) {
        echo "ОШИБКА: " . $e->getMessage() . "\n";
        echo "Trace: " . $e->getTraceAsString() . "\n\n";
    }
    
    echo "\n";
    sleep(2); // Пауза между запросами
}

echo "\nЛоги сохранены в: /root/ai-widget/logs/parser.log\n";
echo "Последние 200 строк логов:\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
exec('tail -200 /root/ai-widget/logs/parser.log');
