<?php
/**
 * Live-тест интеграции валидации с реальным API
 */

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║  LIVE-ТЕСТ ВАЛИДАЦИИ (реальный API запрос)                               ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

$testQuestions = [
    'Болит поясница и отдает в ногу',
    'ОРВИ симптомы',
    'Справка на оружие'
];

foreach ($testQuestions as $i => $question) {
    $num = $i + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ТЕСТ {$num}: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $data = [
        'widget_key' => 'ekamedcenter',
        'question' => $question
    ];
    
    $ch = curl_init('https://wtest.medmaps.ru/api/query-stage1_1.php');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    $startTime = microtime(true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $elapsed = round((microtime(true) - $startTime) * 1000);
    curl_close($ch);
    
    echo "HTTP код: {$httpCode}\n";
    echo "Время ответа: {$elapsed} мс\n\n";
    
    if ($httpCode === 200 && $response) {
        $decoded = json_decode($response, true);
        
        if ($decoded && isset($decoded['text'])) {
            $text = $decoded['text'];
            $provider = $decoded['provider'] ?? 'unknown';
            
            echo "Provider: {$provider}\n";
            echo "Длина текста: " . mb_strlen($text) . " символов\n\n";
            echo "Текст:\n";
            echo str_repeat('-', 78) . "\n";
            echo wordwrap($text, 78) . "\n";
            echo str_repeat('-', 78) . "\n\n";
            
            // Проверяем наличие артефактов
            $hasEnglish = preg_match('/[A-Za-z]{3,}/', $text);
            $endsCorrectly = preg_match('/[.!?]\s*$/u', $text);
            
            echo "✅ Проверки:\n";
            echo "  - Английские слова: " . ($hasEnglish ? "❌ НАЙДЕНЫ" : "✅ НЕТ") . "\n";
            echo "  - Завершенность: " . ($endsCorrectly ? "✅ ДА" : "❌ НЕТ") . "\n";
            echo "  - Длина: " . (mb_strlen($text) >= 100 ? "✅ OK" : "⚠️ КОРОТКИЙ") . "\n";
        } else {
            echo "❌ ОШИБКА: Не удалось получить текст из ответа\n";
            echo "Response: " . substr($response, 0, 200) . "\n";
        }
    } else {
        echo "❌ ОШИБКА HTTP {$httpCode}\n";
        echo "Response: " . substr($response, 0, 200) . "\n";
    }
    
    echo "\n";
    sleep(2); // Небольшая задержка между запросами
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ Live-тест завершен\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
