<?php
/**
 * Тест исправленных запросов
 */

// Проблемные запросы из TOP-10
$queries = [
    'Судороги в ногах ночью',
    'Люмбаго острая боль',
    'Слабость и утомляемость',
    'Затрудненное дыхание',
    'Ночная потливость',
    'Инфаркт профилактика',
    'Синюшность пальцев',
    'Боль в правом подреберье',
    'Диарея понос',
    'Рвота и понос'
];

echo "╔═══════════════════════════════════════════════════════════════════════╗\n";
echo "║  ТЕСТ ИСПРАВЛЕННЫХ ЗАПРОСОВ (10 проблемных из V2)                     ║\n";
echo "╚═══════════════════════════════════════════════════════════════════════╝\n";
echo "\n";

$results = [];
$total = 0;
$withData = 0;
$warnings = 0;

foreach ($queries as $index => $query) {
    $num = $index + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС {$num}/10: {$query}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    
    // Запрос к виджету (используем api-wrapper.php)
    $sections = ['specialists', 'services', 'specializations'];
    $counts = ['specialists' => 0, 'services' => 0, 'specializations' => 0];
    $warning = false;
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg('ekamedcenter'),
            escapeshellarg($query),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        
        // Убираем debug строку
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$section])) {
            $counts[$section] = count($decoded['data'][$section]);
        }
        
        if ($decoded && isset($decoded['warning']) && $decoded['warning'] === true) {
            $warning = true;
        }
    }
    
    $specialists = $counts['specialists'];
    $services = $counts['services'];
    $specializations = $counts['specializations'];
    
    echo "  Специалисты: {$specialists}\n";
    echo "  Услуги: {$services}\n";
    echo "  Специализации: {$specializations}\n";
    echo "  Warning: " . ($warning ? "true ⚠️" : "false") . "\n";
    
    $total++;
    
    if ($warning) {
        $warnings++;
        echo "  Статус: ⚠️ WARNING (экстренная ситуация)\n";
    } elseif ($specialists > 0) {
        $withData++;
        echo "  Статус: ✅ ИСПРАВЛЕНО\n";
    } else {
        echo "  Статус: ❌ ВСЕ ЕЩЕ ПУСТО\n";
    }
    
    echo "\n";
    
    $results[] = [
        'query' => $query,
        'specialists' => $specialists,
        'services' => $services,
        'specializations' => $specializations,
        'warning' => $warning
    ];
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "ИТОГОВАЯ СТАТИСТИКА\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

if ($total === 0) {
    echo "❌ Нет данных для статистики\n";
    exit(1);
}

echo "Всего запросов: {$total}\n";
echo "С данными (исправлено): {$withData} (" . round($withData / $total * 100, 1) . "%)\n";
echo "С warning: {$warnings} (" . round($warnings / $total * 100, 1) . "%)\n";
echo "Все еще пусто: " . ($total - $withData - $warnings) . " (" . round(($total - $withData - $warnings) / $total * 100, 1) . "%)\n";
echo "\n";

if ($withData >= 7) {
    echo "✅ ОТЛИЧНО! Исправления работают!\n";
} elseif ($withData >= 5) {
    echo "⚠️ НЕПЛОХО, но есть проблемы\n";
} else {
    echo "❌ ПЛОХО! Нужно дорабатывать\n";
}

echo "\n";
echo "Детали:\n";
echo "\n";

foreach ($results as $r) {
    $status = $r['warning'] ? '⚠️' : ($r['specialists'] > 0 ? '✅' : '❌');
    printf("  %s %-35s | Спец: %2d | Усл: %2d\n", 
        $status, 
        $r['query'], 
        $r['specialists'], 
        $r['services']
    );
}

echo "\n";
