<?php
// Быстрый тест экстренных ситуаций

$emergencyQuestions = [
    "Приступ удушья",
    "Синюшность пальцев",
    "Люмбаго острая боль",
    "Отек Квинке",
    "Скарлатина симптомы"
];

$widgetKey = 'ekamedcenter';
$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash';

// Функция для вызова виджета
function callWidgetAPI($question, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [
        'specialists' => [],
        'services' => [],
        'specializations' => [],
        'text' => '',
        'warning' => false
    ];
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded) {
            // Сохраняем текст и warning из первого ответа
            if (empty($result['text']) && !empty($decoded['text'])) {
                $result['text'] = $decoded['text'];
            }
            if (!$result['warning'] && !empty($decoded['warning'])) {
                $result['warning'] = true;
            }
            
            // Сохраняем данные секции
            if (isset($decoded['data'][$section])) {
                $result[$section] = $decoded['data'][$section];
            }
        }
        
        usleep(50000);
    }
    
    return $result;
}

// Функция для запроса к AI эксперту
function askExpert($question, $widgetResponse, $openrouterKey, $model) {
    $specialists = $widgetResponse['specialists'] ?? [];
    $services = $widgetResponse['services'] ?? [];
    $specializations = $widgetResponse['specializations'] ?? [];
    $text = $widgetResponse['text'] ?? '';
    $warning = $widgetResponse['warning'] ?? false;
    
    $widgetData = "ЗАПРОС ПАЦИЕНТА: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Если есть предупреждение, показываем его
    if ($warning && !empty($text)) {
        $widgetData .= "⚠️ ЭКСТРЕННОЕ ПРЕДУПРЕЖДЕНИЕ:\n";
        $widgetData .= $text . "\n\n";
    }
    
    $widgetData .= "СПЕЦИАЛИСТЫ (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specialists, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без имени') . 
                          " - " . ($spec['description'] ?? 'Без специальности') . "\n";
        }
        if (count($specialists) > 5) {
            $widgetData .= "  ... и ещё " . (count($specialists) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nУСЛУГИ (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($services, 0, 5) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'Без названия') . "\n";
        }
        if (count($services) > 5) {
            $widgetData .= "  ... и ещё " . (count($services) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nСПЕЦИАЛИЗАЦИИ (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach ($specializations as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без названия') . "\n";
        }
    }
    
    $prompt = "Ты - медицинский эксперт. Оцени качество ответа медицинского виджета на запрос пациента.

{$widgetData}

КРИТИЧНО - ЭКСТРЕННЫЕ СИТУАЦИИ:
Если виджет вернул ⚠️ ЭКСТРЕННОЕ ПРЕДУПРЕЖДЕНИЕ о вызове скорой помощи:
- Это ПРАВИЛЬНЫЙ ОТВЕТ для экстренных симптомов
- Отсутствие специалистов/услуг в этом случае НОРМАЛЬНО
- Оценка должна быть ОТЛИЧНО (38-40 баллов)
- Примеры экстренных ситуаций: инфаркт, инсульт, удушье, отек Квинке, острая боль

Оцени ответ по шкале от 0 до 40 баллов.

Формат ответа:
ОЦЕНКА: X/40
ВЕРДИКТ: (ОТЛИЧНО/ХОРОШО/УДОВЛЕТВОРИТЕЛЬНО/ПЛОХО)";

    $data = [
        'model' => $model,
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ],
        'temperature' => 0.3,
        'max_tokens' => 500
    ];
    
    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $openrouterKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return "Error: HTTP $httpCode";
    }
    
    $decoded = json_decode($response, true);
    return $decoded['choices'][0]['message']['content'] ?? 'No response';
}

echo "🚨 ТЕСТ ЭКСТРЕННЫХ СИТУАЦИЙ (5 вопросов)\n";
echo str_repeat("=", 70) . "\n\n";

$results = [];

foreach ($emergencyQuestions as $i => $question) {
    echo "[" . ($i+1) . "/5] $question\n";
    
    // Вызов виджета
    $widgetResponse = callWidgetAPI($question, $widgetKey);
    
    echo "  → Специалисты: " . count($widgetResponse['specialists']) . "\n";
    echo "  → Услуги: " . count($widgetResponse['services']) . "\n";
    echo "  → Warning: " . ($widgetResponse['warning'] ? 'ДА' : 'НЕТ') . "\n";
    if (!empty($widgetResponse['text'])) {
        echo "  → Текст: " . substr($widgetResponse['text'], 0, 80) . "...\n";
    }
    
    // Запрос к AI эксперту
    $expertResponse = askExpert($question, $widgetResponse, $openrouterKey, $openrouterModel);
    
    // Парсим ответ
    if (preg_match('/ОЦЕНКА:\s*(\d+)\/40/', $expertResponse, $scoreMatch)) {
        $score = (int)$scoreMatch[1];
    } else {
        $score = 0;
    }
    
    if (preg_match('/ВЕРДИКТ:\s*([А-ЯЁ]+)/u', $expertResponse, $verdictMatch)) {
        $verdict = $verdictMatch[1];
    } else {
        $verdict = 'НЕИЗВЕСТНО';
    }
    
    $results[] = ['question' => $question, 'score' => $score, 'verdict' => $verdict];
    
    echo "  ⭐ Оценка: $score/40 | Вердикт: $verdict\n\n";
    
    usleep(500000); // 0.5 сек пауза
}

echo str_repeat("=", 70) . "\n";
echo "ИТОГИ:\n\n";

$totalScore = 0;
$excellent = 0;
$good = 0;
$satisfactory = 0;
$poor = 0;

foreach ($results as $result) {
    $totalScore += $result['score'];
    
    if ($result['score'] >= 32) $excellent++;
    else if ($result['score'] >= 24) $good++;
    else if ($result['score'] >= 16) $satisfactory++;
    else $poor++;
    
    $emoji = $result['score'] >= 32 ? '🟢' : ($result['score'] >= 24 ? '🟡' : ($result['score'] >= 16 ? '🟠' : '🔴'));
    echo "$emoji {$result['question']}: {$result['score']}/40 ({$result['verdict']})\n";
}

$avgScore = $totalScore / count($results);

echo "\n";
echo "Средний балл: " . round($avgScore, 1) . "/40\n";
echo "ОТЛИЧНО: $excellent\n";
echo "ХОРОШО: $good\n";
echo "УДОВЛЕТВОРИТЕЛЬНО: $satisfactory\n";
echo "ПЛОХО: $poor\n";
?>
