<?php
/**
 * Прямой вызов executeStage1 для проблемных вопросов с логированием
 */

// Устанавливаем переменные окружения
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['HTTP_ORIGIN'] = 'https://test.medmaps.ru';
$_SERVER['HTTP_REFERER'] = 'https://test.medmaps.ru';

require_once '/root/config.php';

// Проблемные вопросы
$problematicQuestions = [
    'Отеки ног к вечеру',
    'Рентген костей',
];

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║  ТЕСТ ЛОГИРОВАНИЯ ПРОБЛЕМНЫХ ВОПРОСОВ                                   ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

// Очищаем логи перед тестом
file_put_contents('/root/ai-widget/logs/parser.log', '');

// Загружаем функции из query-stage1_1.php
// Но сначала нужно обойти проверку REQUEST_METHOD
$apiContent = file_get_contents('/root/api/query-stage1_1.php');

// Временно заменяем проверку REQUEST_METHOD
$apiContent = str_replace(
    "if (!isset(\$_SERVER['REQUEST_METHOD'])) {",
    "if (false && !isset(\$_SERVER['REQUEST_METHOD'])) {",
    $apiContent
);

// Выполняем код
eval('?>' . $apiContent);

// Получаем виджет из БД
$db = getDatabase();
$stmt = $db->prepare("SELECT w.*, ws.* FROM widgets w LEFT JOIN widget_settings ws ON w.id = ws.widget_id WHERE w.widget_key = ? AND w.active = 1");
$stmt->execute(['ekamedcenter']);
$widget = $stmt->fetch();

if (!$widget) {
    die("ОШИБКА: Виджет не найден\n");
}

$model = normalizeModelName($widget['stage1_model'] ?? 'meta-llama/llama-3.2-1b-instruct');
$systemPrompt = $widget['stage1_prompt'] ?? null;

foreach ($problematicQuestions as $question) {
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС: $question\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    try {
        $result = executeStage1($question, $model, $systemPrompt);
        
        echo "Результат:\n";
        echo "  Provider: " . ($result['provider'] ?? 'unknown') . "\n";
        echo "  Длина текста: " . mb_strlen($result['text'] ?? '') . "\n";
        echo "  Текст:\n";
        echo "  " . wordwrap($result['text'] ?? 'ПУСТО', 70, "\n  ") . "\n";
        echo "\n";
        
    } catch (Exception $e) {
        echo "ОШИБКА: " . $e->getMessage() . "\n";
        echo "Trace: " . $e->getTraceAsString() . "\n\n";
    }
    
    echo "\n";
    sleep(2);
}

echo "\n╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║  ЛОГИ ОБРАБОТКИ                                                          ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

$logs = file_get_contents('/root/ai-widget/logs/parser.log');
if (empty($logs)) {
    echo "Логи пусты. Проверьте права доступа к файлу /root/ai-widget/logs/parser.log\n";
} else {
    echo $logs;
}
