<?php
/**
 * Упрощенный тест проблемных вопросов БЕЗ AI оценки
 */

// Список проблемных вопросов
$badQuestions = [
    "Увеличение лимфоузлов подмышками",
    "Приступ удушья",
    "Синюшность пальцев",
    "Хроническая обструктивная болезнь легких",
    "Остеопороз профилактика",
    "Подагра приступ",
    "Сухость во рту",
    "Скарлатина симптомы",
    "Утренняя скованность суставов",
    "Люмбаго острая боль",
    "Пневмония симптомы",
    "Потеря обоняния",
    "Отек Квинке",
    "МРТ сустава",
    "Диспансеризация взрослых"
];

// Функция для вызова виджета через api-wrapper
function queryWidget($question, $section) {
    $cmd = sprintf(
        'php /root/api-wrapper.php %s %s %s 2>&1',
        escapeshellarg('ekamedcenter'),
        escapeshellarg($question),
        escapeshellarg($section)
    );
    
    $output = shell_exec($cmd);
    
    // Парсим JSON ответ - берем последнюю строку с JSON
    $lines = explode("\n", trim($output));
    foreach (array_reverse($lines) as $line) {
        if (empty(trim($line))) continue;
        $data = json_decode($line, true);
        if (json_last_error() === JSON_ERROR_NONE && isset($data['data'])) {
            // Формат: {"text":"...", "data":{"specialists":[...], ...}}
            $result = $data['data'];
            $result['text'] = isset($data['text']) ? $data['text'] : '';
            return $result;
        }
    }
    
    return null;
}

echo "═══════════════════════════════════════════════════════════════════\n";
echo "ТЕСТИРОВАНИЕ ПРОБЛЕМНЫХ ВОПРОСОВ (упрощенная проверка)\n";
echo "═══════════════════════════════════════════════════════════════════\n\n";

$totalQuestions = count($badQuestions);
$results = [];

foreach ($badQuestions as $index => $question) {
    $num = $index + 1;
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС {$num}/{$totalQuestions}: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Запрашиваем все секции
    $specialistsResponse = queryWidget($question, 'specialists');
    $servicesResponse = queryWidget($question, 'services');
    $specializationsResponse = queryWidget($question, 'specializations');
    
    if (!$specialistsResponse && !$servicesResponse && !$specializationsResponse) {
        echo "❌ ОШИБКА: Не удалось получить ответ от виджета\n\n";
        $results[] = [
            'question' => $question,
            'specialists_count' => 0,
            'services_count' => 0,
            'status' => 'ERROR'
        ];
        continue;
    }
    
    $specialists = isset($specialistsResponse['specialists']) ? $specialistsResponse['specialists'] : [];
    $services = isset($servicesResponse['services']) ? $servicesResponse['services'] : [];
    $specializations = isset($specializationsResponse['specializations']) ? $specializationsResponse['specializations'] : [];
    
    // Берем текст из любого ответа, где он есть
    $text = '';
    if (!empty($specialistsResponse['text']) && $specialistsResponse['text'] !== '[]') {
        $text = $specialistsResponse['text'];
    } elseif (!empty($servicesResponse['text']) && $servicesResponse['text'] !== '[]') {
        $text = $servicesResponse['text'];
    } elseif (!empty($specializationsResponse['text']) && $specializationsResponse['text'] !== '[]') {
        $text = $specializationsResponse['text'];
    }
    
    $specialistNames = array_column($specialists, 'name');
    $serviceNames = array_column($services, 'name');
    $specializationNames = array_column($specializations, 'name');
    
    $specialistsStr = !empty($specialistNames) ? implode(', ', array_slice($specialistNames, 0, 3)) : '(нет)';
    if (count($specialistNames) > 3) $specialistsStr .= '... +' . (count($specialistNames) - 3);
    
    $servicesStr = !empty($serviceNames) ? implode(', ', array_slice($serviceNames, 0, 3)) : '(нет)';
    if (count($serviceNames) > 3) $servicesStr .= '... +' . (count($serviceNames) - 3);
    
    $specializationsStr = !empty($specializationNames) ? implode(', ', $specializationNames) : '(нет)';
    
    echo "📊 ОТВЕТ ВИДЖЕТА:\n";
    echo "  • Специалисты (" . count($specialists) . "): {$specialistsStr}\n";
    echo "  • Услуги (" . count($services) . "): {$servicesStr}\n";
    echo "  • Специализации (" . count($specializations) . "): {$specializationsStr}\n";
    
    if ($text && $text !== '[]') {
        $shortText = mb_substr($text, 0, 100);
        if (mb_strlen($text) > 100) $shortText .= '...';
        echo "  • Текст: {$shortText}\n";
    }
    
    // Простая оценка
    $status = 'GOOD';
    if (count($specialists) == 0 && count($services) == 0 && empty($text)) {
        $status = 'BAD';
    } elseif (count($specialists) == 0 || count($services) == 0) {
        $status = 'PARTIAL';
    }
    
    $emoji = match($status) {
        'GOOD' => '🟢',
        'PARTIAL' => '🟡',
        'BAD' => '🔴',
        default => '⚪'
    };
    
    echo "\n{$emoji} Статус: {$status}\n\n";
    
    $results[] = [
        'question' => $question,
        'specialists_count' => count($specialists),
        'services_count' => count($services),
        'specializations_count' => count($specializations),
        'has_text' => !empty($text) && $text !== '[]',
        'status' => $status
    ];
}

// Итоговая статистика
echo "\n═══════════════════════════════════════════════════════════════════\n";
echo "ИТОГОВАЯ СТАТИСТИКА\n";
echo "═══════════════════════════════════════════════════════════════════\n\n";

$statusCounts = [
    'GOOD' => 0,
    'PARTIAL' => 0,
    'BAD' => 0,
    'ERROR' => 0
];

foreach ($results as $result) {
    $statusCounts[$result['status']]++;
}

echo "🟢 ХОРОШО (спец. и услуги): " . $statusCounts['GOOD'] . " (" . round($statusCounts['GOOD'] / $totalQuestions * 100, 1) . "%)\n";
echo "🟡 ЧАСТИЧНО (спец. ИЛИ услуги): " . $statusCounts['PARTIAL'] . " (" . round($statusCounts['PARTIAL'] / $totalQuestions * 100, 1) . "%)\n";
echo "🔴 ПЛОХО (ничего нет): " . $statusCounts['BAD'] . " (" . round($statusCounts['BAD'] / $totalQuestions * 100, 1) . "%)\n";
echo "⚫ ОШИБКА: " . $statusCounts['ERROR'] . " (" . round($statusCounts['ERROR'] / $totalQuestions * 100, 1) . "%)\n";

// Список проблемных
$stillBad = array_filter($results, fn($r) => $r['status'] === 'BAD' || $r['status'] === 'PARTIAL');
if (!empty($stillBad)) {
    echo "\n⚠️ Вопросы, требующие дополнительной доработки (" . count($stillBad) . "):\n";
    foreach ($stillBad as $bad) {
        echo "  • {$bad['question']} (спец: {$bad['specialists_count']}, услуг: {$bad['services_count']})\n";
    }
}

echo "\n✅ Тест завершен!\n";

