<?php
/**
 * Прямой тест API для проверки ответа AI
 */

$question = 'Отек Квинке';
$widget_key = 'medmaps';
$section_name = 'specialists';

$url = "http://localhost/api/query-section.php?widget_key={$widget_key}&question=" . urlencode($question) . "&section_name={$section_name}";

echo "=== ТЕСТ API ДЛЯ ВОПРОСА: {$question} ===\n\n";
echo "URL: {$url}\n\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Code: {$httpCode}\n";
if ($error) {
    echo "CURL Error: {$error}\n";
}

echo "\n=== RESPONSE ===\n";
$data = json_decode($response, true);
if ($data) {
    echo "Response (formatted):\n";
    print_r($data);
    
    if (isset($data['data'])) {
        echo "\n=== DATA ===\n";
        echo "Count: " . count($data['data']) . "\n";
        if (count($data['data']) > 0) {
            echo "First item:\n";
            print_r($data['data'][0]);
        } else {
            echo "DATA IS EMPTY!\n";
        }
    }
} else {
    echo "Raw response:\n";
    echo substr($response, 0, 1000) . "\n";
}
