<?php
/**
 * Тестовый скрипт для проверки ответа AI на проблемные вопросы
 */

require_once '/root/config.php';
require_once '/root/api/query-section.php';

// Тестовый вопрос
$question = 'Отек Квинке';
$widget_key = 'medmaps'; // Используем существующий виджет
$section_name = 'specialists';

// Получаем виджет
$db = getDB();
$stmt = $db->prepare("SELECT * FROM widgets WHERE widget_key = ?");
$stmt->execute([$widget_key]);
$widget = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$widget) {
    die("Widget not found\n");
}

echo "=== ТЕСТ ОТВЕТА AI ДЛЯ ВОПРОСА: {$question} ===\n\n";
echo "Widget ID: {$widget['id']}\n";
echo "Section: {$section_name}\n\n";

// Симулируем вызов query-section.php
$_GET['widget_key'] = $widget_key;
$_GET['question'] = $question;
$_GET['section_name'] = $section_name;

// Перехватываем вывод
ob_start();

try {
    // Вызываем функцию напрямую
    // Нужно найти функцию, которая обрабатывает запрос
    // Или вызвать код из query-section.php
    
    // Для начала проверим, что возвращает sendClaudeRequest
    require_once '/root/api/claude-api.php';
    
    // Создаем промпт для специалистов
    $promptData = [
        'question' => $question,
        'widget_id' => $widget['id'],
        'section_name' => $section_name
    ];
    
    // Получаем системный промпт
    $sectionModel = $widget['stage3_model'] ?? 'qwen/qwen3-235b-a22b-2507';
    $stage3SystemPrompt = getStage3SystemPrompt($widget, $section_name);
    
    echo "=== ОТПРАВКА ЗАПРОСА К AI ===\n";
    echo "Model: {$sectionModel}\n";
    echo "System Prompt (first 200 chars): " . substr($stage3SystemPrompt, 0, 200) . "...\n\n";
    
    $debugInfo = null;
    $claudeResponse = sendClaudeRequest($stage3SystemPrompt, $promptData, $question, false, $sectionModel, false, $debugInfo, $widget['custom_api_url'] ?? null, $widget['custom_api_key'] ?? null, $section_name);
    
    echo "=== ОТВЕТ ОТ AI ===\n";
    echo "Success: " . ($claudeResponse['success'] ?? 'N/A') . "\n";
    echo "Error: " . ($claudeResponse['error'] ?? 'N/A') . "\n";
    echo "Full response:\n";
    print_r($claudeResponse);
    
    if (isset($claudeResponse['data_ids'])) {
        echo "\n=== DATA_IDS ===\n";
        print_r($claudeResponse['data_ids']);
        
        if (isset($claudeResponse['data_ids'][$section_name])) {
            echo "\n=== DATA_IDS[{$section_name}] ===\n";
            echo "Type: " . gettype($claudeResponse['data_ids'][$section_name]) . "\n";
            echo "Is array: " . (is_array($claudeResponse['data_ids'][$section_name]) ? 'YES' : 'NO') . "\n";
            echo "Count: " . (is_array($claudeResponse['data_ids'][$section_name]) ? count($claudeResponse['data_ids'][$section_name]) : 'N/A') . "\n";
            echo "Content: " . json_encode($claudeResponse['data_ids'][$section_name]) . "\n";
        } else {
            echo "\n=== DATA_IDS[{$section_name}] НЕ СУЩЕСТВУЕТ ===\n";
            echo "Available keys: " . implode(', ', array_keys($claudeResponse['data_ids'] ?? [])) . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Trace:\n" . $e->getTraceAsString() . "\n";
}

$output = ob_get_clean();
echo $output;

