<?php
/**
 * Прямой тест AI ответа, обходя проверки query-section.php
 */

// Устанавливаем переменные окружения для обхода проверок
$_SERVER['REQUEST_METHOD'] = 'POST';
$_GET['widget_key'] = 'medmaps';
$_GET['question'] = 'Отек Квинке';
$_GET['section_name'] = 'specialists';

require_once '/root/config.php';

// Получаем виджет
$db = getDB();
$stmt = $db->prepare("SELECT * FROM widgets WHERE widget_key = ?");
$stmt->execute(['medmaps']);
$widget = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$widget) {
    die("Widget not found\n");
}

echo "=== ТЕСТ AI ОТВЕТА ===\n\n";
echo "Question: {$_GET['question']}\n";
echo "Section: {$_GET['section_name']}\n";
echo "Widget ID: {$widget['id']}\n\n";

// Подключаем query.php для получения функции sendClaudeRequest
$originalMethod = $_SERVER['REQUEST_METHOD'];
$_SERVER['REQUEST_METHOD'] = 'CLI_TEST';
require_once '/root/api/query.php';
$_SERVER['REQUEST_METHOD'] = $originalMethod;

// Получаем данные для раздела
$section_name = $_GET['section_name'];
$items = getSectionItems($widget['id'], $section_name);

echo "Items in DB: " . count($items) . "\n\n";

// Создаем промпт данные
$promptData = [
    'question' => $_GET['question'],
    'widget_id' => $widget['id'],
    'section_name' => $section_name
];

// Получаем системный промпт
$sectionPromptField = 'stage_' . $section_name . '_prompt';
$sectionPrompt = !empty($widget[$sectionPromptField]) ? $widget[$sectionPromptField] : null;

if ($sectionPrompt) {
    $stage3SystemPrompt = $sectionPrompt;
} elseif (!empty($widget['stage3_prompt'])) {
    $stage3SystemPrompt = $widget['stage3_prompt'];
} else {
    $stage3SystemPrompt = $widget['claude_prompt'];
}

$sectionModel = normalizeModelName($widget['stage3_model'] ?? 'qwen/qwen3-235b-a22b-2507');

echo "=== ОТПРАВКА ЗАПРОСА К AI ===\n";
echo "Model: {$sectionModel}\n";
echo "System Prompt length: " . strlen($stage3SystemPrompt) . " chars\n\n";

$debugInfo = null;
$claudeResponse = sendClaudeRequest($stage3SystemPrompt, $promptData, $_GET['question'], false, $sectionModel, false, $debugInfo, $widget['custom_api_url'] ?? null, $widget['custom_api_key'] ?? null, $section_name);

echo "=== ОТВЕТ ОТ AI ===\n";
echo "Success: " . ($claudeResponse['success'] ?? 'N/A') . "\n";
if (isset($claudeResponse['error'])) {
    echo "Error: " . $claudeResponse['error'] . "\n";
}

if (isset($claudeResponse['data_ids'])) {
    echo "\n=== DATA_IDS ===\n";
    echo "Keys: " . implode(', ', array_keys($claudeResponse['data_ids'])) . "\n";
    
    if (isset($claudeResponse['data_ids'][$section_name])) {
        echo "\n=== DATA_IDS[{$section_name}] ===\n";
        echo "Type: " . gettype($claudeResponse['data_ids'][$section_name]) . "\n";
        echo "Is array: " . (is_array($claudeResponse['data_ids'][$section_name]) ? 'YES' : 'NO') . "\n";
        if (is_array($claudeResponse['data_ids'][$section_name])) {
            echo "Count: " . count($claudeResponse['data_ids'][$section_name]) . "\n";
            echo "Content: " . json_encode($claudeResponse['data_ids'][$section_name], JSON_UNESCAPED_UNICODE) . "\n";
        } else {
            echo "Value: " . var_export($claudeResponse['data_ids'][$section_name], true) . "\n";
        }
    } else {
        echo "\n=== DATA_IDS[{$section_name}] НЕ СУЩЕСТВУЕТ ===\n";
        echo "Full data_ids:\n";
        print_r($claudeResponse['data_ids']);
    }
} else {
    echo "\n=== DATA_IDS НЕ СУЩЕСТВУЕТ ===\n";
    echo "Full response:\n";
    print_r($claudeResponse);
}

