<?php

/**
 * Тест административных запросов (справки, комиссии, больничные)
 */

// Список административных вопросов для тестирования
$testQuestions = [
    // Транспортная комиссия (должно найти услуги)
    "Транспортная комиссия",
    "Справка для ГИБДД",
    "Медкомиссия на водительские права",
    "Нужна справка для получения водительских прав категории B",
    
    // Справка в бассейн (должно найти услуги)
    "Справка в бассейн",
    "Справка для посещения бассейна",
    
    // Справка для учебы (должно найти услуги)
    "Справка 086",
    "Справка для учебы в институт",
    "Медицинская справка для поступления в вуз",
    
    // Справка для санатория (должно найти услуги)
    "Справка в санаторий",
    "Справка для санаторно-курортного лечения",
    
    // Услуги, которых нет в клинике (должно вернуть сообщение об отсутствии)
    "Справка на оружие",
    "Справка на лицензию на оружие",
    "Больничный лист",
    "Нужен больничный на работу",
    "Медицинская книжка",
    "Санитарная книжка для работы",
    
    // Выписка из медкарты (специальное сообщение)
    "Выписка из медицинской карты",
    "Копия медицинской карты",
];

// Функция для вызова API через wrapper
function queryWidget($widgetKey, $question, $sectionName) {
    $cmd = sprintf(
        'php /root/api-wrapper.php %s %s %s 2>&1',
        escapeshellarg($widgetKey),
        escapeshellarg($question),
        escapeshellarg($sectionName)
    );
    
    $output = shell_exec($cmd);
    
    // Извлекаем только JSON часть (после строки "API query.php called from:")
    $lines = explode("\n", $output);
    $jsonLine = '';
    foreach ($lines as $line) {
        if (strpos($line, '{') === 0) {
            $jsonLine = $line;
            break;
        }
    }
    
    if (empty($jsonLine)) {
        return null;
    }
    
    return json_decode($jsonLine, true);
}

echo "=================================================================\n";
echo "ТЕСТ АДМИНИСТРАТИВНЫХ ЗАПРОСОВ\n";
echo "=================================================================\n\n";

$results = [
    'found_services' => 0,
    'not_available' => 0,
    'info_message' => 0,
    'errors' => 0
];

foreach ($testQuestions as $question) {
    echo "Вопрос: {$question}\n";
    
    $response = queryWidget('ekamedcenter', $question, 'services');
    
    if (!$response) {
        echo "  ❌ ОШИБКА: Не удалось получить ответ\n";
        $results['errors']++;
    } else {
        $text = $response['text'] ?? '';
        $servicesCount = count($response['data']['services'] ?? []);
        $specialistsCount = count($response['data']['specialists'] ?? []);
        
        echo "  Текст: {$text}\n";
        echo "  Услуги: {$servicesCount}, Специалисты: {$specialistsCount}\n";
        
        // Определяем тип ответа
        if (strpos($text, 'не предоставляется') !== false) {
            echo "  ✓ Правильно: услуга отсутствует\n";
            $results['not_available']++;
        } elseif (strpos($text, 'обратитесь в регистратуру') !== false) {
            echo "  ✓ Правильно: информационное сообщение\n";
            $results['info_message']++;
        } elseif ($servicesCount > 0 || $specialistsCount > 0) {
            echo "  ✓ Правильно: найдены услуги/специалисты\n";
            $results['found_services']++;
        } else {
            echo "  ⚠️ Подозрительно: нет данных и нет специального сообщения\n";
        }
    }
    
    echo "\n";
}

echo "=================================================================\n";
echo "ИТОГИ:\n";
echo "=================================================================\n";
echo "Найдено услуг/специалистов: {$results['found_services']}\n";
echo "Услуга отсутствует (корректное сообщение): {$results['not_available']}\n";
echo "Информационное сообщение: {$results['info_message']}\n";
echo "Ошибки: {$results['errors']}\n";
echo "\n";

$total = array_sum($results);
$success = $results['found_services'] + $results['not_available'] + $results['info_message'];

echo "Успешно обработано: {$success}/{$total}\n";

if ($results['errors'] > 0) {
    echo "\n⚠️ ВНИМАНИЕ: Есть ошибки при обработке запросов!\n";
} else {
    echo "\n✓ Все запросы обработаны без ошибок\n";
}
