<?php

// Быстрый тест трех административных запросов с экспертной оценкой

$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash';

function queryWidget($widgetKey, $question, $sectionName) {
    $cmd = sprintf(
        'php /root/api-wrapper.php %s %s %s 2>&1',
        escapeshellarg($widgetKey),
        escapeshellarg($question),
        escapeshellarg($sectionName)
    );
    
    $output = shell_exec($cmd);
    $lines = explode("\n", $output);
    $jsonLine = '';
    foreach ($lines as $line) {
        if (strpos($line, '{') === 0) {
            $jsonLine = $line;
            break;
        }
    }
    
    if (empty($jsonLine)) {
        return null;
    }
    
    return json_decode($jsonLine, true);
}

function evaluateWithExpert($question, $specialists, $services, $specializations, $model, $apiKey) {
    $widgetData = "ЗАПРОС ПАЦИЕНТА: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $widgetData .= "СПЕЦИАЛИСТЫ (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specialists, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без имени') . 
                          " - " . ($spec['description'] ?? 'Без специальности') . "\n";
        }
    }
    
    $widgetData .= "\nУСЛУГИ (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($services, 0, 5) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'Без названия') . "\n";
        }
    }
    
    $widgetData .= "\nСПЕЦИАЛИЗАЦИИ (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach ($specializations as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без названия') . "\n";
        }
    }
    
    $prompt = "Ты - медицинский эксперт. Оцени качество ответа медицинского виджета на запрос пациента.

{$widgetData}

ВАЖНО: Если запрос касается АДМИНИСТРАТИВНЫХ УСЛУГ (справки, больничные, медкомиссии):
- Если виджет вернул релевантные услуги/специалистов для комиссии - ставь высокую оценку
- Если виджет корректно сообщил об отсутствии услуги - ставь высокую оценку (это правильный ответ)
- Если виджет дал информацию о процедуре получения - ставь высокую оценку

Оцени ответ по шкале от 0 до 40 баллов:
- Релевантность специалистов (0-10): насколько правильно подобраны врачи
- Релевантность услуг (0-10): насколько услуги соответствуют запросу
- Корректность специализаций (0-10): правильно ли определены разделы медицины
- Полнота ответа (0-10): достаточно ли информации для пациента

Формат ответа:
ОЦЕНКА: X/40
ВЕРДИКТ: (ОТЛИЧНО/ХОРОШО/УДОВЛЕТВОРИТЕЛЬНО/ПЛОХО)";

    $data = [
        'model' => $model,
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ],
        'temperature' => 0.3,
        'max_tokens' => 500
    ];
    
    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json',
        'HTTP-Referer: https://wtest.medmaps.ru',
        'X-Title: AI Medical Widget Test'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return "ОШИБКА: HTTP {$httpCode}";
    }
    
    $result = json_decode($response, true);
    return $result['choices'][0]['message']['content'] ?? 'Ошибка парсинга ответа';
}

$questions = [
    'Справка на оружие',
    'Транспортная комиссия',
    'Выписка из медицинской карты'
];

echo "\n╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║   ТЕСТ АДМИНИСТРАТИВНЫХ ЗАПРОСОВ С ЭКСПЕРТНОЙ ОЦЕНКОЙ                   ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

foreach ($questions as $i => $question) {
    $num = $i + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС {$num}/3: {$question}\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $response = queryWidget('ekamedcenter', $question, 'services');
    
    if (!$response) {
        echo "  ❌ ОШИБКА: Не удалось получить ответ\n\n";
        continue;
    }
    
    $specialists = $response['data']['specialists'] ?? [];
    $services = $response['data']['services'] ?? [];
    $specializations = $response['data']['specializations'] ?? [];
    $text = $response['text'] ?? '';
    
    echo "  → Запрос к виджету... OK ({$num} спец., " . count($services) . " усл., " . count($specializations) . " спец.)\n";
    echo "  → Текст ответа: {$text}\n";
    echo "  → Запрос к Gemini...";
    
    $evaluation = evaluateWithExpert($question, $specialists, $services, $specializations, $openrouterModel, $openrouterKey);
    echo " OK\n\n";
    
    // Извлекаем оценку и вердикт
    preg_match('/ОЦЕНКА:\s*(\d+)\/40/i', $evaluation, $scoreMatches);
    preg_match('/ВЕРДИКТ:\s*(ОТЛИЧНО|ХОРОШО|УДОВЛЕТВОРИТЕЛЬНО|ПЛОХО)/ui', $evaluation, $verdictMatches);
    
    $score = $scoreMatches[1] ?? '?';
    $verdict = $verdictMatches[1] ?? '?';
    
    // Цветной вывод
    $verdictEmoji = [
        'ОТЛИЧНО' => '🟢',
        'ХОРОШО' => '🔵',
        'УДОВЛЕТВОРИТЕЛЬНО' => '🟡',
        'ПЛОХО' => '🔴'
    ];
    
    echo "  " . ($verdictEmoji[$verdict] ?? '') . " ОЦЕНКА: {$score}/40 | ВЕРДИКТ: {$verdict}\n";
    echo "\n" . $evaluation . "\n\n";
}

echo "\n✅ Тест завершен\n\n";


