<?php
/**
 * Тест виджета с экспертной оценкой от GPT-4 - 50 вопросов
 */

// Конфигурация
$widgetKey = 'ekamedcenter';
$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash';

// 50 разнообразных медицинских вопросов
$questions = [
    // Неврология (10)
    'Острая боль в спине',
    'Головокружение при ходьбе',
    'Бессонница что делать',
    'Мигрень сильная головная боль',
    'Онемение пальцев рук',
    'Остеохондроз шейного отдела',
    'Невралгия межреберная',
    'Хроническая усталость и слабость',
    'Радикулит обострение',
    'Судороги в ногах ночью',
    
    // Терапия (10)
    'Повышенная температура',
    'Простуда и насморк',
    'Кашель сухой что делать',
    'Слабость и утомляемость',
    'Боль в грудной клетке',
    'Потеря аппетита',
    'Анемия низкий гемоглобин',
    'Частые простуды',
    'Ночная потливость',
    'Подозрение на диабет',
    
    // Кардиология (5)
    'Высокое давление и головная боль',
    'Одышка при нагрузке',
    'Боль в груди',
    'Аритмия перебои в сердце',
    'Тахикардия учащенное сердцебиение',
    
    // Гастроэнтерология (5)
    'Тошнота после еды',
    'Боль в желудке после еды',
    'Изжога и отрыжка',
    'Запор хронический',
    'Диарея частый жидкий стул',
    
    // Урология (3)
    'Частое мочеиспускание',
    'Боль при мочеиспускании',
    'Цистит симптомы',
    
    // ЛОР (3)
    'Кровотечение из носа',
    'Боль в горле и температура',
    'Заложен нос не дышит',
    
    // Дерматология (3)
    'Сыпь на коже зуд',
    'Акне прыщи на лице',
    'Псориаз лечение',
    
    // Эндокринология (3)
    'Высокий холестерин',
    'Проблемы со щитовидной железой',
    'Лишний вес как похудеть',
    
    // Аллергология (2)
    'Аллергия на пыльцу',
    'Крапивница сыпь и зуд',
    
    // Офтальмология (2)
    'Покраснение глаз и слезотечение',
    'Подбор очков для зрения',
    
    // Травматология (2)
    'Вывих голеностопа',
    'Перелом руки',
    
    // Хирургия (2)
    'Грыжа паховая',
    'Аппендицит симптомы'
];

$timestamp = date('Y-m-d_H-i-s');
$reportFile = "/root/ai_expert_50_review_{$timestamp}.txt";
$summaryFile = "/root/ai_expert_50_summary_{$timestamp}.txt";

// Функция для запроса к виджету
function queryWidget($question, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [];
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        
        // Убираем debug строки
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$section])) {
            $result[$section] = $decoded['data'][$section];
        } else {
            $result[$section] = [];
        }
        
        usleep(100000); // 0.1 sec pause
    }
    
    return $result;
}

// Функция для запроса к OpenRouter GPT-4
function askExpert($question, $widgetResponse, $openrouterKey, $model) {
    $specialists = $widgetResponse['specialists'] ?? [];
    $services = $widgetResponse['services'] ?? [];
    $specializations = $widgetResponse['specializations'] ?? [];
    
    // Формируем текст для анализа
    $widgetData = "ЗАПРОС ПАЦИЕНТА: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $widgetData .= "СПЕЦИАЛИСТЫ (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specialists, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без имени') . 
                          " - " . ($spec['description'] ?? 'Без специальности') . "\n";
        }
        if (count($specialists) > 5) {
            $widgetData .= "  ... и ещё " . (count($specialists) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nУСЛУГИ (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($services, 0, 5) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'Без названия') . "\n";
        }
        if (count($services) > 5) {
            $widgetData .= "  ... и ещё " . (count($services) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nСПЕЦИАЛИЗАЦИИ (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach ($specializations as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без названия') . "\n";
        }
    }
    
    // Промпт для эксперта
    $expertPrompt = "Ты - медицинский эксперт, оценивающий качество работы AI-ассистента медицинской клиники.

$widgetData

ТВОЯ ЗАДАЧА: Оцени насколько хорошо виджет ответил на запрос пациента.

КРИТЕРИИ ОЦЕНКИ:
1. РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ (0-10): Правильно ли подобраны специалисты?
2. РЕЛЕВАНТНОСТЬ УСЛУГ (0-10): Соответствуют ли услуги запросу?
3. КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ (0-10): Правильно ли определены специализации?
4. ПОЛНОТА ОТВЕТА (0-10): Получит ли пациент необходимую помощь?

ФОРМАТ ОТВЕТА:
```
ОЦЕНКА: X/40
РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ: X/10 - краткое пояснение
РЕЛЕВАНТНОСТЬ УСЛУГ: X/10 - краткое пояснение
КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ: X/10 - краткое пояснение
ПОЛНОТА ОТВЕТА: X/10 - краткое пояснение

ВЕРДИКТ: [ОТЛИЧНО / ХОРОШО / УДОВЛЕТВОРИТЕЛЬНО / ПЛОХО]

РЕКОМЕНДАЦИИ: что можно улучшить (если есть)
```

ВАЖНО: 
- Будь объективен
- Оценивай по 4-балльной шкале: 0-19 = ПЛОХО, 20-27 = УДОВЛЕТВОРИТЕЛЬНО, 28-35 = ХОРОШО, 36-40 = ОТЛИЧНО
- Учитывай что клиника может не иметь всех возможных специалистов
- Давай конструктивные рекомендации";

    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $openrouterKey,
        'Content-Type: application/json',
        'HTTP-Referer: https://ekamedcenter.ru',
        'X-Title: AI Widget Expert Review'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'model' => $model,
        'messages' => [
            ['role' => 'user', 'content' => $expertPrompt]
        ]
    ]));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return [
            'success' => false,
            'error' => "HTTP $httpCode",
            'score' => 0,
            'verdict' => 'ОШИБКА'
        ];
    }
    
    $decoded = json_decode($response, true);
    if (!$decoded || !isset($decoded['choices'][0]['message']['content'])) {
        return [
            'success' => false,
            'error' => 'Invalid response',
            'score' => 0,
            'verdict' => 'ОШИБКА'
        ];
    }
    
    $expertReview = $decoded['choices'][0]['message']['content'];
    
    // Парсим оценку и вердикт
    preg_match('/ОЦЕНКА:\s*(\d+)\/40/i', $expertReview, $scoreMatch);
    preg_match('/ВЕРДИКТ:\s*(ОТЛИЧНО|ХОРОШО|УДОВЛЕТВОРИТЕЛЬНО|ПЛОХО)/iu', $expertReview, $verdictMatch);
    
    return [
        'success' => true,
        'review' => $expertReview,
        'score' => isset($scoreMatch[1]) ? (int)$scoreMatch[1] : 0,
        'verdict' => isset($verdictMatch[1]) ? mb_strtoupper($verdictMatch[1]) : 'НЕИЗВЕСТНО'
    ];
}

// Запускаем тест
$startTime = microtime(true);
$results = [];
$totalScore = 0;
$verdictCounts = ['ОТЛИЧНО' => 0, 'ХОРОШО' => 0, 'УДОВЛЕТВОРИТЕЛЬНО' => 0, 'ПЛОХО' => 0, 'ОШИБКА' => 0];

echo "╔══════════════════════════════════════════════════════════════════════════╗\n";
echo "║       ТЕСТИРОВАНИЕ С ЭКСПЕРТНОЙ ОЦЕНКОЙ GPT-4 (50 ВОПРОСОВ)            ║\n";
echo "╚══════════════════════════════════════════════════════════════════════════╝\n\n";

$detailedReport = "ДЕТАЛЬНЫЙ ОТЧЕТ ЭКСПЕРТНОЙ ОЦЕНКИ AI ВИДЖЕТА\n";
$detailedReport .= "50 медицинских вопросов\n";
$detailedReport .= "Дата: " . date('Y-m-d H:i:s') . "\n";
$detailedReport .= str_repeat("=", 80) . "\n\n";

foreach ($questions as $index => $question) {
    $num = $index + 1;
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "ВОПРОС $num/50: $question\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    // Запрос к виджету
    echo "  → Запрос к виджету... ";
    $widgetResponse = queryWidget($question, $widgetKey);
    $specCount = count($widgetResponse['specialists'] ?? []);
    $servCount = count($widgetResponse['services'] ?? []);
    $spezCount = count($widgetResponse['specializations'] ?? []);
    echo "OK ($specCount спец., $servCount усл., $spezCount спез.)\n";
    
    // Запрос к эксперту
    echo "  → Запрос к GPT-4 эксперту... ";
    $expertResult = askExpert($question, $widgetResponse, $openrouterKey, $openrouterModel);
    
    if ($expertResult['success']) {
        echo "OK\n\n";
        echo "  ⭐ ОЦЕНКА: {$expertResult['score']}/40 | ВЕРДИКТ: {$expertResult['verdict']}\n\n";
        
        $totalScore += $expertResult['score'];
        $verdictCounts[$expertResult['verdict']]++;
        
        // Сохраняем в детальный отчет
        $detailedReport .= "ВОПРОС $num/50: $question\n";
        $detailedReport .= str_repeat("=", 80) . "\n\n";
        $detailedReport .= "ОТВЕТ ВИДЖЕТА:\n";
        $detailedReport .= str_repeat("-", 80) . "\n";
        $detailedReport .= "Специалисты: $specCount\n";
        $detailedReport .= "Услуги: $servCount\n";
        $detailedReport .= "Специализации: $spezCount\n\n";
        $detailedReport .= "ЭКСПЕРТНАЯ ОЦЕНКА GPT-4:\n";
        $detailedReport .= str_repeat("-", 80) . "\n";
        $detailedReport .= $expertResult['review'] . "\n\n\n";
        
        $results[] = [
            'question' => $question,
            'score' => $expertResult['score'],
            'verdict' => $expertResult['verdict']
        ];
    } else {
        echo "ОШИБКА: {$expertResult['error']}\n\n";
        $verdictCounts['ОШИБКА']++;
        $results[] = [
            'question' => $question,
            'score' => 0,
            'verdict' => 'ОШИБКА'
        ];
    }
    
    // Небольшая пауза между запросами
    sleep(1);
}

$endTime = microtime(true);
$duration = round($endTime - $startTime, 2);
$avgScore = count($results) > 0 ? round($totalScore / count($results), 1) : 0;

// Итоговая статистика
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "ИТОГОВАЯ СТАТИСТИКА\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "Средняя оценка: $avgScore/40\n";
echo "Общий балл: $totalScore/" . (count($results) * 40) . "\n\n";
echo "Распределение вердиктов:\n";
foreach ($verdictCounts as $verdict => $count) {
    if ($count > 0) {
        echo "  • $verdict: $count\n";
    }
}

// TOP-3
usort($results, function($a, $b) { return $b['score'] - $a['score']; });
echo "\nTOP-3 ЛУЧШИХ ОТВЕТА:\n";
echo str_repeat("-", 80) . "\n";
for ($i = 0; $i < min(3, count($results)); $i++) {
    $r = $results[$i];
    echo ($i+1) . ". {$r['question']} - {$r['score']}/40 ({$r['verdict']})\n";
}

echo "\nTOP-3 ПРОБЛЕМНЫХ ОТВЕТА:\n";
echo str_repeat("-", 80) . "\n";
$reversed = array_reverse($results);
for ($i = 0; $i < min(3, count($reversed)); $i++) {
    $r = $reversed[$i];
    echo ($i+1) . ". {$r['question']} - {$r['score']}/40 ({$r['verdict']})\n";
}

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ ТЕСТ ЗАВЕРШЕН!\n\n";
echo "Время выполнения: $duration сек\n";
echo "📁 Детальный отчет: $reportFile\n";
echo "📁 Краткая сводка: $summaryFile\n\n";

// Сохраняем детальный отчет
file_put_contents($reportFile, $detailedReport);

// Создаем краткую сводку
$summary = "КРАТКАЯ СВОДКА ЭКСПЕРТНОЙ ОЦЕНКИ\n";
$summary .= "50 медицинских вопросов\n";
$summary .= "Дата: " . date('Y-m-d H:i:s') . "\n";
$summary .= str_repeat("=", 80) . "\n\n";
$summary .= "Средняя оценка: $avgScore/40\n";
$summary .= "Общий балл: $totalScore/" . (count($results) * 40) . "\n\n";
$summary .= "Распределение вердиктов:\n";
foreach ($verdictCounts as $verdict => $count) {
    if ($count > 0) {
        $percent = round(($count / count($results)) * 100);
        $summary .= "  $verdict: $count ($percent%)\n";
    }
}
$summary .= "\nВремя выполнения: $duration сек\n";

file_put_contents($summaryFile, $summary);

