<?php
$testQuestions = [
    'Горечь во рту',
    'Сухость во рту',
    'Метеоризм газообразование',
    'Подагра приступ'
];

$widgetKey = 'ekamedcenter';

foreach ($testQuestions as $question) {
    echo "\n" . str_repeat("=", 80) . "\n";
    echo "ВОПРОС: {$question}\n";
    echo str_repeat("=", 80) . "\n";
    
    foreach (['specialists', 'services', 'specializations'] as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data'][$section])) {
            $items = $decoded['data'][$section];
            echo "\n{$section} ({" . count($items) . "}):\n";
            if ($section === 'services') {
                foreach (array_slice($items, 0, 5) as $i => $item) {
                    echo "  " . ($i+1) . ". {$item['name']}\n";
                }
            } elseif ($section === 'specialists') {
                foreach (array_slice($items, 0, 3) as $i => $item) {
                    echo "  " . ($i+1) . ". {$item['name']} - {$item['description']}\n";
                }
            } elseif ($section === 'specializations') {
                foreach ($items as $i => $item) {
                    echo "  " . ($i+1) . ". {$item['name']}\n";
                }
            }
        }
    }
    echo "\n";
}
