<?php
/**
 * Тест виджета с экспертной оценкой от GPT-4o (OpenRouter)
 * 310 вопросов - полный набор
 */

// Конфигурация
$widgetKey = 'ekamedcenter';
$openrouterKey = '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';
$openrouterModel = 'google/gemini-2.5-flash'; // Gemini 2.5 Flash

// 310 тестовых вопросов
$questions = [
    // === НЕВРОЛОГИЯ (30 вопросов) ===
    'Острая боль в спине',
    'Болит поясница и отдает в ногу',
    'Боль в шее и головокружение',
    'Головокружение при ходьбе',
    'Бессонница что делать',
    'Мигрень сильная головная боль',
    'Головная боль в висках',
    'Онемение пальцев рук',
    'Защемление нерва в спине',
    'Межпозвоночная грыжа лечение',
    'Остеохондроз шейного отдела',
    'Тремор рук причины',
    'Невралгия межреберная',
    'Боль при повороте головы',
    'Хроническая усталость и слабость',
    'Нарушение координации движений',
    'Головная боль после сна',
    'Боль в затылке',
    'Прострелы в пояснице',
    'Радикулит обострение',
    'Боль вдоль позвоночника',
    'Судороги в ногах ночью',
    'Покалывание в конечностях',
    'Боль в пояснице отдает в ягодицу',
    'Невропатия нижних конечностей',
    'Боль в шейно-воротниковой зоне',
    'Головная боль и тошнота',
    'Хроническая головная боль',
    'Боль в спине после сна',
    'Люмбаго острая боль',

    // === ТЕРАПИЯ (40 вопросов) ===
    'Повышенная температура 38 и слабость',
    'Повышенная температура',
    'Простуда и насморк',
    'ОРВИ симптомы и лечение',
    'Грипп высокая температура',
    'Кашель сухой что делать',
    'Слабость и утомляемость',
    'Записаться к терапевту',
    'Общий анализ крови сдать',
    'Профилактический осмотр',
    'Диспансеризация взрослых',
    'Медосмотр для работы',
    'Кашель с мокротой',
    'Боль в мышцах и суставах',
    'Субфебрильная температура',
    'Увеличены лимфоузлы на шее',
    'Боль в грудной клетке',
    'Затрудненное дыхание',
    'Учащенное сердцебиение',
    'Потеря аппетита',
    'Резкая потеря веса',
    'Постоянная слабость',
    'Анемия низкий гемоглобин',
    'Авитаминоз весной',
    'Иммунитет как укрепить',
    'Частые простуды',
    'Бронхит лечение',
    'Пневмония симптомы',
    'Плеврит боль при дыхании',
    'Одышка в покое',
    'Хроническая обструктивная болезнь легких',
    'Ночная потливость',
    'Озноб без температуры',
    'Увеличение лимфоузлов подмышками',
    'Боль за грудиной',
    'Кашель более двух недель',
    'Сухость во рту',
    'Постоянная жажда',
    'Частое мочеиспускание и жажда',
    'Подозрение на диабет',

    // === КАРДИОЛОГИЯ (25 вопросов) ===
    'Высокое давление и головная боль',
    'Одышка при нагрузке',
    'Боль в груди',
    'Боль в сердце колющая',
    'Аритмия перебои в сердце',
    'Тахикардия учащенное сердцебиение',
    'Давление 140 на 90',
    'Гипертония лечение',
    'Боль в левой руке и груди',
    'ЭКГ сделать',
    'УЗИ сердца эхокардиография',
    'Холтер мониторинг',
    'Низкое давление гипотония',
    'Головокружение и слабость при вставании',
    'Боль в груди при физической нагрузке',
    'Стенокардия приступ',
    'Инфаркт профилактика',
    'Высокий холестерин',
    'Атеросклероз сосудов',
    'Варикозное расширение вен',
    'Отеки ног к вечеру',
    'Тяжесть в ногах',
    'Боль в икрах при ходьбе',
    'Синюшность пальцев',
    'Нарушение ритма сердца',

    // === ГАСТРОЭНТЕРОЛОГИЯ (30 вопросов) ===
    'Тошнота после еды и боль в животе',
    'Тошнота после еды',
    'Изжога и отрыжка',
    'Боль в правом подреберье',
    'Боль в желудке',
    'Гастрит обострение',
    'Язва желудка симптомы',
    'Вздутие живота',
    'Диарея понос',
    'Запор что делать',
    'Тяжесть в желудке после еды',
    'Горечь во рту',
    'Тошнота по утрам',
    'Рвота и понос',
    'Боль в животе после еды',
    'Панкреатит боль в поджелудочной',
    'Холецистит боль справа',
    'Боль в левом подреберье',
    'Колит кишечника',
    'Дисбактериоз кишечника',
    'Метеоризм газообразование',
    'Боль в области пупка',
    'Боль внизу живота',
    'Гастроскопия ФГДС',
    'УЗИ брюшной полости',
    'Печеночные пробы анализ',
    'Хронический гастрит',
    'Рефлюкс эзофагит',
    'Синдром раздраженного кишечника',
    'Потеря аппетита',

    // === УРОЛОГИЯ (20 вопросов) ===
    'Частое мочеиспускание и жжение',
    'Частое мочеиспускание',
    'Боль при мочеиспускании',
    'Цистит у женщин',
    'Пиелонефрит воспаление почек',
    'Боль в почках',
    'Мочекаменная болезнь',
    'Простатит у мужчин',
    'Аденома простаты',
    'Недержание мочи',
    'Кровь в моче',
    'Боль внизу живота у мужчин',
    'Затрудненное мочеиспускание',
    'Частые позывы в туалет ночью',
    'УЗИ почек и мочевого пузыря',
    'Анализ мочи общий',
    'Уролог консультация',
    'Боль в паху у мужчин',
    'Отеки под глазами',
    'Почечная колика',

    // === ЛОР (25 вопросов) ===
    'Болит горло и трудно глотать',
    'Заложенность носа и насморк',
    'Боль в ухе и ухудшение слуха',
    'Кашель и боль в горле',
    'Кровотечение из носа',
    'Ангина гнойная',
    'Фарингит воспаление горла',
    'Тонзиллит хронический',
    'Гайморит боль в пазухах',
    'Синусит головная боль',
    'Ринит аллергический',
    'Отит боль в ухе',
    'Снижение слуха',
    'Шум в ушах',
    'Заложенность уха',
    'Потеря обоняния',
    'Першение в горле',
    'Охриплость голоса',
    'Ларингит потеря голоса',
    'Трахеит кашель',
    'Насморк не проходит',
    'Полипы в носу',
    'Искривление носовой перегородки',
    'Промывание носа кукушка',
    'ЛОР осмотр',

    // === ДЕРМАТОЛОГИЯ (20 вопросов) ===
    'Акне на лице что делать',
    'Псориаз обострение лечение',
    'Розацеа покраснение лица',
    'Зуд кожи и высыпания',
    'Экзема на руках',
    'Дерматит аллергический',
    'Атопический дерматит',
    'Грибок ногтей',
    'Грибок стопы',
    'Бородавки удаление',
    'Папилломы на шее',
    'Герпес на губах',
    'Лишай розовый',
    'Крапивница сыпь',
    'Угревая сыпь лечение',
    'Пигментные пятна на коже',
    'Себорейный дерматит',
    'Витилиго лечение',
    'Чесотка зуд',
    'Ожог лечение',

    // === ЭНДОКРИНОЛОГИЯ (15 вопросов) ===
    'Сахарный диабет консультация',
    'Высокий сахар в крови',
    'Заболевания щитовидной железы',
    'Гипотиреоз симптомы',
    'Гипертиреоз',
    'Зоб щитовидной железы',
    'Ожирение лишний вес',
    'Лишний вес как похудеть',
    'Гормональный сбой',
    'Климакс у женщин',
    'Остеопороз профилактика',
    'Повышенная потливость',
    'УЗИ щитовидной железы',
    'Анализ на гормоны щитовидной железы',
    'Высокий холестерин',

    // === АЛЛЕРГОЛОГИЯ (15 вопросов) ===
    'Аллергия на пыльцу поллиноз',
    'Пищевая аллергия',
    'Аллергия на лекарства',
    'Аллергический ринит',
    'Крапивница аллергическая',
    'Отек Квинке',
    'Бронхиальная астма',
    'Приступ удушья',
    'Аллергия на животных',
    'Аллергопробы кожные тесты',
    'Иммунотерапия АСИТ',
    'Аллергия на холод',
    'Аллергия на солнце',
    'Атопический дерматит у взрослых',
    'Аллерголог консультация',

    // === ОФТАЛЬМОЛОГИЯ (15 вопросов) ===
    'Ухудшение зрения близорукость',
    'Дальнозоркость у взрослых',
    'Астигматизм коррекция',
    'Подбор очков',
    'Подбор контактных линз',
    'Покраснение глаз',
    'Конъюнктивит глаз',
    'Ячмень на глазу',
    'Сухость глаз',
    'Синдром сухого глаза',
    'Катаракта операция',
    'Глаукома лечение',
    'Проверка зрения',
    'Диагностика зрения',
    'Офтальмолог консультация',

    // === ТРАВМАТОЛОГИЯ (20 вопросов) ===
    'Перелом руки симптомы',
    'Вывих сустава',
    'Растяжение связок',
    'Ушиб колена',
    'Боль в коленном суставе',
    'Артроз коленного сустава',
    'Боль в тазобедренном суставе',
    'Боль в плечевом суставе',
    'Травма лодыжки',
    'Боль в голеностопе',
    'Боль в локтевом суставе',
    'Плоскостопие у взрослых',
    'Пяточная шпора',
    'Артрит суставов',
    'Бурсит сустава',
    'Тендинит воспаление сухожилий',
    'Разрыв мениска',
    'Травматолог консультация',
    'Рентген костей',
    'МРТ сустава',

    // === ХИРУРГИЯ (10 вопросов) ===
    'Аппендицит симптомы',
    'Грыжа паховая',
    'Грыжа пупочная',
    'Желчнокаменная болезнь',
    'Варикоцеле у мужчин',
    'Геморрой лечение',
    'Трещина заднего прохода',
    'Панариций гнойник на пальце',
    'Липома жировик',
    'Хирург консультация',

    // === ГИНЕКОЛОГИЯ (10 вопросов) ===
    'Нарушение менструального цикла',
    'Боль внизу живота у женщин',
    'Обильные месячные',
    'Задержка месячных',
    'Киста яичника',
    'Миома матки',
    'Эндометриоз симптомы',
    'Молочница у женщин',
    'УЗИ малого таза',
    'Гинеколог консультация',

    // === ПЕДИАТРИЯ (15 вопросов) ===
    'Температура у ребенка',
    'Кашель у ребенка',
    'Сопли у ребенка',
    'Колики у новорожденного',
    'Диатез у ребенка',
    'Ветрянка у детей',
    'Краснуха симптомы',
    'Корь у детей',
    'Скарлатина симптомы',
    'Коклюш у детей',
    'Прививки детям',
    'Педиатр консультация',
    'Анализы ребенку',
    'Плановый осмотр ребенка',
    'Справка для детского сада',

    // === РЕВМАТОЛОГИЯ (10 вопросов) ===
    'Ревматоидный артрит',
    'Подагра приступ',
    'Системная красная волчанка',
    'Боль во всех суставах',
    'Утренняя скованность суставов',
    'Ревматизм лечение',
    'Остеоартроз',
    'Полиартрит',
    'Ревматолог консультация',
    'Анализы на ревмопробы',

    // === АДМИНИСТРАТИВНЫЕ (10 вопросов) ===
    'Справка в бассейн',
    'Справка для ГИБДД',
    'Справка на оружие',
    'Медицинская книжка',
    'Справка для визы',
    'Выписка из медицинской карты',
    'Больничный лист',
    'Справка о болезни',
    'Медицинская справка 086у',
    'Транспортная комиссия'
];

$timestamp = date('Y-m-d_H-i-s');
$reportFile = "/root/ai_expert_300_review_{$timestamp}.txt";
$summaryFile = "/root/ai_expert_300_summary_{$timestamp}.txt";
$outputLog = "/root/test-300-output.log";

// Открываем лог файл для записи
$logHandle = fopen($outputLog, 'w');
if (!$logHandle) {
    die("Не удалось открыть лог файл: {$outputLog}\n");
}

function writeLog($message) {
    global $logHandle;
    fwrite($logHandle, $message . "\n");
    echo $message . "\n"; // Также выводим в консоль
}

// Функция для запроса к виджету (через wrapper)
function queryWidget($question, $widgetKey) {
    $sections = ['specialists', 'services', 'specializations'];
    $result = [];
    
    foreach ($sections as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        
        // Убираем debug строку
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data']) && isset($decoded['data'][$section])) {
            $result[$section] = $decoded['data'][$section];
        } else {
            $result[$section] = [];
        }
        
        usleep(100000); // 0.1 sec pause
    }
    
    return $result;
}

// Функция для запроса к OpenRouter GPT-4o
function askExpert($question, $widgetResponse, $openrouterKey, $model) {
    $specialists = $widgetResponse['specialists'] ?? [];
    $services = $widgetResponse['services'] ?? [];
    $specializations = $widgetResponse['specializations'] ?? [];
    
    // Формируем текст для анализа
    $widgetData = "ЗАПРОС ПАЦИЕНТА: {$question}\n\n";
    $widgetData .= "ОТВЕТ ВИДЖЕТА:\n";
    $widgetData .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $widgetData .= "СПЕЦИАЛИСТЫ (" . count($specialists) . "):\n";
    if (empty($specialists)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specialists, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без имени') . 
                          " - " . ($spec['description'] ?? 'Без специальности') . "\n";
        }
        if (count($specialists) > 5) {
            $widgetData .= "  ... и ещё " . (count($specialists) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nУСЛУГИ (" . count($services) . "):\n";
    if (empty($services)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($services, 0, 5) as $i => $serv) {
            $widgetData .= "  " . ($i+1) . ". " . ($serv['name'] ?? 'Без названия') . "\n";
        }
        if (count($services) > 5) {
            $widgetData .= "  ... и ещё " . (count($services) - 5) . "\n";
        }
    }
    
    $widgetData .= "\nСПЕЦИАЛИЗАЦИИ (" . count($specializations) . "):\n";
    if (empty($specializations)) {
        $widgetData .= "  (не найдено)\n";
    } else {
        foreach (array_slice($specializations, 0, 5) as $i => $spec) {
            $widgetData .= "  " . ($i+1) . ". " . ($spec['name'] ?? 'Без названия') . "\n";
        }
        if (count($specializations) > 5) {
            $widgetData .= "  ... и ещё " . (count($specializations) - 5) . "\n";
        }
    }
    
    $prompt = "Ты - медицинский эксперт. Оцени релевантность и полноту ответа виджета клиники на запрос пациента. " .
              "Оцени по 4 критериям от 0 до 10 (где 10 - идеально): " .
              "РЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ, РЕЛЕВАНТНОСТЬ УСЛУГ, КОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ, ПОЛНОТА ОТВЕТА. " .
              "Выведи общую ОЦЕНКУ (сумма баллов / 40). " .
              "Дай краткий ВЕРДИКТ (ОТЛИЧНО, ХОРОШО, УДОВЛЕТВОРИТЕЛЬНО, ПЛОХО). " .
              "Дай РЕКОМЕНДАЦИИ по улучшению. " .
              "Формат ответа строго:\nОЦЕНКА: X/40\nРЕЛЕВАНТНОСТЬ СПЕЦИАЛИСТОВ: Y/10 - [комментарий]\nРЕЛЕВАНТНОСТЬ УСЛУГ: Z/10 - [комментарий]\nКОРРЕКТНОСТЬ СПЕЦИАЛИЗАЦИЙ: A/10 - [комментарий]\nПОЛНОТА ОТВЕТА: B/10 - [комментарий]\n\nВЕРДИКТ: [ОТЛИЧНО/ХОРОШО/УДОВЛЕТВОРИТЕЛЬНО/ПЛОХО]\n\nРЕКОМЕНДАЦИИ: [текст]\n\n" .
              $widgetData;

    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60); // Таймаут 60 секунд
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); // Таймаут подключения 10 секунд
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $openrouterKey,
        'Content-Type: application/json',
        'HTTP-Referer: https://wtest.medmaps.ru',
        'X-Title: AI Medical Widget Test 310'
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'model' => $model,
        'messages' => [
            ['role' => 'user', 'content' => $prompt]
        ],
        'temperature' => 0.3,
        'max_tokens' => 1000
    ]));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    // Проверка на ошибку curl (таймаут и т.д.)
    if ($response === false || !empty($error)) {
        return "ОШИБКА CURL: {$error}";
    }

    if ($httpCode !== 200) {
        return "ОШИБКА: HTTP {$httpCode}\n{$response}";
    }

    $decodedResponse = json_decode($response, true);
    return $decodedResponse['choices'][0]['message']['content'] ?? 'Ошибка парсинга ответа эксперта.';
}

// Инициализация статистики
$totalScore = 0;
$verdictCounts = ['ОТЛИЧНО' => 0, 'ХОРОШО' => 0, 'УДОВЛЕТВОРИТЕЛЬНО' => 0, 'ПЛОХО' => 0];
$bestResponses = [];
$worstResponses = [];
$startTime = time();

writeLog("╔══════════════════════════════════════════════════════════════════════════╗");
writeLog("║       ТЕСТИРОВАНИЕ С ЭКСПЕРТНОЙ ОЦЕНКОЙ GPT-4o (310 ВОПРОСОВ)          ║");
writeLog("╚══════════════════════════════════════════════════════════════════════════╝\n");

$reportHandle = fopen($reportFile, 'w');
if (!$reportHandle) {
    die("Не удалось открыть файл отчета: {$reportFile}\n");
}

$totalQuestions = count($questions);

foreach ($questions as $index => $question) {
    writeLog("━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━");
    writeLog("ВОПРОС " . ($index + 1) . "/{$totalQuestions}: {$question}");
    writeLog("━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n");
    
    fwrite($reportHandle, "ВОПРОС " . ($index + 1) . "/{$totalQuestions}: {$question}\n");
    fwrite($reportHandle, "================================================================================\n\n");

    writeLog("  → Запрос к виджету...");
    $widgetResponse = queryWidget($question, $widgetKey);
    
    $specialistsCount = count($widgetResponse['specialists'] ?? []);
    $servicesCount = count($widgetResponse['services'] ?? []);
    $specializationsCount = count($widgetResponse['specializations'] ?? []);
    
    writeLog("  → Запрос к виджету... OK ({$specialistsCount} спец., {$servicesCount} усл., {$specializationsCount} спец.)");
    
    fwrite($reportHandle, "ОТВЕТ ВИДЖЕТА:\n");
    fwrite($reportHandle, "--------------------------------------------------------------------------------\n");
    fwrite($reportHandle, "Специалисты: {$specialistsCount}\n");
    fwrite($reportHandle, "Услуги: {$servicesCount}\n");
    fwrite($reportHandle, "Специализации: {$specializationsCount}\n\n");

    writeLog("  → Запрос к Gemini эксперту...");
    
    // Retry логика для askExpert (максимум 3 попытки)
    $expertReview = null;
    $maxRetries = 3;
    $retryCount = 0;
    
    while ($retryCount < $maxRetries) {
        $expertReview = askExpert($question, $widgetResponse, $openrouterKey, $openrouterModel);
        
        // Проверяем на ошибки
        if (strpos($expertReview, 'ОШИБКА') === false && strpos($expertReview, 'ОЦЕНКА:') !== false) {
            break; // Успешный ответ
        }
        
        $retryCount++;
        if ($retryCount < $maxRetries) {
            writeLog("  → Retry {$retryCount}/{$maxRetries}...");
            sleep(2); // Небольшая пауза перед повтором
        }
    }
    
    if (strpos($expertReview, 'ОШИБКА') !== false) {
        writeLog("  → FAILED после {$maxRetries} попыток\n");
        writeLog("  ⚠️ Ошибка: " . substr($expertReview, 0, 100) . "...\n");
        
        fwrite($reportHandle, "ЭКСПЕРТНАЯ ОЦЕНКА: ОШИБКА\n");
        fwrite($reportHandle, "```\n{$expertReview}\n```\n\n\n");
        
        // Пропускаем этот вопрос
        continue;
    }
    
    writeLog("  → Запрос к Gemini эксперту... OK\n");

    fwrite($reportHandle, "ЭКСПЕРТНАЯ ОЦЕНКА GPT-4o:\n");
    fwrite($reportHandle, "--------------------------------------------------------------------------------\n");
    fwrite($reportHandle, "```\n{$expertReview}\n```\n\n\n");

    // Парсинг оценки и вердикта
    $score = 0;
    $verdict = 'ПЛОХО';
    if (preg_match('/ОЦЕНКА:\s*(\d+)\/40/u', $expertReview, $matches)) {
        $score = (int)$matches[1];
    }
    if (preg_match('/ВЕРДИКТ:\s*(ОТЛИЧНО|ХОРОШО|УДОВЛЕТВОРИТЕЛЬНО|ПЛОХО)/u', $expertReview, $matches)) {
        $verdict = $matches[1];
    }

    $totalScore += $score;
    $verdictCounts[$verdict]++;

    // Сохраняем лучшие и худшие ответы
    $bestResponses[] = ['question' => $question, 'score' => $score, 'verdict' => $verdict];
    $worstResponses[] = ['question' => $question, 'score' => $score, 'verdict' => $verdict];

    // Сортируем для TOP-10
    usort($bestResponses, function($a, $b) { return $b['score'] <=> $a['score']; });
    usort($worstResponses, function($a, $b) { return $a['score'] <=> $b['score']; });

    $bestResponses = array_slice($bestResponses, 0, 10);
    $worstResponses = array_slice($worstResponses, 0, 10);

    writeLog("  ⭐ ОЦЕНКА: {$score}/40 | ВЕРДИКТ: {$verdict}\n");
    
    // Прогресс
    $elapsed = time() - $startTime;
    $avgTimePerQ = $elapsed / ($index + 1);
    $remaining = ($totalQuestions - ($index + 1)) * $avgTimePerQ;
    $remainingMin = round($remaining / 60);
    writeLog("  📊 Прогресс: " . ($index + 1) . "/{$totalQuestions} (" . round(($index + 1) / $totalQuestions * 100, 1) . "%) | ~{$remainingMin} мин. осталось\n");
    
    usleep(1000000); // 1 sec pause between questions to avoid rate limits
}

fclose($reportHandle);

// Формирование сводки
$averageScore = round($totalScore / count($questions), 1);
$elapsedTotal = time() - $startTime;
$elapsedMin = round($elapsedTotal / 60, 1);

$summaryContent = "ИТОГОВАЯ СТАТИСТИКА (310 ВОПРОСОВ)\n";
$summaryContent .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
$summaryContent .= "Средняя оценка: {$averageScore}/40\n";
$summaryContent .= "Общий балл: {$totalScore}/" . (count($questions) * 40) . "\n";
$summaryContent .= "Время выполнения: {$elapsedMin} минут\n\n";
$summaryContent .= "Распределение вердиктов:\n";
foreach ($verdictCounts as $verdict => $count) {
    $percent = round($count / count($questions) * 100, 1);
    $summaryContent .= "  • {$verdict}: {$count} ({$percent}%)\n";
}
$summaryContent .= "\nTOP-10 ЛУЧШИХ ОТВЕТОВ:\n";
$summaryContent .= "--------------------------------------------------------------------------------\n";
foreach ($bestResponses as $i => $item) {
    $summaryContent .= ($i + 1) . ". {$item['question']} - {$item['score']}/40 ({$item['verdict']})\n";
}
$summaryContent .= "\nTOP-10 ПРОБЛЕМНЫХ ОТВЕТОВ:\n";
$summaryContent .= "--------------------------------------------------------------------------------\n";
foreach ($worstResponses as $i => $item) {
    $summaryContent .= ($i + 1) . ". {$item['question']} - {$item['score']}/40 ({$item['verdict']})\n";
}
$summaryContent .= "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
$summaryContent .= "✅ ТЕСТ ЗАВЕРШЕН!\n\n";
$summaryContent .= "📁 Детальный отчет: {$reportFile}\n";
$summaryContent .= "📁 Краткая сводка: {$summaryFile}\n";

file_put_contents($summaryFile, $summaryContent);

writeLog($summaryContent);

fclose($logHandle);

?>

