<?php
/**
 * Расширенный тест AI виджета - 300 разнообразных медицинских вопросов
 */

require_once __DIR__ . '/config.php';

// 300 разнообразных медицинских вопросов по всем специализациям
$testQuestions = [
    // === НЕВРОЛОГИЯ (30 вопросов) ===
    'Острая боль в спине',
    'Болит поясница и отдает в ногу',
    'Боль в шее и головокружение',
    'Головокружение при ходьбе',
    'Бессонница что делать',
    'Мигрень сильная головная боль',
    'Головная боль в висках',
    'Онемение пальцев рук',
    'Защемление нерва в спине',
    'Межпозвоночная грыжа лечение',
    'Остеохондроз шейного отдела',
    'Тремор рук причины',
    'Невралгия межреберная',
    'Боль при повороте головы',
    'Хроническая усталость и слабость',
    'Нарушение координации движений',
    'Головная боль после сна',
    'Боль в затылке',
    'Прострелы в пояснице',
    'Радикулит обострение',
    'Боль вдоль позвоночника',
    'Судороги в ногах ночью',
    'Покалывание в конечностях',
    'Боль в пояснице отдает в ягодицу',
    'Невропатия нижних конечностей',
    'Боль в шейно-воротниковой зоне',
    'Головная боль и тошнота',
    'Хроническая головная боль',
    'Боль в спине после сна',
    'Люмбаго острая боль',

    // === ТЕРАПИЯ (40 вопросов) ===
    'Повышенная температура 38 и слабость',
    'Повышенная температура',
    'Простуда и насморк',
    'ОРВИ симптомы и лечение',
    'Грипп высокая температура',
    'Кашель сухой что делать',
    'Слабость и утомляемость',
    'Записаться к терапевту',
    'Общий анализ крови сдать',
    'Профилактический осмотр',
    'Диспансеризация взрослых',
    'Медосмотр для работы',
    'Кашель с мокротой',
    'Боль в мышцах и суставах',
    'Субфебрильная температура',
    'Увеличены лимфоузлы на шее',
    'Боль в грудной клетке',
    'Затрудненное дыхание',
    'Учащенное сердцебиение',
    'Потеря аппетита',
    'Резкая потеря веса',
    'Постоянная слабость',
    'Анемия низкий гемоглобин',
    'Авитаминоз весной',
    'Иммунитет как укрепить',
    'Частые простуды',
    'Бронхит лечение',
    'Пневмония симптомы',
    'Плеврит боль при дыхании',
    'Одышка в покое',
    'Хроническая обструктивная болезнь легких',
    'Ночная потливость',
    'Озноб без температуры',
    'Увеличение лимфоузлов подмышками',
    'Боль за грудиной',
    'Кашель более двух недель',
    'Сухость во рту',
    'Постоянная жажда',
    'Частое мочеиспускание и жажда',
    'Подозрение на диабет',

    // === КАРДИОЛОГИЯ (25 вопросов) ===
    'Высокое давление и головная боль',
    'Одышка при нагрузке',
    'Боль в груди',
    'Боль в сердце колющая',
    'Аритмия перебои в сердце',
    'Тахикардия учащенное сердцебиение',
    'Давление 140 на 90',
    'Гипертония лечение',
    'Боль в левой руке и груди',
    'ЭКГ сделать',
    'УЗИ сердца эхокардиография',
    'Холтер мониторинг',
    'Низкое давление гипотония',
    'Головокружение и слабость при вставании',
    'Боль в груди при физической нагрузке',
    'Стенокардия приступ',
    'Инфаркт профилактика',
    'Высокий холестерин',
    'Атеросклероз сосудов',
    'Варикозное расширение вен',
    'Отеки ног к вечеру',
    'Тяжесть в ногах',
    'Боль в икрах при ходьбе',
    'Синюшность пальцев',
    'Нарушение ритма сердца',

    // === ГАСТРОЭНТЕРОЛОГИЯ (30 вопросов) ===
    'Тошнота после еды и боль в животе',
    'Тошнота после еды',
    'Изжога и отрыжка',
    'Боль в правом подреберье',
    'Боль в желудке',
    'Гастрит обострение',
    'Язва желудка симптомы',
    'Вздутие живота',
    'Диарея понос',
    'Запор что делать',
    'Тяжесть в желудке после еды',
    'Горечь во рту',
    'Тошнота по утрам',
    'Рвота и понос',
    'Боль в животе после еды',
    'Панкреатит боль в поджелудочной',
    'Холецистит боль справа',
    'Боль в левом подреберье',
    'Колит кишечника',
    'Дисбактериоз кишечника',
    'Метеоризм газообразование',
    'Боль в области пупка',
    'Боль внизу живота',
    'Гастроскопия ФГДС',
    'УЗИ брюшной полости',
    'Печеночные пробы анализ',
    'Хронический гастрит',
    'Рефлюкс эзофагит',
    'Синдром раздраженного кишечника',
    'Потеря аппетита',

    // === УРОЛОГИЯ (20 вопросов) ===
    'Частое мочеиспускание и жжение',
    'Частое мочеиспускание',
    'Боль при мочеиспускании',
    'Цистит у женщин',
    'Пиелонефрит воспаление почек',
    'Боль в почках',
    'Мочекаменная болезнь',
    'Простатит у мужчин',
    'Аденома простаты',
    'Недержание мочи',
    'Кровь в моче',
    'Боль внизу живота у мужчин',
    'Затрудненное мочеиспускание',
    'Частые позывы в туалет ночью',
    'УЗИ почек и мочевого пузыря',
    'Анализ мочи общий',
    'Уролог консультация',
    'Боль в паху у мужчин',
    'Отеки под глазами',
    'Почечная колика',

    // === ЛОР (25 вопросов) ===
    'Болит горло и трудно глотать',
    'Заложенность носа и насморк',
    'Боль в ухе и ухудшение слуха',
    'Кашель и боль в горле',
    'Кровотечение из носа',
    'Ангина гнойная',
    'Фарингит воспаление горла',
    'Тонзиллит хронический',
    'Гайморит боль в пазухах',
    'Синусит головная боль',
    'Ринит аллергический',
    'Отит боль в ухе',
    'Снижение слуха',
    'Шум в ушах',
    'Заложенность уха',
    'Потеря обоняния',
    'Першение в горле',
    'Охриплость голоса',
    'Ларингит потеря голоса',
    'Трахеит кашель',
    'Насморк не проходит',
    'Полипы в носу',
    'Искривление носовой перегородки',
    'Промывание носа кукушка',
    'ЛОР осмотр',

    // === ДЕРМАТОЛОГИЯ (20 вопросов) ===
    'Акне на лице что делать',
    'Псориаз обострение лечение',
    'Розацеа покраснение лица',
    'Зуд кожи и высыпания',
    'Экзема на руках',
    'Дерматит аллергический',
    'Атопический дерматит',
    'Грибок ногтей',
    'Грибок стопы',
    'Бородавки удаление',
    'Папилломы на шее',
    'Герпес на губах',
    'Лишай розовый',
    'Крапивница сыпь',
    'Угревая сыпь лечение',
    'Пигментные пятна на коже',
    'Себорейный дерматит',
    'Выпадение волос',
    'Перхоть лечение',
    'Родинка изменилась',

    // === ЭНДОКРИНОЛОГИЯ (15 вопросов) ===
    'Сахарный диабет симптомы',
    'Повышенный сахар в крови',
    'Заболевания щитовидной железы',
    'УЗИ щитовидной железы',
    'Гипотиреоз симптомы',
    'Гипертиреоз',
    'Увеличение щитовидной железы',
    'Ожирение лечение',
    'Избыточный вес',
    'Метаболический синдром',
    'Гормональный сбой',
    'Анализ на гормоны щитовидной железы',
    'Эндокринолог консультация',
    'Диабет 2 типа',
    'Инсулинорезистентность',

    // === АЛЛЕРГОЛОГИЯ (15 вопросов) ===
    'Аллергия на пыльцу',
    'Аллергия сезонная',
    'Аллергический насморк',
    'Аллергия на продукты',
    'Крапивница аллергическая',
    'Отек Квинке',
    'Бронхиальная астма',
    'Приступ астмы',
    'Аллергия на животных',
    'Аллергия на лекарства',
    'Аллергопробы кожные тесты',
    'Аллерголог иммунолог',
    'Поллиноз весенний',
    'Аллергический конъюнктивит',
    'Атопия у взрослых',

    // === ОФТАЛЬМОЛОГИЯ (15 вопросов) ===
    'Снижение зрения',
    'Покраснение глаз',
    'Боль в глазах',
    'Конъюнктивит воспаление глаз',
    'Сухость глаз',
    'Слезотечение',
    'Ячмень на глазу',
    'Катаракта помутнение хрусталика',
    'Глаукома повышенное давление',
    'Проверка зрения',
    'Подбор очков',
    'Близорукость',
    'Дальнозоркость',
    'Астигматизм',
    'Мушки перед глазами',

    // === ТРАВМАТОЛОГИЯ И ОРТОПЕДИЯ (20 вопросов) ===
    'Боль в колене при ходьбе',
    'Боль в плечевом суставе',
    'Боль в локтевом суставе',
    'Боль в тазобедренном суставе',
    'Артрит воспаление сустава',
    'Артроз дегенерация сустава',
    'Растяжение связок',
    'Ушиб мягких тканей',
    'Перелом костей',
    'Вывих сустава',
    'Плоскостопие лечение',
    'Пяточная шпора',
    'Бурсит сустава',
    'Остеопороз хрупкость костей',
    'Сколиоз искривление позвоночника',
    'Боль в стопе',
    'Боль в пятке при ходьбе',
    'Травма колена',
    'Рентген костей',
    'МРТ суставов',

    // === ХИРУРГИЯ (10 вопросов) ===
    'Грыжа паховая',
    'Грыжа пупочная',
    'Киста мягких тканей',
    'Липома жировик',
    'Абсцесс гнойник',
    'Панариций палец',
    'Вросший ноготь',
    'Геморрой лечение',
    'Анальная трещина',
    'Хирург консультация',

    // === ГИНЕКОЛОГИЯ (10 вопросов) ===
    'Нарушение менструального цикла',
    'Боль внизу живота у женщин',
    'Выделения необычные',
    'Киста яичника',
    'Эндометриоз',
    'Миома матки',
    'Воспаление придатков',
    'УЗИ малого таза',
    'Гинеколог консультация',
    'Климакс симптомы',

    // === ПЕДИАТРИЯ (15 вопросов) ===
    'Ребенок кашляет и температура',
    'Ребенок жалуется на боль в животе',
    'Сыпь у ребенка',
    'Ребенок часто болеет',
    'Прорезывание зубов',
    'Диатез у грудничка',
    'Аденоиды у детей',
    'Детский невролог',
    'Педиатр консультация',
    'Вакцинация детей',
    'Медосмотр в школу',
    'Справка в детский сад',
    'Ребенок плохо спит',
    'Колики у новорожденного',
    'ОРВИ у ребенка',

    // === РЕВМАТОЛОГИЯ (10 вопросов) ===
    'Ревматоидный артрит',
    'Боль во всех суставах',
    'Подагра приступ',
    'Системная красная волчанка',
    'Боль в мелких суставах кистей',
    'Утренняя скованность суставов',
    'Ревматизм лечение',
    'Анализ на ревматоидный фактор',
    'СОЭ повышено',
    'Ревматолог консультация',

    // === АДМИНИСТРАТИВНЫЕ/СПРАВКИ (10 вопросов) ===
    'Нужна справка в бассейн',
    'Транспортная комиссия',
    'Справка на оружие',
    'Медицинская книжка оформить',
    'Справка для ГИБДД',
    'Водительская комиссия',
    'Справка в спортзал',
    'Медосмотр на работу',
    'Санаторно-курортная карта',
    'Выписка из медицинской карты',
];

echo "╔═══════════════════════════════════════════════════════════════════════════════╗\n";
echo "║          РАСШИРЕННЫЙ ТЕСТ AI ВИДЖЕТА - 300 МЕДИЦИНСКИХ ВОПРОСОВ             ║\n";
echo "╚═══════════════════════════════════════════════════════════════════════════════╝\n\n";
echo "Дата начала: " . date('d.m.Y H:i:s') . "\n";
echo "Всего вопросов: " . count($testQuestions) . "\n\n";

$timestamp = date('Y-m-d_H-i-s');
$outputFile = "/root/test_300_questions_{$timestamp}.txt";
$summaryFile = "/root/test_300_summary_{$timestamp}.txt";

$output = "";
$output .= "╔═══════════════════════════════════════════════════════════════════════════════╗\n";
$output .= "║          РАСШИРЕННЫЙ ТЕСТ AI ВИДЖЕТА - 300 МЕДИЦИНСКИХ ВОПРОСОВ             ║\n";
$output .= "╚═══════════════════════════════════════════════════════════════════════════════╝\n\n";
$output .= "Дата: " . date('d.m.Y H:i:s') . "\n";
$output .= "Всего вопросов: " . count($testQuestions) . "\n\n";

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT * FROM widgets WHERE widget_key = ?");
$stmt->execute(['ekamedcenter']);
$widget = $stmt->fetch();

if (!$widget) {
    echo "❌ ERROR: Widget not found\n";
    exit(1);
}

$apiBase = 'https://wtest.medmaps.ru/api';
$widgetKey = 'ekamedcenter';

// Статистика
$stats = [
    'total' => count($testQuestions),
    'processed' => 0,
    'with_specialists' => 0,
    'with_services' => 0,
    'with_articles' => 0,
    'with_specializations' => 0,
    'errors' => 0,
    'by_specialty' => []
];

$startTime = microtime(true);
$questionNumber = 0;

foreach ($testQuestions as $question) {
    $questionNumber++;
    $progress = round($questionNumber / count($testQuestions) * 100);
    
    echo sprintf("\r[%3d%%] Обработка вопроса %d/%d: %-50s", 
        $progress, $questionNumber, count($testQuestions), 
        mb_substr($question, 0, 47) . '...');
    
    $output .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $output .= "ВОПРОС {$questionNumber}: {$question}\n";
    $output .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $sections = ['specialists', 'services', 'specializations'];
    $questionStats = [
        'specialists' => 0,
        'services' => 0,
        'specializations' => 0
    ];
    
    foreach ($sections as $section) {
        $ch = curl_init($apiBase . '/query-section.php');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'widget_key' => $widgetKey,
            'question' => $question,
            'section_name' => $section
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200 || !$response) {
            $stats['errors']++;
            continue;
        }
        
        $data = json_decode($response, true);
        
        if (!isset($data['data'][$section])) {
            continue;
        }
        
        $items = $data['data'][$section];
        $count = count($items);
        $questionStats[$section] = $count;
        
        if ($count > 0) {
            $stats['with_' . $section]++;
        }
        
        // Кратко записываем результаты
        $output .= "{$section}: {$count} ";
        
        if ($count > 0) {
            if ($section === 'specialists') {
                $names = array_slice(array_map(function($item) {
                    return $item['name'] ?? 'NO NAME';
                }, $items), 0, 3);
                $output .= "(" . implode(', ', $names);
                if ($count > 3) $output .= "...";
                $output .= ")";
            } elseif ($section === 'services') {
                $names = array_slice(array_map(function($item) {
                    return $item['name'] ?? $item['service_name'] ?? $item['title'] ?? 'NO NAME';
                }, $items), 0, 3);
                $output .= "(" . implode(', ', $names);
                if ($count > 3) $output .= "...";
                $output .= ")";
            } elseif ($section === 'specializations') {
                $names = array_map(function($item) {
                    return $item['name'] ?? $item['title'] ?? 'NO NAME';
                }, $items);
                $output .= "(" . implode(', ', $names) . ")";
            }
        }
        $output .= "\n";
    }
    
    $output .= "\n";
    $stats['processed']++;
}

echo "\n\n";

// Итоговая статистика
$totalTime = round(microtime(true) - $startTime);
$avgTime = round($totalTime / count($testQuestions), 2);

$summary = "";
$summary .= "╔═══════════════════════════════════════════════════════════════════════════════╗\n";
$summary .= "║                    ИТОГОВАЯ СТАТИСТИКА - 300 ВОПРОСОВ                       ║\n";
$summary .= "╚═══════════════════════════════════════════════════════════════════════════════╝\n\n";
$summary .= "Дата: " . date('d.m.Y H:i:s') . "\n";
$summary .= "Время выполнения: {$totalTime} сек (" . round($totalTime / 60, 1) . " мин)\n";
$summary .= "Среднее время на вопрос: {$avgTime} сек\n\n";
$summary .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
$summary .= "РЕЗУЛЬТАТЫ:\n";
$summary .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
$summary .= "Всего вопросов: {$stats['total']}\n";
$summary .= "Обработано: {$stats['processed']}\n";
$summary .= "Ошибок: {$stats['errors']}\n\n";
$summary .= "Вопросов с результатами:\n";
$summary .= "  Specialists:      {$stats['with_specialists']}/{$stats['total']} (" . round($stats['with_specialists']/$stats['total']*100) . "%)\n";
$summary .= "  Services:         {$stats['with_services']}/{$stats['total']} (" . round($stats['with_services']/$stats['total']*100) . "%)\n";
$summary .= "  Specializations:  {$stats['with_specializations']}/{$stats['total']} (" . round($stats['with_specializations']/$stats['total']*100) . "%)\n\n";

$output .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
$output .= "ТЕСТИРОВАНИЕ ЗАВЕРШЕНО\n";
$output .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
$output .= $summary;

// Сохраняем файлы
file_put_contents($outputFile, $output);
file_put_contents($summaryFile, $summary);

echo $summary;
echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "📁 ФАЙЛЫ С РЕЗУЛЬТАТАМИ:\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "  📄 Детальные результаты: {$outputFile}\n";
echo "  📄 Сводка: {$summaryFile}\n\n";
echo "✅ ТЕСТИРОВАНИЕ ЗАВЕРШЕНО!\n\n";




