#!/usr/bin/env php
<?php

// Извлекаем все 127 проблемных вопросов из оригинального файла
$originalFile = '/root/problem_questions_review_2025-12-29_13-10-37.txt';

if (!file_exists($originalFile)) {
    die("Файл не найден: {$originalFile}\n");
}

$content = file_get_contents($originalFile);
$questions = [];

// Извлекаем все вопросы
preg_match_all('/^ВОПРОС \d+\/127: (.+)$/m', $content, $matches);
$questions = $matches[1];

echo "\n📊 ТЕСТ УЛУЧШЕНИЙ НА " . count($questions) . " ПРОБЛЕМНЫХ ВОПРОСАХ\n";
echo str_repeat("━", 80) . "\n\n";

$widgetKey = 'ekamedcenter';
$passedTests = 0;
$totalTests = count($questions);

$results = [];
$startTime = microtime(true);

foreach ($questions as $idx => $question) {
    $num = $idx + 1;
    
    if ($num % 10 == 0 || $num == 1) {
        $elapsed = round(microtime(true) - $startTime, 1);
        $avgTime = $elapsed / $num;
        $remaining = round(($totalTests - $num) * $avgTime / 60, 1);
        echo "⏳ Прогресс: {$num}/{$totalTests} ({$elapsed}с, осталось ~{$remaining} мин)\n";
    }
    
    // Получаем данные от виджета
    $result = [];
    foreach (['specialists', 'services', 'specializations'] as $section) {
        $cmd = sprintf(
            'php /root/api-wrapper.php %s %s %s 2>&1',
            escapeshellarg($widgetKey),
            escapeshellarg($question),
            escapeshellarg($section)
        );
        
        $output = shell_exec($cmd);
        $lines = explode("\n", $output);
        $jsonLine = '';
        foreach ($lines as $line) {
            if (strpos($line, '{') === 0) {
                $jsonLine = $line;
                break;
            }
        }
        
        $decoded = json_decode($jsonLine, true);
        
        if ($decoded && isset($decoded['data'][$section])) {
            $result[$section] = $decoded['data'][$section];
        } else {
            $result[$section] = [];
        }
        
        usleep(50000); // 0.05 sec pause
    }
    
    $specialistsCount = count($result['specialists'] ?? []);
    $servicesCount = count($result['services'] ?? []);
    $specializationsCount = count($result['specializations'] ?? []);
    
    // Критерии успеха: минимум 2 специалиста, 3 услуги, 1 специализация
    $passed = ($specialistsCount >= 2 && $servicesCount >= 3 && $specializationsCount >= 1);
    
    if ($passed) {
        $passedTests++;
    }
    
    $results[] = [
        'question' => $question,
        'specialists' => $specialistsCount,
        'services' => $servicesCount,
        'specializations' => $specializationsCount,
        'passed' => $passed
    ];
}

$endTime = microtime(true);
$totalTime = round($endTime - $startTime, 1);

echo "\n" . str_repeat("━", 80) . "\n";
echo "📊 ИТОГО: {$passedTests}/{$totalTests} тестов пройдено (" . round(($passedTests/$totalTests)*100, 1) . "%)\n";
echo "⏱️  Время выполнения: {$totalTime} сек (" . round($totalTime/60, 1) . " мин)\n";
echo str_repeat("━", 80) . "\n\n";

// Статистика по категориям
$stats = [
    'passed' => 0,
    'no_specialists' => 0,
    'no_services' => 0,
    'no_specializations' => 0,
    'empty' => 0
];

foreach ($results as $r) {
    if ($r['passed']) {
        $stats['passed']++;
    }
    if ($r['specialists'] == 0) {
        $stats['no_specialists']++;
    }
    if ($r['services'] == 0) {
        $stats['no_services']++;
    }
    if ($r['specializations'] == 0) {
        $stats['no_specializations']++;
    }
    if ($r['specialists'] == 0 && $r['services'] == 0 && $r['specializations'] == 0) {
        $stats['empty']++;
    }
}

echo "📈 ДЕТАЛЬНАЯ СТАТИСТИКА:\n\n";
echo "✅ Пройдено тестов: {$stats['passed']}/{$totalTests} (" . round(($stats['passed']/$totalTests)*100, 1) . "%)\n";
echo "❌ Нет специалистов: {$stats['no_specialists']} (" . round(($stats['no_specialists']/$totalTests)*100, 1) . "%)\n";
echo "❌ Нет услуг: {$stats['no_services']} (" . round(($stats['no_services']/$totalTests)*100, 1) . "%)\n";
echo "❌ Нет специализаций: {$stats['no_specializations']} (" . round(($stats['no_specializations']/$totalTests)*100, 1) . "%)\n";
echo "💀 Полностью пустых (0/0/0): {$stats['empty']} (" . round(($stats['empty']/$totalTests)*100, 1) . "%)\n";

echo "\n" . str_repeat("━", 80) . "\n";
echo "📁 Сохраняю детальные результаты...\n";

// Сохраняем результаты
$reportFile = '/root/test_127_improved_' . date('Y-m-d_H-i-s') . '.txt';
$fp = fopen($reportFile, 'w');

fwrite($fp, "ТЕСТ УЛУЧШЕНИЙ НА 127 ПРОБЛЕМНЫХ ВОПРОСАХ\n");
fwrite($fp, str_repeat("=", 80) . "\n\n");
fwrite($fp, "Дата: " . date('Y-m-d H:i:s') . "\n");
fwrite($fp, "Время выполнения: {$totalTime} сек\n");
fwrite($fp, "Успешно: {$passedTests}/{$totalTests} (" . round(($passedTests/$totalTests)*100, 1) . "%)\n\n");
fwrite($fp, str_repeat("=", 80) . "\n\n");

foreach ($results as $idx => $r) {
    $num = $idx + 1;
    $status = $r['passed'] ? '✅ УСПЕХ' : '❌ ПРОБЛЕМА';
    
    fwrite($fp, sprintf(
        "%s #{$num}: %s\n   Специалисты: %d, Услуги: %d, Специализации: %d\n\n",
        $status,
        $r['question'],
        $r['specialists'],
        $r['services'],
        $r['specializations']
    ));
}

fclose($fp);

echo "✅ Результаты сохранены: {$reportFile}\n";
echo str_repeat("━", 80) . "\n\n";

// Показываем примеры исправленных вопросов
echo "🎯 ПРИМЕРЫ УЛУЧШЕНИЙ (первые 10 успешных):\n\n";
$successCount = 0;
foreach ($results as $r) {
    if ($r['passed']) {
        echo "✅ {$r['question']}\n";
        echo "   {$r['specialists']} спец., {$r['services']} усл., {$r['specializations']} спец.\n\n";
        $successCount++;
        if ($successCount >= 10) break;
    }
}

echo str_repeat("━", 80) . "\n";
echo "🎉 ТЕСТ ЗАВЕРШЕН!\n";
echo str_repeat("━", 80) . "\n";




