<?php
/**
 * API endpoint для удаления всех категорий раздела
 * POST /api/clear-categories.php
 * Body: { "widget_id": 1, "section_name": "specialists" }
 */

ini_set('display_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json');

require_once __DIR__ . '/../config.php';

$input = json_decode(file_get_contents('php://input'), true);
$widgetId = (int)($input['widget_id'] ?? 0);
$sectionName = trim($input['section_name'] ?? '');

if (!$widgetId || !$sectionName) {
    http_response_code(400);
    echo json_encode(['error' => 'widget_id and section_name are required']);
    exit;
}

try {
    $db = getDatabase();
    
    // Проверяем существование виджета
    $stmt = $db->prepare("SELECT id FROM widgets WHERE id = ?");
    $stmt->execute([$widgetId]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        echo json_encode(['error' => 'Widget not found']);
        exit;
    }
    
    // Удаляем все категории для этого раздела
    $stmt = $db->prepare("DELETE FROM item_categories WHERE widget_id = ? AND section_name = ?");
    $stmt->execute([$widgetId, $sectionName]);
    
    $deletedCount = $stmt->rowCount();
    
    echo json_encode([
        'success' => true,
        'deleted_count' => $deletedCount
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

