<?php
$page_title = 'Шаблоны виджета';
require_once __DIR__ . '/includes/header.php';

$widget_id = $_GET['id'] ?? 0;

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT * FROM widgets WHERE id = ?");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    header('Location: /admin/');
    exit;
}

$customPath = WIDGET_ROOT . '/widget/custom/' . $widget['widget_key'];
$templateFile = $customPath . '/template.html';
$stylesFile = $customPath . '/styles.css';
$jsFile = $customPath . '/custom.js';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-file-code"></i> Шаблоны виджета: <?php echo htmlspecialchars($widget['name']); ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/widget-settings.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Назад
        </a>
    </div>
</div>

<div class="alert alert-info">
    <i class="bi bi-info-circle"></i>
    <strong>Редактирование через SSH:</strong>
    <code><?php echo $customPath; ?></code>
    <br><br>
    <strong>Команды для редактирования:</strong>
    <div class="mt-2">
        <code class="d-block mb-1">nano <?php echo $templateFile; ?></code>
        <code class="d-block mb-1">nano <?php echo $stylesFile; ?></code>
        <code class="d-block">nano <?php echo $jsFile; ?></code>
    </div>
</div>

<!-- Template.html -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-file-earmark-code"></i> template.html
                </h5>
                <span class="badge <?php echo file_exists($templateFile) ? 'bg-success' : 'bg-secondary'; ?>">
                    <?php echo file_exists($templateFile) ? 'Существует' : 'Не создан'; ?>
                </span>
            </div>
            <div class="card-body">
                <?php if (file_exists($templateFile)): ?>
                    <p class="text-muted mb-2">
                        <strong>Назначение:</strong> HTML разметка виджета. Используйте placeholders: 
                        <code>{{welcome_message}}</code>, <code>{{suggestions}}</code>, <code>{{primary_color}}</code>
                    </p>
                    <p class="text-muted mb-3">
                        <strong>Размер:</strong> <?php echo round(filesize($templateFile) / 1024, 2); ?> KB
                    </p>
                    <pre class="bg-dark text-light p-3 rounded" style="max-height: 500px; overflow-y: auto;"><code><?php echo htmlspecialchars(file_get_contents($templateFile)); ?></code></pre>
                <?php else: ?>
                    <p class="text-muted">Файл не найден. Будет использован дефолтный шаблон из <code>/widget/template.html</code></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Styles.css -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-palette"></i> styles.css
                </h5>
                <span class="badge <?php echo file_exists($stylesFile) ? 'bg-success' : 'bg-secondary'; ?>">
                    <?php echo file_exists($stylesFile) ? 'Существует' : 'Не создан'; ?>
                </span>
            </div>
            <div class="card-body">
                <?php if (file_exists($stylesFile)): ?>
                    <p class="text-muted mb-2">
                        <strong>Назначение:</strong> CSS стили виджета. Переопределяют или дополняют дефолтные стили.
                    </p>
                    <p class="text-muted mb-3">
                        <strong>Размер:</strong> <?php echo round(filesize($stylesFile) / 1024, 2); ?> KB
                    </p>
                    <pre class="bg-dark text-light p-3 rounded" style="max-height: 500px; overflow-y: auto;"><code><?php echo htmlspecialchars(file_get_contents($stylesFile)); ?></code></pre>
                <?php else: ?>
                    <p class="text-muted">Файл не найден. Будут использованы дефолтные стили из <code>/widget/widget.css</code></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Custom.js -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-code-slash"></i> custom.js
                </h5>
                <span class="badge <?php echo file_exists($jsFile) ? 'bg-success' : 'bg-secondary'; ?>">
                    <?php echo file_exists($jsFile) ? 'Существует' : 'Не создан'; ?>
                </span>
            </div>
            <div class="card-body">
                <?php if (file_exists($jsFile)): ?>
                    <p class="text-muted mb-2">
                        <strong>Назначение:</strong> Кастомная JavaScript логика. 
                        Если определена функция <code>initCustomWidget(config, API_BASE)</code>, она полностью заменит стандартную логику.
                    </p>
                    <p class="text-muted mb-3">
                        <strong>Размер:</strong> <?php echo round(filesize($jsFile) / 1024, 2); ?> KB
                    </p>
                    <pre class="bg-dark text-light p-3 rounded" style="max-height: 500px; overflow-y: auto;"><code><?php echo htmlspecialchars(file_get_contents($jsFile)); ?></code></pre>
                <?php else: ?>
                    <p class="text-muted">Файл не найден. Будет использована стандартная логика из <code>/widget/widget.js</code></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Документация -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-book"></i> Документация
                </h5>
            </div>
            <div class="card-body">
                <h6>Placeholders в template.html:</h6>
                <ul>
                    <li><code>{{welcome_message}}</code> - Приветственное сообщение из настроек</li>
                    <li><code>{{suggestions}}</code> - HTML код быстрых подсказок</li>
                    <li><code>{{primary_color}}</code> - Основной цвет из настроек</li>
                </ul>
                
                <h6 class="mt-3">Структура custom.js:</h6>
                <pre class="bg-dark text-light p-3 rounded"><code>function initCustomWidget(config, API_BASE) {
    // config.widget_key - ключ виджета
    // config.name - название
    // config.primary_color - основной цвет
    // config.welcome_message - приветствие
    // config.suggestions - массив подсказок
    // config.custom_files - пути к кастомным файлам
    
    // API_BASE = 'https://w.medmaps.ru/ai-widget/api'
    
    // Ваш код здесь
}</code></pre>
                
                <h6 class="mt-3">Fallback логика:</h6>
                <ul>
                    <li>Если файл отсутствует - используется дефолтный из <code>/widget/</code></li>
                    <li>Если <code>initCustomWidget()</code> не определена - используется стандартная логика</li>
                    <li>Частичная кастомизация: можно переопределить только нужные файлы</li>
                </ul>
                
                <div class="alert alert-warning mt-3">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>Важно:</strong> После изменения файлов может потребоваться очистка кеша браузера (Ctrl+Shift+R)
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

