<?php
$page_title = 'Настройки виджета';
require_once __DIR__ . '/includes/header.php';

$widget_id = $_GET['id'] ?? 0;
$error = '';
$success = '';

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("
    SELECT w.*, ws.*, cu.username as client_username, cu.full_name as client_full_name
    FROM widgets w
    LEFT JOIN widget_settings ws ON w.id = ws.widget_id
    LEFT JOIN client_users cu ON w.client_id = cu.id
    WHERE w.id = ?
");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    header('Location: /admin/');
    exit;
}

// Получаем список клиентов для выбора
$clients = $db->query("SELECT id, username, full_name, email FROM client_users WHERE is_active = 1 ORDER BY username")->fetchAll();

// Обработка сохранения
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $client_id = !empty($_POST['client_id']) ? (int)$_POST['client_id'] : null;
    $claude_prompt = trim($_POST['claude_prompt'] ?? '');
    $welcome_message = trim($_POST['welcome_message'] ?? '');
    $suggestions = $_POST['suggestions'] ?? [];
    $allowed_domains = $_POST['allowed_domains'] ?? [];
    $primary_color = $_POST['primary_color'] ?? '#007bff';
    $cache_enabled = isset($_POST['cache_enabled']) ? 1 : 0;
    $cache_ttl_minutes = (int)($_POST['cache_ttl_minutes'] ?? 60);
    $encoding = $_POST['encoding'] ?? 'auto';
    $stage1_model = trim($_POST['stage1_model'] ?? 'meta-llama/llama-3.2-1b-instruct');
    $stage2_model = trim($_POST['stage2_model'] ?? 'qwen/qwen2.5-14b-instruct');
    $stage3_model = trim($_POST['stage3_model'] ?? 'qwen/qwen3-235b-a22b-2507');
    $stage1_prompt = trim($_POST['stage1_prompt'] ?? '');
    $stage2_prompt = trim($_POST['stage2_prompt'] ?? '');
    $stage3_prompt = trim($_POST['stage3_prompt'] ?? '');
    $stage_specialists_prompt = trim($_POST['stage_specialists_prompt'] ?? '');
    $stage_services_prompt = trim($_POST['stage_services_prompt'] ?? '');
    $stage_articles_prompt = trim($_POST['stage_articles_prompt'] ?? '');
    $stage_specializations_prompt = trim($_POST['stage_specializations_prompt'] ?? '');
    $stage_specialists_model = trim($_POST['stage_specialists_model'] ?? '');
    $stage_services_model = trim($_POST['stage_services_model'] ?? '');
    $stage_articles_model = trim($_POST['stage_articles_model'] ?? '');
    $stage_specializations_model = trim($_POST['stage_specializations_model'] ?? '');
    $custom_api_url = trim($_POST['custom_api_url'] ?? '');
    $custom_api_key = trim($_POST['custom_api_key'] ?? '');
    $active = isset($_POST['active']) ? 1 : 0;
    
    try {
        $db->beginTransaction();
        
        // Обновляем виджет
        $stmt = $db->prepare("
            UPDATE widgets 
            SET name = ?, client_id = ?, claude_prompt = ?, active = ?
            WHERE id = ?
        ");
        $stmt->execute([$name, $client_id, $claude_prompt, $active, $widget_id]);
        
        // Обновляем или создаем настройки
        $stmt = $db->prepare("
            INSERT INTO widget_settings 
            (widget_id, welcome_message, suggestions, allowed_domains, primary_color, cache_enabled, cache_ttl_minutes, encoding, stage1_model, stage2_model, stage3_model, stage1_prompt, stage2_prompt, stage3_prompt, stage_specialists_prompt, stage_services_prompt, stage_articles_prompt, stage_specializations_prompt, stage_specialists_model, stage_services_model, stage_articles_model, stage_specializations_model, custom_api_url, custom_api_key)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                welcome_message = VALUES(welcome_message),
                suggestions = VALUES(suggestions),
                allowed_domains = VALUES(allowed_domains),
                primary_color = VALUES(primary_color),
                cache_enabled = VALUES(cache_enabled),
                cache_ttl_minutes = VALUES(cache_ttl_minutes),
                encoding = VALUES(encoding),
                stage1_model = VALUES(stage1_model),
                stage2_model = VALUES(stage2_model),
                stage3_model = VALUES(stage3_model),
                stage1_prompt = VALUES(stage1_prompt),
                stage2_prompt = VALUES(stage2_prompt),
                stage3_prompt = VALUES(stage3_prompt),
                stage_specialists_prompt = VALUES(stage_specialists_prompt),
                stage_services_prompt = VALUES(stage_services_prompt),
                stage_articles_prompt = VALUES(stage_articles_prompt),
                stage_specializations_prompt = VALUES(stage_specializations_prompt),
                stage_specialists_model = VALUES(stage_specialists_model),
                stage_services_model = VALUES(stage_services_model),
                stage_articles_model = VALUES(stage_articles_model),
                stage_specializations_model = VALUES(stage_specializations_model),
                custom_api_url = VALUES(custom_api_url),
                custom_api_key = VALUES(custom_api_key)
        ");
        $stmt->execute([
            $widget_id,
            $welcome_message,
            json_encode(array_filter($suggestions), JSON_UNESCAPED_UNICODE),
            json_encode(array_filter($allowed_domains), JSON_UNESCAPED_UNICODE),
            $primary_color,
            $cache_enabled,
            $cache_ttl_minutes,
            $encoding,
            $stage1_model,
            $stage2_model,
            $stage3_model,
            $stage1_prompt,
            $stage2_prompt,
            $stage3_prompt,
            $stage_specialists_prompt,
            $stage_services_prompt,
            $stage_articles_prompt,
            $stage_specializations_prompt,
            $stage_specialists_model,
            $stage_services_model,
            $stage_articles_model,
            $stage_specializations_model,
            $custom_api_url,
            $custom_api_key
        ]);
        
        $db->commit();
        $success = 'Настройки сохранены';
        
        // Перезагружаем данные
        $stmt = $db->prepare("
            SELECT w.*, ws.*
            FROM widgets w
            LEFT JOIN widget_settings ws ON w.id = ws.widget_id
            WHERE w.id = ?
        ");
        $stmt->execute([$widget_id]);
        $widget = $stmt->fetch();
        
    } catch (Exception $e) {
        $db->rollBack();
        $error = 'Ошибка сохранения: ' . $e->getMessage();
    }
}

// Парсим JSON
$suggestions = json_decode($widget['suggestions'] ?? '[]', true) ?: [];
$allowed_domains = json_decode($widget['allowed_domains'] ?? '[]', true) ?: [];

// Добавляем пустые поля для удобства
while (count($suggestions) < 10) $suggestions[] = '';
while (count($allowed_domains) < 3) $allowed_domains[] = '';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-gear"></i> <?php echo htmlspecialchars($widget['name']); ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/widget-test.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-success me-2">
            <i class="bi bi-play-circle"></i> Тестировать виджет
        </a>
        <a href="/admin/widget-categories.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-warning me-2">
            <i class="bi bi-tags"></i> Категории
        </a>
        <a href="/admin/scripts/generate-embeddings.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-primary me-2">
            <i class="bi bi-vector-pen"></i> Embeddings
        </a>
        <a href="/admin/scripts/link-specialist-services-page.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-success me-2">
            <i class="bi bi-link-45deg"></i> Связи специалистов
        </a>
        <a href="/admin/widget-templates.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-info me-2">
            <i class="bi bi-file-code"></i> Шаблоны
        </a>
        <a href="/admin/sections-list.php?widget_id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-primary me-2">
            <i class="bi bi-list"></i> Разделы
        </a>
        <a href="/admin/" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Назад
        </a>
    </div>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <form method="POST">
            <!-- Основные настройки -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Основные настройки</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">Название виджета</label>
                        <input type="text" class="form-control" id="name" name="name" required value="<?php echo htmlspecialchars($widget['name']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="client_id" class="form-label">Клиент</label>
                        <select class="form-select" id="client_id" name="client_id">
                            <option value="">Не привязан</option>
                            <?php foreach ($clients as $client): ?>
                                <option value="<?php echo $client['id']; ?>" <?php echo ($widget['client_id'] == $client['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($client['username']); ?>
                                    <?php if ($client['full_name']): ?>
                                        (<?php echo htmlspecialchars($client['full_name']); ?>)
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <div class="form-text">Выберите клиента, которому будет принадлежать виджет</div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Widget Key</label>
                        <input type="text" class="form-control" value="<?php echo htmlspecialchars($widget['widget_key']); ?>" disabled>
                        <div class="form-text">Не может быть изменен после создания</div>
                    </div>
                    
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="active" name="active" <?php echo $widget['active'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="active">Виджет активен</label>
                    </div>
                </div>
            </div>
            
            <!-- Claude промпт -->
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Промпт Claude</h5>
                    <a href="/admin/widget-prompt-preview.php?widget_id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                        <i class="bi bi-eye"></i> Предпросмотр
                    </a>
                </div>
                <div class="card-body">
                    <textarea class="form-control" id="claude_prompt" name="claude_prompt" rows="8" required><?php echo htmlspecialchars($widget['claude_prompt']); ?></textarea>
                    <div class="form-text">Базовый промпт для Claude. Данные из разделов будут добавлены автоматически.</div>
                </div>
            </div>
            
            <!-- Интерфейс виджета -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Интерфейс виджета</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="welcome_message" class="form-label">Приветственное сообщение</label>
                        <input type="text" class="form-control" id="welcome_message" name="welcome_message" value="<?php echo htmlspecialchars($widget['welcome_message']); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="primary_color" class="form-label">Основной цвет</label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color" id="primary_color" name="primary_color" value="<?php echo htmlspecialchars($widget['primary_color'] ?? '#007bff'); ?>">
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($widget['primary_color'] ?? '#007bff'); ?>" disabled>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Подсказки (быстрые вопросы)</label>
                        <?php foreach ($suggestions as $i => $suggestion): ?>
                            <input type="text" class="form-control mb-2" name="suggestions[]" value="<?php echo htmlspecialchars($suggestion); ?>" placeholder="Например: У меня болит спина">
                        <?php endforeach; ?>
                        <div class="form-text">Пустые поля будут проигнорированы</div>
                    </div>
                </div>
            </div>
            
            <!-- CORS и безопасность -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Безопасность (CORS)</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Разрешенные домены</label>
                        <?php foreach ($allowed_domains as $i => $domain): ?>
                            <input type="url" class="form-control mb-2" name="allowed_domains[]" value="<?php echo htmlspecialchars($domain); ?>" placeholder="https://example.com">
                        <?php endforeach; ?>
                        <div class="form-text">Виджет будет работать только на этих доменах</div>
                    </div>
                </div>
            </div>
            
            <!-- Кеширование -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Кеширование</h5>
                </div>
                <div class="card-body">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="cache_enabled" name="cache_enabled" <?php echo $widget['cache_enabled'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="cache_enabled">Включить кеш ответов</label>
                    </div>
                    
                    <div class="mb-3">
                        <label for="cache_ttl_minutes" class="form-label">Время жизни кеша (минут)</label>
                        <input type="number" class="form-control" id="cache_ttl_minutes" name="cache_ttl_minutes" value="<?php echo $widget['cache_ttl_minutes'] ?? 60; ?>" min="1" max="1440">
                    </div>
                </div>
            </div>
            
            <!-- Настройки кастомного API -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Кастомный API сервер</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning mb-3">
                        <i class="bi bi-exclamation-triangle"></i> 
                        <strong>Внимание:</strong> Если указан кастомный API, все запросы будут отправляться на него вместо стандартного Claude API. 
                        Оставьте поля пустыми, чтобы использовать стандартный API.
                    </div>
                    
                    <div class="mb-3">
                        <label for="custom_api_url" class="form-label">
                            URL кастомного API
                        </label>
                        <input type="url" class="form-control" id="custom_api_url" name="custom_api_url" 
                               value="<?php echo htmlspecialchars($widget['custom_api_url'] ?? ''); ?>" 
                               placeholder="http://212.41.21.53:8000/api/v1/chat/completions">
                        <small class="form-text text-muted">Полный URL endpoint для chat completions API (совместимый с OpenAI форматом)</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="custom_api_key" class="form-label">
                            API ключ (опционально)
                        </label>
                        <input type="text" class="form-control" id="custom_api_key" name="custom_api_key" 
                               value="<?php echo htmlspecialchars($widget['custom_api_key'] ?? ''); ?>" 
                               placeholder="Bearer YOUR_API_KEY или просто ключ">
                        <small class="form-text text-muted">Если ваш API требует авторизацию, укажите ключ. Можно указать "Bearer " или просто ключ.</small>
                    </div>
                </div>
            </div>
            
            <!-- Настройки моделей для трёхэтапного режима -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Настройки моделей (трёхэтапный режим)</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-3">
                        <i class="bi bi-info-circle"></i> 
                        <strong>Трёхэтапный режим:</strong> Этап 1 (быстрый текстовый ответ) и Этап 2 (извлечение терминов) выполняются параллельно. 
                        Этап 3 (основной запрос с данными) выполняется после Этапа 2.
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage1_model" class="form-label">
                            Модель для этапа 1 (текстовый ответ)
                            <small class="text-muted">- быстрая модель для простых ответов</small>
                        </label>
                        <input type="text" class="form-control" id="stage1_model" name="stage1_model" 
                               value="<?php echo htmlspecialchars($widget['stage1_model'] ?? 'meta-llama/llama-3.2-1b-instruct'); ?>" 
                               placeholder="meta-llama/llama-3.2-1b-instruct">
                        <small class="form-text text-muted">Примеры: meta-llama/llama-3.2-1b-instruct, qwen/qwen2.5-7b-instruct</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage2_model" class="form-label">
                            Модель для этапа 2 (извлечение терминов)
                            <small class="text-muted">- средняя модель для анализа</small>
                        </label>
                        <input type="text" class="form-control" id="stage2_model" name="stage2_model" 
                               value="<?php echo htmlspecialchars($widget['stage2_model'] ?? 'qwen/qwen2.5-14b-instruct'); ?>" 
                               placeholder="qwen/qwen2.5-14b-instruct">
                        <small class="form-text text-muted">Примеры: qwen/qwen2.5-14b-instruct, qwen/qwen2.5-32b-instruct</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage3_model" class="form-label">
                            Модель для этапа 3 (основной запрос)
                            <small class="text-muted">- мощная модель для финального ответа</small>
                        </label>
                        <input type="text" class="form-control" id="stage3_model" name="stage3_model" 
                               value="<?php echo htmlspecialchars($widget['stage3_model'] ?? 'qwen/qwen3-235b-a22b-2507'); ?>" 
                               placeholder="qwen/qwen3-235b-a22b-2507">
                        <small class="form-text text-muted">Примеры: qwen/qwen3-235b-a22b-2507, qwen/qwen2.5-72b-instruct</small>
                    </div>
                </div>
            </div>
            
            <!-- Промпты для трёхэтапного режима -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Промпты для трёхэтапного режима</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-3">
                        <i class="bi bi-info-circle"></i> 
                        <strong>Важно:</strong> Промпты можно настраивать для каждого этапа отдельно. 
                        Если промпт не указан, используются значения по умолчанию.
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage1_prompt" class="form-label">
                            Промпт для этапа 1 (текстовый ответ)
                            <small class="text-muted">- System Prompt для быстрого текстового ответа</small>
                        </label>
                        <textarea class="form-control" id="stage1_prompt" name="stage1_prompt" rows="4" 
                                  placeholder="Ты - помощник медицинской клиники. Отвечай на вопросы пользователей кратко и по делу (2-3 предложения)."><?php echo htmlspecialchars($widget['stage1_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Этот промпт используется как System Prompt. User Prompt формируется автоматически: "Вопрос пользователя: {вопрос}"</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage2_prompt" class="form-label">
                            Промпт для этапа 2 (извлечение терминов)
                            <small class="text-muted">- Полный промпт для извлечения медицинских терминов</small>
                        </label>
                        <textarea class="form-control" id="stage2_prompt" name="stage2_prompt" rows="12" 
                                  placeholder="Ты - помощник для извлечения медицинских терминов из вопроса пользователя.&#10;&#10;ВАЖНО: Верни ТОЛЬКО валидный JSON, без дополнительного текста до или после JSON.&#10;&#10;Твоя задача - максимально полно извлечь все релевантные медицинские термины из вопроса пользователя, включая:&#10;- Прямо упомянутые симптомы, заболевания, состояния&#10;- Связанные симптомы и состояния, которые могут быть связаны с упомянутыми&#10;- Все возможные специализации и специалистов, которые могут помочь&#10;- Типы услуг, диагностики и лечения, которые могут быть релевантны&#10;- Ключевые слова для поиска, включая синонимы, медицинские термины и разговорные названия&#10;&#10;Думай широко: если пользователь упоминает симптом, подумай о возможных причинах, связанных состояниях и специалистах, которые могут помочь.&#10;&#10;Из вопроса извлеки и верни в формате JSON:&#10;{&#10;  &quot;symptoms&quot;: [массив всех симптомов, включая связанные и возможные],&#10;  &quot;specializations&quot;: [массив всех релевантных специализаций и специалистов],&#10;  &quot;service_types&quot;: [массив всех типов услуг, диагностики и лечения],&#10;  &quot;keywords&quot;: [объединенный массив всех релевантных ключевых слов, включая синонимы и связанные термины]&#10;}&#10;&#10;Вопрос пользователя: {QUESTION}&#10;&#10;Верни ТОЛЬКО JSON объект, без объяснений и дополнительного текста."><?php echo htmlspecialchars($widget['stage2_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Используйте {QUESTION} как плейсхолдер для вопроса пользователя. Промпт должен требовать возврат JSON с полями: symptoms, specializations, service_types, keywords.</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage3_prompt" class="form-label">
                            Промпт для этапа 3 (основной запрос)
                            <small class="text-muted">- System Prompt для основного запроса (опционально)</small>
                        </label>
                        <textarea class="form-control" id="stage3_prompt" name="stage3_prompt" rows="6" 
                                  placeholder="Оставьте пустым, чтобы использовать основной промпт виджета (claude_prompt)"><?php echo htmlspecialchars($widget['stage3_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Если не указан, используется основной промпт виджета (claude_prompt). Если указан, он будет использоваться как System Prompt вместо claude_prompt.</small>
                    </div>
                </div>
            </div>
            
            <!-- Промпты для каждого раздела (шаги 2-5) -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Промпты для разделов (шаги 2-5)</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-3">
                        <i class="bi bi-info-circle"></i> 
                        <strong>Важно:</strong> Для каждого раздела можно настроить отдельный промпт. 
                        Если промпт не указан, используется stage3_prompt или основной промпт виджета (claude_prompt).
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_specialists_prompt" class="form-label">
                            Промпт для шага 2: Специалисты (specialists)
                            <small class="text-muted">- System Prompt для запросов по разделу специалистов</small>
                        </label>
                        <textarea class="form-control" id="stage_specialists_prompt" name="stage_specialists_prompt" rows="6" 
                                  placeholder="Оставьте пустым, чтобы использовать stage3_prompt или claude_prompt"><?php echo htmlspecialchars($widget['stage_specialists_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Промпт для запросов AI по разделу специалистов. Данные раздела будут добавлены автоматически.</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_specialists_model" class="form-label">
                            Модель для шага 2: Специалисты (specialists)
                            <small class="text-muted">- Модель для запросов по разделу специалистов</small>
                        </label>
                        <input type="text" class="form-control" id="stage_specialists_model" name="stage_specialists_model" 
                               value="<?php echo htmlspecialchars($widget['stage_specialists_model'] ?? ''); ?>" 
                               placeholder="Оставьте пустым, чтобы использовать stage3_model">
                        <small class="form-text text-muted">Если не указана, используется stage3_model. Примеры: qwen/qwen3-235b-a22b-2507, google/gemini-2.5-flash-lite</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_services_prompt" class="form-label">
                            Промпт для шага 3: Услуги (services)
                            <small class="text-muted">- System Prompt для запросов по разделу услуг</small>
                        </label>
                        <textarea class="form-control" id="stage_services_prompt" name="stage_services_prompt" rows="6" 
                                  placeholder="Оставьте пустым, чтобы использовать stage3_prompt или claude_prompt"><?php echo htmlspecialchars($widget['stage_services_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Промпт для запросов AI по разделу услуг. Данные раздела будут добавлены автоматически.</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_services_model" class="form-label">
                            Модель для шага 3: Услуги (services)
                            <small class="text-muted">- Модель для запросов по разделу услуг</small>
                        </label>
                        <input type="text" class="form-control" id="stage_services_model" name="stage_services_model" 
                               value="<?php echo htmlspecialchars($widget['stage_services_model'] ?? ''); ?>" 
                               placeholder="Оставьте пустым, чтобы использовать stage3_model">
                        <small class="form-text text-muted">Если не указана, используется stage3_model. Примеры: qwen/qwen3-235b-a22b-2507, google/gemini-2.5-flash-lite</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_specializations_prompt" class="form-label">
                            Промпт для шага 4: Специализации (specializations)
                            <small class="text-muted">- System Prompt для запросов по разделу специализаций</small>
                        </label>
                        <textarea class="form-control" id="stage_specializations_prompt" name="stage_specializations_prompt" rows="6" 
                                  placeholder="Оставьте пустым, чтобы использовать stage3_prompt или claude_prompt"><?php echo htmlspecialchars($widget['stage_specializations_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Промпт для запросов AI по разделу специализаций. Данные раздела будут добавлены автоматически.</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_specializations_model" class="form-label">
                            Модель для шага 4: Специализации (specializations)
                            <small class="text-muted">- Модель для запросов по разделу специализаций</small>
                        </label>
                        <input type="text" class="form-control" id="stage_specializations_model" name="stage_specializations_model" 
                               value="<?php echo htmlspecialchars($widget['stage_specializations_model'] ?? ''); ?>" 
                               placeholder="Оставьте пустым, чтобы использовать stage3_model">
                        <small class="form-text text-muted">Если не указана, используется stage3_model. Примеры: qwen/qwen3-235b-a22b-2507, google/gemini-2.5-flash-lite</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_articles_prompt" class="form-label">
                            Промпт для шага 5: Статьи (articles)
                            <small class="text-muted">- System Prompt для запросов по разделу статей</small>
                        </label>
                        <textarea class="form-control" id="stage_articles_prompt" name="stage_articles_prompt" rows="6" 
                                  placeholder="Оставьте пустым, чтобы использовать stage3_prompt или claude_prompt"><?php echo htmlspecialchars($widget['stage_articles_prompt'] ?? ''); ?></textarea>
                        <small class="form-text text-muted">Промпт для запросов AI по разделу статей. Данные раздела будут добавлены автоматически.</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="stage_articles_model" class="form-label">
                            Модель для шага 5: Статьи (articles)
                            <small class="text-muted">- Модель для запросов по разделу статей</small>
                        </label>
                        <input type="text" class="form-control" id="stage_articles_model" name="stage_articles_model" 
                               value="<?php echo htmlspecialchars($widget['stage_articles_model'] ?? ''); ?>" 
                               placeholder="Оставьте пустым, чтобы использовать stage3_model">
                        <small class="form-text text-muted">Если не указана, используется stage3_model. Примеры: qwen/qwen3-235b-a22b-2507, google/gemini-2.5-flash-lite</small>
                    </div>
                </div>
            </div>
            
            <!-- Парсинг -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Настройки парсинга</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="encoding" class="form-label">Кодировка сайта</label>
                        <select class="form-select" id="encoding" name="encoding">
                            <option value="auto" <?php echo $widget['encoding'] === 'auto' ? 'selected' : ''; ?>>Автоопределение</option>
                            <option value="UTF-8" <?php echo $widget['encoding'] === 'UTF-8' ? 'selected' : ''; ?>>UTF-8</option>
                            <option value="windows-1251" <?php echo $widget['encoding'] === 'windows-1251' ? 'selected' : ''; ?>>Windows-1251</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-save"></i> Сохранить настройки
                </button>
            </div>
        </form>
    </div>
    
    <div class="col-md-4">
        <!-- Код для подключения -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0">Код для подключения</h6>
            </div>
            <div class="card-body">
                <p class="text-muted small mb-3">Разместите этот код на странице, где хотите показать виджет:</p>
                <pre class="bg-dark p-3 rounded"><code>&lt;!-- Контейнер для AI виджета --&gt;
&lt;div id="ai-widget-container"&gt;&lt;/div&gt;

&lt;!-- Скрипт виджета --&gt;
&lt;script src="<?php echo WIDGET_DOMAIN; ?>/widget.js" 
        data-widget-key="<?php echo htmlspecialchars($widget['widget_key']); ?>"&gt;&lt;/script&gt;</code></pre>
                <button class="btn btn-sm btn-outline-primary w-100" onclick="copyCode()">
                    <i class="bi bi-clipboard"></i> Копировать
                </button>
                <div class="alert alert-info mt-3 mb-0 small">
                    <i class="bi bi-info-circle"></i> 
                    Виджет будет загружен в <code>&lt;div id="ai-widget-container"&gt;</code>. 
                    Вы можете изменить ID или использовать <code>data-widget-container="<?php echo htmlspecialchars($widget['widget_key']); ?>"</code>
                </div>
            </div>
        </div>
        
        <!-- Информация -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Информация</h6>
            </div>
            <div class="card-body small">
                <p><strong>Домен сайта:</strong><br><?php echo htmlspecialchars($widget['site_domain']); ?></p>
                <p><strong>Sitemap:</strong><br><a href="<?php echo htmlspecialchars($widget['sitemap_url']); ?>" target="_blank"><?php echo htmlspecialchars($widget['sitemap_url']); ?></a></p>
                <p><strong>Создан:</strong><br><?php echo date('d.m.Y H:i', strtotime($widget['created_at'])); ?></p>
                <p class="mb-0"><strong>Обновлен:</strong><br><?php echo date('d.m.Y H:i', strtotime($widget['updated_at'])); ?></p>
            </div>
        </div>
    </div>
</div>

<script>
function copyCode() {
    const code = `<script src="<?php echo WIDGET_DOMAIN; ?>/widget.js" data-widget-key="<?php echo htmlspecialchars($widget['widget_key']); ?>"><\/script>`;
    copyToClipboard(code);
}

// Синхронизация color picker и text input
document.getElementById('primary_color').addEventListener('input', function(e) {
    this.nextElementSibling.value = e.target.value;
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

