<?php
$page_title = 'Категоризация услуг';
require_once __DIR__ . '/includes/header.php';

$widget_id = $_GET['id'] ?? 0;
$error = '';
$success = '';

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT id, name FROM widgets WHERE id = ?");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    header('Location: /admin/');
    exit;
}

// Обработка сохранения ключевых слов
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_keywords') {
    $categoryId = (int)($_POST['category_id'] ?? 0);
    $keywordsJson = $_POST['keywords'] ?? '[]';
    
    try {
        $keywords = json_decode($keywordsJson, true);
        if (!is_array($keywords)) {
            throw new Exception('Invalid keywords format');
        }
        
        $stmt = $db->prepare("UPDATE category_keywords SET keywords = ? WHERE id = ? AND widget_id = ?");
        $stmt->execute([json_encode($keywords, JSON_UNESCAPED_UNICODE), $categoryId, $widget_id]);
        
        $success = 'Ключевые слова обновлены';
    } catch (Exception $e) {
        $error = 'Ошибка при сохранении: ' . $e->getMessage();
    }
}

// Получаем список разделов виджета
$stmt = $db->prepare("
    SELECT DISTINCT section_name 
    FROM widget_sections 
    WHERE widget_id = ? AND is_active = 1
    ORDER BY section_name
");
$stmt->execute([$widget_id]);
$sections = $stmt->fetchAll();

// Получаем выбранный раздел из параметра
$selectedSection = $_GET['section'] ?? ($sections[0]['section_name'] ?? 'services');
$sectionNames = [
    'services' => 'Услуги',
    'specialists' => 'Специалисты',
    'articles' => 'Статьи',
    'specializations' => 'Специализации'
];

// Проверяем, есть ли элементы в этом разделе
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM parsed_items pi
    WHERE pi.widget_id = ? 
      AND pi.section_name = ?
      AND pi.is_duplicate = 0
");
$stmt->execute([$widget_id, $selectedSection]);
$hasItems = $stmt->fetch()['count'] > 0;

// Получаем статус маппинга для выбранного раздела
$stmt = $db->prepare("SELECT COUNT(*) as count FROM category_keywords WHERE widget_id = ? AND section_name = ?");
$stmt->execute([$widget_id, $selectedSection]);
$mappingCount = $stmt->fetch()['count'];

// Получаем все категории с маппингом для выбранного раздела
$stmt = $db->prepare("
    SELECT ck.*, 
           (SELECT COUNT(*) FROM parsed_items pi 
            JOIN parsed_fields pf ON pi.id = pf.item_id 
            WHERE pi.widget_id = ? AND pi.section_name = ? 
              AND pf.field_name = 'category_id' AND pf.field_value LIKE CONCAT('%', ck.category_url, '%')) as items_count
    FROM category_keywords ck
    WHERE ck.widget_id = ? AND ck.section_name = ?
    ORDER BY ck.category_name
");
$stmt->execute([$widget_id, $selectedSection, $widget_id, $selectedSection]);
$categories = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-tags"></i> Категоризация: <?php echo htmlspecialchars($widget['name']); ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/widget-settings.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Назад
        </a>
    </div>
</div>

<!-- Выбор раздела -->
<div class="card mb-4">
    <div class="card-body">
        <h6 class="mb-3">Выберите раздел для категоризации:</h6>
        <div class="btn-group" role="group">
            <?php foreach ($sections as $section): ?>
                <a href="?id=<?php echo $widget_id; ?>&section=<?php echo htmlspecialchars($section['section_name']); ?>" 
                   class="btn btn-<?php echo $selectedSection === $section['section_name'] ? 'primary' : 'outline-primary'; ?>">
                    <?php echo htmlspecialchars($sectionNames[$section['section_name']] ?? ucfirst($section['section_name'])); ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<!-- Статус маппинга -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h5 class="mb-0">Статус маппинга категорий: <?php echo htmlspecialchars($sectionNames[$selectedSection] ?? ucfirst($selectedSection)); ?></h5>
                <p class="text-muted mb-0">
                    <?php if (!$hasItems): ?>
                        <span class="badge bg-info">Нет данных</span>
                        В этом разделе нет элементов для категоризации.
                    <?php elseif ($mappingCount > 0): ?>
                        <span class="badge bg-success">Создан</span> 
                        Обработано категорий: <strong><?php echo $mappingCount; ?></strong>
                    <?php else: ?>
                        <span class="badge bg-warning">Не создан</span>
                        Маппинг категорий не создан. Нажмите кнопку ниже для генерации.
                    <?php endif; ?>
                </p>
            </div>
            <div class="col-md-6 text-end">
                <?php if ($hasItems): ?>
                    <button class="btn btn-primary" onclick="showBatchDialog('<?php echo htmlspecialchars($selectedSection, ENT_QUOTES); ?>')" id="generateBtn">
                        <i class="bi bi-magic"></i> Сгенерировать маппинг
                    </button>
                    <button class="btn btn-success" onclick="continueMapping('<?php echo htmlspecialchars($selectedSection, ENT_QUOTES); ?>')" id="continueBtn" style="display: none;">
                        <i class="bi bi-play-circle"></i> Продолжить обработку
                    </button>
                    <?php if ($mappingCount > 0): ?>
                        <button class="btn btn-warning" onclick="regenerateMapping('<?php echo htmlspecialchars($selectedSection, ENT_QUOTES); ?>')" id="regenerateBtn">
                            <i class="bi bi-arrow-clockwise"></i> Пересоздать
                        </button>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Прогресс генерации -->
<div class="card mb-4" id="progressCard" style="display: none;">
    <div class="card-body">
        <h6>Генерация маппинга...</h6>
        <div class="progress mb-3">
            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%" id="progressBar"></div>
        </div>
        <p class="mb-2" id="progressText">Начало генерации...</p>
        <div id="progressDetails" class="small text-muted"></div>
    </div>
</div>

<!-- Логи AI -->
<div class="card mb-4" id="logCard" style="display: none;">
    <div class="card-header">
        <h6 class="mb-0">Лог взаимодействия с AI</h6>
    </div>
    <div class="card-body">
        <div class="mb-3">
            <h6>Отправленный промпт:</h6>
            <pre class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto; font-size: 0.85em;" id="logPrompt"></pre>
        </div>
        <div>
            <h6>Ответ AI:</h6>
            <pre class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto; font-size: 0.85em;" id="logResponse"></pre>
        </div>
    </div>
</div>

<!-- Список категорий -->
<?php if ($hasItems && !empty($categories)): ?>
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Категории и ключевые слова</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Категория</th>
                            <th>URL</th>
                            <th>Услуг</th>
                            <th>Ключевые слова</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($categories as $cat): ?>
                            <tr>
                                <td><strong><?php echo htmlspecialchars($cat['category_name']); ?></strong></td>
                                <td><small class="text-muted"><?php echo htmlspecialchars($cat['category_url']); ?></small></td>
                                <td><?php echo $cat['items_count']; ?></td>
                                <td>
                                    <?php 
                                    $keywords = json_decode($cat['keywords'], true);
                                    if (is_array($keywords)) {
                                        echo '<span class="badge bg-secondary me-1">' . implode('</span> <span class="badge bg-secondary me-1">', array_slice($keywords, 0, 5)) . '</span>';
                                        if (count($keywords) > 5) {
                                            echo ' <small class="text-muted">+' . (count($keywords) - 5) . ' еще</small>';
                                        }
                                    }
                                    ?>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="editKeywords(<?php echo $cat['id']; ?>, '<?php echo htmlspecialchars($cat['category_name'], ENT_QUOTES); ?>', <?php echo htmlspecialchars(json_encode($keywords), ENT_QUOTES); ?>)">
                                        <i class="bi bi-pencil"></i> Редактировать
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Модальное окно выбора размера батча -->
<div class="modal fade" id="batchDialog" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Настройки генерации маппинга</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="batchSize" class="form-label">Количество элементов в батче</label>
                    <input type="number" class="form-control" id="batchSize" value="10" min="1" max="100">
                    <small class="text-muted">Рекомендуется 10-30 элементов. Больше элементов = больше токенов.</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                <button type="button" class="btn btn-primary" onclick="confirmBatchStart()">Начать</button>
            </div>
        </div>
    </div>
</div>

<!-- Модальное окно редактирования -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Редактировать ключевые слова</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="editForm">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_keywords">
                    <input type="hidden" name="category_id" id="editCategoryId">
                    <div class="mb-3">
                        <label class="form-label">Категория</label>
                        <input type="text" class="form-control" id="editCategoryName" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ключевые слова (по одному на строку)</label>
                        <textarea class="form-control" id="editKeywords" rows="10" name="keywords"></textarea>
                        <small class="text-muted">Введите ключевые слова, каждое с новой строки</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                    <button type="submit" class="btn btn-primary">Сохранить</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let currentSection = '';
let currentBatchSize = 10;

function showBatchDialog(sectionName) {
    currentSection = sectionName;
    const modal = new bootstrap.Modal(document.getElementById('batchDialog'));
    modal.show();
}

function confirmBatchStart() {
    currentBatchSize = parseInt(document.getElementById('batchSize').value) || 10;
    if (currentBatchSize < 1 || currentBatchSize > 100) {
        alert('Размер батча должен быть от 1 до 100');
        return;
    }
    bootstrap.Modal.getInstance(document.getElementById('batchDialog')).hide();
    generateMapping(currentSection, currentBatchSize, true);
}

function generateMapping(sectionName, batchSize = 10, reset = false) {
    document.getElementById('generateBtn').disabled = true;
    document.getElementById('continueBtn').style.display = 'none';
    if (document.getElementById('regenerateBtn')) {
        document.getElementById('regenerateBtn').disabled = true;
    }
    document.getElementById('progressCard').style.display = 'block';
    document.getElementById('logCard').style.display = 'none';
    document.getElementById('progressBar').style.width = '0%';
    document.getElementById('progressText').textContent = 'Начало генерации для раздела: ' + sectionName + '...';
    document.getElementById('progressDetails').textContent = '';
    
    const url = '/admin/scripts/generate-category-mapping.php?widget_id=<?php echo $widget_id; ?>&section=' + encodeURIComponent(sectionName) + '&batch_size=' + batchSize + (reset ? '&reset=1' : '');
    
    fetch(url)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const progress = Math.round((data.processed / data.total_items) * 100);
                document.getElementById('progressBar').style.width = progress + '%';
                
                let progressText = `Батч ${data.batch_number} из ${data.total_batches}. `;
                progressText += `Обработано: ${data.processed} из ${data.total_items} элементов. `;
                progressText += `Осталось: ${data.remaining} элементов. `;
                progressText += `Создано категорий в этом батче: ${data.categories_created}`;
                
                document.getElementById('progressText').textContent = progressText;
                document.getElementById('progressDetails').innerHTML = 
                    `<strong>Размер батча:</strong> ${data.batch_size} элементов<br>` +
                    (data.errors && data.errors.length > 0 ? `<span class="text-danger"><strong>Ошибки:</strong> ${data.errors.join('; ')}</span>` : '');
                
                // Показываем логи
                if (data.log) {
                    document.getElementById('logCard').style.display = 'block';
                    document.getElementById('logPrompt').textContent = data.log.prompt || '';
                    document.getElementById('logResponse').textContent = data.log.response || '';
                }
                
                if (data.completed) {
                    document.getElementById('progressText').textContent = 'Генерация завершена! Обработано категорий: ' + data.categories_created + '. Обновление страницы...';
                    setTimeout(() => {
                        window.location.reload();
                    }, 3000);
                } else {
                    document.getElementById('continueBtn').style.display = 'inline-block';
                    document.getElementById('continueBtn').onclick = function() {
                        continueMapping(sectionName, batchSize);
                    };
                    document.getElementById('generateBtn').disabled = false;
                    if (document.getElementById('regenerateBtn')) {
                        document.getElementById('regenerateBtn').disabled = false;
                    }
                }
            } else {
                alert('Ошибка: ' + (data.error || 'Неизвестная ошибка'));
                document.getElementById('generateBtn').disabled = false;
                if (document.getElementById('regenerateBtn')) {
                    document.getElementById('regenerateBtn').disabled = false;
                }
                document.getElementById('progressCard').style.display = 'none';
            }
        })
        .catch(error => {
            alert('Ошибка: ' + error.message);
            document.getElementById('generateBtn').disabled = false;
            if (document.getElementById('regenerateBtn')) {
                document.getElementById('regenerateBtn').disabled = false;
            }
            document.getElementById('progressCard').style.display = 'none';
        });
}

function continueMapping(sectionName, batchSize = 10) {
    generateMapping(sectionName, batchSize || currentBatchSize, false);
}

function regenerateMapping(sectionName) {
    if (!confirm('Пересоздать маппинг для раздела "' + sectionName + '"? Старые данные будут удалены.')) {
        return;
    }
    currentSection = sectionName;
    const modal = new bootstrap.Modal(document.getElementById('batchDialog'));
    modal.show();
    
    // Переопределяем confirmBatchStart для этого случая
    const originalConfirm = window.confirmBatchStart;
    window.confirmBatchStart = function() {
        currentBatchSize = parseInt(document.getElementById('batchSize').value) || 10;
        if (currentBatchSize < 1 || currentBatchSize > 100) {
            alert('Размер батча должен быть от 1 до 100');
            return;
        }
        bootstrap.Modal.getInstance(document.getElementById('batchDialog')).hide();
        generateMapping(currentSection, currentBatchSize, true);
        window.confirmBatchStart = originalConfirm;
    };
}

function editKeywords(categoryId, categoryName, keywords) {
    document.getElementById('editCategoryId').value = categoryId;
    document.getElementById('editCategoryName').value = categoryName;
    document.getElementById('editKeywords').value = Array.isArray(keywords) ? keywords.join('\n') : '';
    
    const modal = new bootstrap.Modal(document.getElementById('editModal'));
    modal.show();
}

// Конвертация текста в JSON при отправке формы
document.getElementById('editForm').addEventListener('submit', function(e) {
    const keywordsText = document.getElementById('editKeywords').value;
    const keywords = keywordsText.split('\n')
        .map(k => k.trim())
        .filter(k => k.length > 0);
    
    const hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = 'keywords';
    hiddenInput.value = JSON.stringify(keywords);
    this.appendChild(hiddenInput);
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

