<?php
$page_title = 'Разделы виджета';
require_once __DIR__ . '/includes/header.php';

$widget_id = $_GET['widget_id'] ?? 0;

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT * FROM widgets WHERE id = ?");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    header('Location: /admin/');
    exit;
}

// Получаем настройки виджета
$stmt = $db->prepare("SELECT * FROM widget_settings WHERE widget_id = ?");
$stmt->execute([$widget_id]);
$settings = $stmt->fetch();

// Получаем разделы с количеством полей и данных
$stmt = $db->prepare("
    SELECT 
        ws.*,
        (SELECT COUNT(*) FROM section_fields WHERE section_id = ws.id) as fields_count,
        (SELECT COUNT(*) FROM parsed_items WHERE widget_id = ? AND section_name = ws.section_name) as items_count
    FROM widget_sections ws
    WHERE ws.widget_id = ?
    ORDER BY 
        CASE ws.section_name
            WHEN 'specialists' THEN 1
            WHEN 'services' THEN 2
            WHEN 'specializations' THEN 3
            WHEN 'articles' THEN 4
        END
");
$stmt->execute([$widget_id, $widget_id]);
$sections = $stmt->fetchAll();

// Названия разделов на русском
$section_names = [
    'specialists' => 'Специалисты',
    'services' => 'Услуги',
    'specializations' => 'Специализации',
    'articles' => 'Статьи'
];

$section_icons = [
    'specialists' => 'people',
    'services' => 'gear',
    'specializations' => 'bookmark',
    'articles' => 'file-text'
];
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-list"></i> Разделы виджета
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <div class="btn-group me-2">
            <a href="/admin/widget-urls.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-primary">
                <i class="bi bi-link-45deg"></i> Управление URL
            </a>
        </div>
        <a href="/admin/widget-settings.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Настройки
        </a>
    </div>
</div>

<div class="alert alert-info">
    <i class="bi bi-info-circle"></i> <strong><?php echo htmlspecialchars($widget['name']); ?></strong><br>
    <small>
        <?php if (!empty($settings['crawler_enabled'])): ?>
            Используется <strong>веб-краулинг</strong> для сбора URL. 
            <a href="/admin/widget-urls.php?id=<?php echo $widget_id; ?>">Управление URL →</a>
        <?php else: ?>
            Используется <strong>sitemap.xml</strong> для сбора URL. 
            Если sitemap сломан, <a href="/admin/widget-urls.php?id=<?php echo $widget_id; ?>">включите краулинг</a>.
        <?php endif; ?>
        <br>
        Настройте каждый раздел: укажите URL pattern для фильтрации страниц, настройте CSS селекторы полей, протестируйте и запустите парсинг.
    </small>
</div>

<div class="row">
    <?php foreach ($sections as $section): ?>
        <div class="col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="bi bi-<?php echo $section_icons[$section['section_name']]; ?>"></i>
                        <?php echo $section_names[$section['section_name']]; ?>
                    </h5>
                    <?php if ($section['is_active']): ?>
                        <span class="badge badge-status-active">Активен</span>
                    <?php else: ?>
                        <span class="badge badge-status-inactive">Неактивен</span>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-5">URL Pattern:</dt>
                        <dd class="col-sm-7">
                            <code><?php echo htmlspecialchars($section['url_pattern']); ?></code>
                        </dd>
                        
                        <dt class="col-sm-5">Полей настроено:</dt>
                        <dd class="col-sm-7">
                            <span class="badge bg-info"><?php echo $section['fields_count']; ?></span>
                        </dd>
                        
                        <dt class="col-sm-5">Данных спарсено:</dt>
                        <dd class="col-sm-7">
                            <span class="badge bg-success"><?php echo $section['items_count']; ?></span>
                        </dd>
                        
                        <dt class="col-sm-5">Тест-лимит:</dt>
                        <dd class="col-sm-7">
                            <?php echo $section['test_limit']; ?> страниц
                        </dd>
                    </dl>
                </div>
                <div class="card-footer">
                    <div class="btn-group btn-group-sm w-100" role="group">
                        <a href="/admin/section-fields.php?section_id=<?php echo $section['id']; ?>" class="btn btn-outline-primary">
                            <i class="bi bi-pencil"></i> Настроить
                        </a>
                        <a href="/admin/section-test.php?section_id=<?php echo $section['id']; ?>" class="btn btn-outline-info">
                            <i class="bi bi-play"></i> Тест
                        </a>
                        <a href="/admin/section-data.php?section_id=<?php echo $section['id']; ?>" class="btn btn-outline-success">
                            <i class="bi bi-database"></i> Данные
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<!-- Быстрый старт -->
<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">Быстрый старт</h5>
    </div>
    <div class="card-body">
        <ol>
            <li class="mb-2">
                <strong>Настройте поля и селекторы</strong> для каждого раздела<br>
                <small class="text-muted">Кликните "Настроить" → укажите CSS селекторы для каждого поля → сохраните</small>
            </li>
            <li class="mb-2">
                <strong>Протестируйте парсинг</strong> на нескольких страницах<br>
                <small class="text-muted">Кликните "Тест" → проверьте результаты → если нужно, скорректируйте селекторы</small>
            </li>
            <li class="mb-2">
                <strong>Запустите полный парсинг</strong><br>
                <small class="text-muted">После успешного теста запустите парсинг всех страниц раздела</small>
            </li>
            <li class="mb-0">
                <strong>Просмотрите и очистите данные</strong><br>
                <small class="text-muted">Кликните "Данные" → найдите дубли → удалите лишнее</small>
            </li>
        </ol>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

