<?php
$page_title = 'Полный парсинг';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/../vendor/autoload.php';

use AIWidget\Parser\SitemapParser;
use AIWidget\Parser\PageParser;

$section_id = $_GET['section_id'] ?? 0;

// Получаем раздел и виджет
$db = getDatabase();
$stmt = $db->prepare("
    SELECT ws.*, w.*, w.id as widget_id, w.name as widget_name
    FROM widget_sections ws
    JOIN widgets w ON ws.widget_id = w.id
    WHERE ws.id = ?
");
$stmt->execute([$section_id]);
$section = $stmt->fetch();

if (!$section) {
    header('Location: /admin/');
    exit;
}

$section_names = [
    'specialists' => 'Специалисты',
    'services' => 'Услуги',
    'specializations' => 'Специализации',
    'articles' => 'Статьи'
];

// Получаем поля раздела
$stmt = $db->prepare("SELECT * FROM section_fields WHERE section_id = ? ORDER BY field_order");
$stmt->execute([$section_id]);
$fields = $stmt->fetchAll();

// Получаем настройки виджета
$stmt = $db->prepare("SELECT * FROM widget_settings WHERE widget_id = ?");
$stmt->execute([$section['widget_id']]);
$settings = $stmt->fetch();

// Запуск парсинга
if (isset($_POST['start_parsing'])) {
    try {
        // Проверяем есть ли уже активное задание
        $stmt = $db->prepare("
            SELECT id FROM parsing_jobs 
            WHERE widget_id = ? AND section_name = ? AND status = 'running'
        ");
        $stmt->execute([$section['widget_id'], $section['section_name']]);
        if ($stmt->fetch()) {
            throw new Exception('Парсинг уже запущен для этого раздела');
        }
        
        // Проверяем включен ли краулинг
        $useCrawler = !empty($settings['crawler_enabled']);
        
        if ($useCrawler) {
            // Используем discovered_urls
            $stmt = $db->prepare("
                SELECT url FROM discovered_urls 
                WHERE widget_id = ? AND assigned_section = ? AND is_canonical = 1
            ");
            $stmt->execute([$section['widget_id'], $section['section_name']]);
            $urls = $stmt->fetchAll();
            
            if (empty($urls)) {
                throw new Exception('Не найдено URL назначенных этому разделу. Перейдите на страницу "Управление URL" и назначьте разделы.');
            }
        } else {
            // Используем sitemap
            $stmt = $db->prepare("
                SELECT url, last_modified FROM sitemap_urls 
                WHERE widget_id = ? AND url LIKE ?
            ");
            $pattern = '%' . $section['url_pattern'] . '%';
            $stmt->execute([$section['widget_id'], $pattern]);
            $urls = $stmt->fetchAll();
            
            if (empty($urls)) {
                throw new Exception('Не найдено URL соответствующих паттерну');
            }
        }
        
        // Создаем задание парсинга
        $stmt = $db->prepare("
            INSERT INTO parsing_jobs (widget_id, section_name, total_pages, processed_pages, status)
            VALUES (?, ?, ?, 0, 'running')
        ");
        $stmt->execute([$section['widget_id'], $section['section_name'], count($urls)]);
        $job_id = $db->lastInsertId();
        
        // Запускаем парсинг в фоне (используем правильный скрипт в зависимости от метода)
        if ($useCrawler) {
            $cmd = "php " . __DIR__ . "/../parser/run-parsing-discovered.php $job_id $section_id > /dev/null 2>&1 &";
        } else {
            $cmd = "php " . __DIR__ . "/../parser/run-parsing.php $job_id $section_id > /dev/null 2>&1 &";
        }
        exec($cmd);
        
        header("Location: /admin/section-parse.php?section_id=$section_id&job_id=$job_id");
        exit;
        
    } catch (Exception $e) {
        $error = $e->getMessage();
        logParser("Start parsing error: " . $error);
    }
}

// Проверяем активное задание
$job_id = $_GET['job_id'] ?? 0;
$job = null;
if ($job_id) {
    $stmt = $db->prepare("SELECT * FROM parsing_jobs WHERE id = ?");
    $stmt->execute([$job_id]);
    $job = $stmt->fetch();
}

// Получаем количество спарсенных элементов
$stmt = $db->prepare("
    SELECT COUNT(*) FROM parsed_items 
    WHERE widget_id = ? AND section_name = ?
");
$stmt->execute([$section['widget_id'], $section['section_name']]);
$existing_count = $stmt->fetchColumn();

// Получаем количество URL по паттерну
$stmt = $db->prepare("
    SELECT COUNT(*) FROM sitemap_urls 
    WHERE widget_id = ? AND url LIKE ?
");
$pattern = '%' . $section['url_pattern'] . '%';
$stmt->execute([$section['widget_id'], $pattern]);
$total_urls = $stmt->fetchColumn();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-lightning"></i> Полный парсинг: <?php echo $section_names[$section['section_name']]; ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/section-test.php?section_id=<?php echo $section_id; ?>" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> К тесту
        </a>
    </div>
</div>

<?php if (isset($error)): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Информация о парсинге</h5>
            </div>
            <div class="card-body">
                <dl class="row mb-0">
                    <dt class="col-sm-4">Раздел:</dt>
                    <dd class="col-sm-8"><?php echo $section_names[$section['section_name']]; ?></dd>
                    
                    <dt class="col-sm-4">URL Pattern:</dt>
                    <dd class="col-sm-8"><code><?php echo htmlspecialchars($section['url_pattern']); ?></code></dd>
                    
                    <dt class="col-sm-4">Найдено URL:</dt>
                    <dd class="col-sm-8"><span class="badge bg-info"><?php echo $total_urls; ?></span> страниц</dd>
                    
                    <dt class="col-sm-4">Уже спарсено:</dt>
                    <dd class="col-sm-8"><span class="badge bg-success"><?php echo $existing_count; ?></span> элементов</dd>
                    
                    <dt class="col-sm-4">Полей настроено:</dt>
                    <dd class="col-sm-8"><?php echo count($fields); ?></dd>
                </dl>
            </div>
        </div>
        
        <?php if ($job && $job['status'] === 'running'): ?>
            <!-- Прогресс парсинга -->
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Прогресс парсинга</h5>
                </div>
                <div class="card-body">
                    <div id="progress-container">
                        <div class="progress mb-3" style="height: 30px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                 id="progress-bar" 
                                 role="progressbar" 
                                 style="width: 0%">
                                <span id="progress-text">0%</span>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <div>
                                <strong>Обработано:</strong> <span id="processed">0</span> из <span id="total">0</span>
                            </div>
                            <div>
                                <strong>Статус:</strong> <span id="status" class="badge bg-primary">В процессе</span>
                            </div>
                        </div>
                        
                        <div id="errors-container" class="mt-3" style="display: none;">
                            <strong>Ошибки:</strong>
                            <div id="errors-list" class="small text-danger"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif ($job && $job['status'] === 'completed'): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle"></i> <strong>Парсинг завершен!</strong><br>
                Обработано: <?php echo $job['processed_pages']; ?> из <?php echo $job['total_pages']; ?> страниц
            </div>
            <div class="d-grid gap-2">
                <a href="/admin/section-data.php?section_id=<?php echo $section_id; ?>" class="btn btn-success btn-lg">
                    <i class="bi bi-database"></i> Посмотреть данные
                </a>
            </div>
        <?php else: ?>
            <!-- Кнопка запуска -->
            <div class="card">
                <div class="card-body text-center py-5">
                    <i class="bi bi-lightning-charge" style="font-size: 4rem; opacity: 0.5;"></i>
                    <h4 class="mt-3">Готовы запустить полный парсинг?</h4>
                    <p class="text-muted">Будет обработано <?php echo $total_urls; ?> страниц</p>
                    
                    <form method="POST" onsubmit="return confirm('Запустить парсинг <?php echo $total_urls; ?> страниц?');">
                        <button type="submit" name="start_parsing" class="btn btn-primary btn-lg">
                            <i class="bi bi-play-circle"></i> Запустить парсинг
                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Что будет сделано</h6>
            </div>
            <div class="card-body small">
                <ul class="mb-0">
                    <li>Загрузка всех <?php echo $total_urls; ?> страниц</li>
                    <li>Парсинг по настроенным CSS селекторам</li>
                    <li>Автоопределение кодировки</li>
                    <li>Очистка HTML тегов</li>
                    <li>Конвертация относительных URL</li>
                    <li>Сохранение в базу данных</li>
                    <li>Обработка ошибок (404, timeout)</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php if ($job && $job['status'] === 'running'): ?>
<script>
const jobId = <?php echo $job_id; ?>;

function updateProgress() {
    fetch('/admin/ajax/parse-status.php?job_id=' + jobId)
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const percent = Math.round((data.processed / data.total) * 100);
                
                document.getElementById('progress-bar').style.width = percent + '%';
                document.getElementById('progress-text').textContent = percent + '%';
                document.getElementById('processed').textContent = data.processed;
                document.getElementById('total').textContent = data.total;
                
                if (data.status === 'completed') {
                    document.getElementById('status').textContent = 'Завершено';
                    document.getElementById('status').className = 'badge bg-success';
                    setTimeout(() => location.reload(), 2000);
                } else if (data.status === 'failed') {
                    document.getElementById('status').textContent = 'Ошибка';
                    document.getElementById('status').className = 'badge bg-danger';
                } else {
                    setTimeout(updateProgress, 1000);
                }
                
                if (data.errors && data.errors.length > 0) {
                    document.getElementById('errors-container').style.display = 'block';
                    document.getElementById('errors-list').innerHTML = data.errors.slice(0, 5).join('<br>');
                }
            }
        })
        .catch(err => {
            console.error('Error fetching progress:', err);
            setTimeout(updateProgress, 2000);
        });
}

// Запускаем обновление
updateProgress();
</script>
<?php endif; ?>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

