<?php
$page_title = 'Логи запросов';
require_once __DIR__ . '/includes/header.php';

$widget_id = $_GET['widget_id'] ?? null;
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 50;
$offset = ($page - 1) * $per_page;

// Получаем виджеты для фильтра
$db = getDatabase();
$widgets = $db->query("SELECT id, name FROM widgets ORDER BY name")->fetchAll();

// Строим запрос
$where = [];
$params = [];

if ($widget_id) {
    $where[] = "widget_id = ?";
    $params[] = $widget_id;
}

$where_sql = !empty($where) ? "WHERE " . implode(" AND ", $where) : "";

// Получаем логи - оптимизированный запрос для избежания "Out of sort memory"
// Сначала получаем ID записей с сортировкой, затем делаем JOIN
// Это позволяет MySQL сортировать только маленькие ID, а не все данные
$stmt = $db->prepare("
    SELECT 
        wl.*,
        w.name as widget_name,
        w.widget_key
    FROM (
        SELECT id
        FROM widget_logs
        $where_sql
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?
    ) AS wl_ids
    JOIN widget_logs wl ON wl_ids.id = wl.id
    JOIN widgets w ON wl.widget_id = w.id
    ORDER BY wl.created_at DESC
");
$stmt->execute(array_merge($params, [$per_page, $offset]));
$logs = $stmt->fetchAll();

// Подсчет общего количества
// Используем тот же WHERE, но с алиасом wl для совместимости
$count_where_sql = "";
if ($widget_id) {
    $count_where_sql = "WHERE wl.widget_id = ?";
}
$stmt = $db->prepare("SELECT COUNT(*) FROM widget_logs wl $count_where_sql");
$stmt->execute($params);
$total = $stmt->fetchColumn();
$total_pages = ceil($total / $per_page);
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-file-text"></i> Логи запросов
    </h1>
</div>

<!-- Фильтр -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label for="widget_id" class="form-label">Виджет</label>
                <select class="form-select" id="widget_id" name="widget_id">
                    <option value="">Все виджеты</option>
                    <?php foreach ($widgets as $w): ?>
                        <option value="<?php echo $w['id']; ?>" <?php echo $widget_id == $w['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($w['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">Фильтр</button>
            </div>
        </form>
    </div>
</div>

<!-- Таблица логов -->
<div class="card">
    <div class="card-body">
        <?php if (empty($logs)): ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; opacity: 0.3;"></i>
                <p class="mt-3 text-muted">Логов пока нет</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="12%">Дата</th>
                            <th width="12%">Виджет</th>
                            <th width="22%">Вопрос</th>
                            <th width="22%">Ответ</th>
                            <th width="10%">Токены</th>
                            <th width="10%">Время</th>
                            <th width="12%">Стоимость</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                            <tr>
                                <td>
                                    <small><?php echo date('d.m.Y H:i', strtotime($log['created_at'])); ?></small>
                                </td>
                                <td>
                                    <small>
                                        <?php echo htmlspecialchars($log['widget_name']); ?><br>
                                        <code><?php echo htmlspecialchars($log['widget_key']); ?></code>
                                    </small>
                                </td>
                                <td>
                                    <small><?php echo htmlspecialchars(mb_substr($log['question'], 0, 100)); ?></small>
                                </td>
                                <td>
                                    <?php if ($log['error_message']): ?>
                                        <span class="badge bg-danger">Ошибка</span>
                                        <small><?php echo htmlspecialchars($log['error_message']); ?></small>
                                    <?php else: ?>
                                        <small><?php echo htmlspecialchars(mb_substr($log['answer'], 0, 100)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($log['tokens_used']): ?>
                                        <span class="badge bg-info"><?php echo number_format($log['tokens_used']); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($log['response_time_ms']): ?>
                                        <small><?php echo round($log['response_time_ms'] / 1000, 2); ?>s</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (isset($log['openrouter_cost']) && $log['openrouter_cost'] > 0): ?>
                                        <span class="badge bg-success">$<?php echo number_format($log['openrouter_cost'], 6); ?></span>
                                    <?php else: ?>
                                        <small class="text-muted">—</small>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Пагинация -->
            <?php if ($total_pages > 1): ?>
                <nav class="mt-3">
                    <ul class="pagination justify-content-center">
                        <?php if ($page > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo $page - 1; ?><?php echo $widget_id ? '&widget_id=' . $widget_id : ''; ?>">Назад</a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $page - 2); $i <= min($total_pages, $page + 2); $i++): ?>
                            <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?><?php echo $widget_id ? '&widget_id=' . $widget_id : ''; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($page < $total_pages): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo $page + 1; ?><?php echo $widget_id ? '&widget_id=' . $widget_id : ''; ?>">Вперед</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

