<?php
$page_title = 'Дашборд';
require_once __DIR__ . '/includes/header.php';

// Получаем список виджетов
$db = getDatabase();
$widgets = $db->query("
    SELECT 
        w.*,
        (SELECT COUNT(*) FROM widget_logs WHERE widget_id = w.id) as total_requests,
        (SELECT COUNT(*) FROM widget_logs WHERE widget_id = w.id AND DATE(created_at) = CURDATE()) as today_requests,
        (SELECT COUNT(*) FROM parsed_items WHERE widget_id = w.id) as total_items
    FROM widgets w
    ORDER BY w.created_at DESC
")->fetchAll();

// Общая статистика
$stats = $db->query("
    SELECT 
        (SELECT COUNT(*) FROM widgets) as total_widgets,
        (SELECT COUNT(*) FROM widgets WHERE active = 1) as active_widgets,
        (SELECT COUNT(*) FROM widget_logs WHERE DATE(created_at) = CURDATE()) as today_requests,
        (SELECT COUNT(*) FROM parsed_items) as total_items
")->fetch();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">Дашборд</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/widget-create.php" class="btn btn-sm btn-primary">
            <i class="bi bi-plus-circle"></i> Создать виджет
        </a>
    </div>
</div>

<!-- Статистика -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-1">Всего виджетов</h6>
                        <h3 class="mb-0"><?php echo $stats['total_widgets']; ?></h3>
                    </div>
                    <div class="text-primary">
                        <i class="bi bi-widget" style="font-size: 2rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-1">Активных</h6>
                        <h3 class="mb-0"><?php echo $stats['active_widgets']; ?></h3>
                    </div>
                    <div class="text-success">
                        <i class="bi bi-check-circle" style="font-size: 2rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-1">Запросов сегодня</h6>
                        <h3 class="mb-0"><?php echo $stats['today_requests']; ?></h3>
                    </div>
                    <div class="text-info">
                        <i class="bi bi-graph-up" style="font-size: 2rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-1">Всего данных</h6>
                        <h3 class="mb-0"><?php echo $stats['total_items']; ?></h3>
                    </div>
                    <div class="text-warning">
                        <i class="bi bi-database" style="font-size: 2rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Список виджетов -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Виджеты</h5>
    </div>
    <div class="card-body">
        <?php if (empty($widgets)): ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; opacity: 0.3;"></i>
                <p class="mt-3 text-muted">Виджеты еще не созданы</p>
                <a href="/admin/widget-create.php" class="btn btn-primary">Создать первый виджет</a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Название</th>
                            <th>Widget Key</th>
                            <th>Домен</th>
                            <th>Данных</th>
                            <th>Запросов</th>
                            <th>Статус</th>
                            <th>Создан</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($widgets as $widget): ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($widget['name']); ?></strong>
                                </td>
                                <td>
                                    <code><?php echo htmlspecialchars($widget['widget_key']); ?></code>
                                </td>
                                <td>
                                    <small><?php echo htmlspecialchars($widget['site_domain']); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?php echo $widget['total_items']; ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-primary"><?php echo $widget['total_requests']; ?></span>
                                    <?php if ($widget['today_requests'] > 0): ?>
                                        <small class="text-success">(+<?php echo $widget['today_requests']; ?> сегодня)</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($widget['active']): ?>
                                        <span class="badge badge-status-active">Активен</span>
                                    <?php else: ?>
                                        <span class="badge badge-status-inactive">Неактивен</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small><?php echo date('d.m.Y', strtotime($widget['created_at'])); ?></small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="/admin/widget-settings.php?id=<?php echo $widget['id']; ?>" class="btn btn-outline-primary" title="Настройки">
                                            <i class="bi bi-gear"></i>
                                        </a>
                                        <a href="/admin/sections-list.php?widget_id=<?php echo $widget['id']; ?>" class="btn btn-outline-info" title="Разделы">
                                            <i class="bi bi-list"></i>
                                        </a>
                                        <a href="/admin/widget-test.php?id=<?php echo $widget['id']; ?>" class="btn btn-outline-success" title="Тестировать">
                                            <i class="bi bi-play-circle"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deleteWidget(<?php echo $widget['id']; ?>)" title="Удалить">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function deleteWidget(id) {
    if (!confirm('Вы уверены, что хотите удалить этот виджет? Все данные будут потеряны!')) {
        return;
    }
    
    fetch('/admin/ajax/delete-widget.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ widget_id: id })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showAlert('Виджет удален', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

