<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/auth.php';

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="ru" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'AI Widget'; ?> - Админ-панель</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="/admin/assets/style.css">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-2 col-lg-2 d-md-block bg-dark sidebar">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <h5 class="text-white">AI Widget</h5>
                        <small class="text-muted">v2.0</small>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'index' ? 'active' : ''; ?>" href="/admin/">
                                <i class="bi bi-speedometer2"></i> Дашборд
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo in_array($current_page, ['widget-create', 'widget-settings', 'widget-test', 'widget-templates', 'sections-list', 'section-fields', 'section-test', 'section-data']) ? 'active' : ''; ?>" href="/admin/">
                                <i class="bi bi-widget"></i> Виджеты
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'widget-tester' ? 'active' : ''; ?>" href="/admin/widget-tester.php">
                                <i class="bi bi-flask"></i> Тестер виджета
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'custom-api-test' ? 'active' : ''; ?>" href="/admin/custom-api-test.php">
                                <i class="bi bi-cloud-upload"></i> Тест кастомного API
                            </a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle <?php echo in_array($current_page, ['optimization-prefilter', 'optimization-compress', 'optimization-minify', 'optimization-shorten', 'optimization-group']) ? 'active' : ''; ?>" href="#" id="optimizationsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-lightning-charge"></i> Оптимизации
                            </a>
                            <ul class="dropdown-menu bg-dark" aria-labelledby="optimizationsDropdown">
                                <li><a class="dropdown-item text-light" href="/admin/optimization-prefilter.php"><i class="bi bi-funnel"></i> Предварительная фильтрация</a></li>
                                <li><a class="dropdown-item text-light" href="/admin/optimization-compress.php"><i class="bi bi-compress"></i> Сжатие описаний</a></li>
                                <li><a class="dropdown-item text-light" href="/admin/optimization-minify.php"><i class="bi bi-code-slash"></i> Минификация JSON</a></li>
                                <li><a class="dropdown-item text-light" href="/admin/optimization-shorten.php"><i class="bi bi-scissors"></i> Сокращение инструкций</a></li>
                                <li><a class="dropdown-item text-light" href="/admin/optimization-group.php"><i class="bi bi-diagram-3"></i> Группировка по категориям</a></li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'logs' ? 'active' : ''; ?>" href="/admin/logs.php">
                                <i class="bi bi-file-text"></i> Логи
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'clients' ? 'active' : ''; ?>" href="/admin/clients.php">
                                <i class="bi bi-people"></i> Клиенты
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'backup' ? 'active' : ''; ?>" href="/admin/backup.php">
                                <i class="bi bi-archive"></i> Бэкапы
                            </a>
                        </li>
                    </ul>
                    
                    <hr class="text-white">
                    
                    <div class="px-3">
                        <div class="d-flex align-items-center text-white small">
                            <i class="bi bi-person-circle me-2"></i>
                            <span><?php echo htmlspecialchars($_SESSION['admin_username']); ?></span>
                        </div>
                        <a href="/admin/logout.php" class="btn btn-outline-light btn-sm mt-2 w-100">
                            <i class="bi bi-box-arrow-right"></i> Выйти
                        </a>
                    </div>
                </div>
            </nav>
            
            <!-- Main content -->
            <main class="col-md-10 ms-sm-auto col-lg-10 px-md-4">
                <div class="pt-3 pb-2 mb-3">

