<?php
$page_title = 'Клиенты';
require_once __DIR__ . '/includes/header.php';

$db = getDatabase();

// Получаем список клиентов с их виджетами
$clients = $db->query("
    SELECT 
        cu.*,
        COUNT(w.id) as widgets_count,
        GROUP_CONCAT(w.name SEPARATOR ', ') as widget_names
    FROM client_users cu
    LEFT JOIN widgets w ON w.client_id = cu.id
    GROUP BY cu.id
    ORDER BY cu.created_at DESC
")->fetchAll();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-people"></i> Клиенты
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#createClientModal">
            <i class="bi bi-plus-circle"></i> Создать клиента
        </button>
    </div>
</div>

<!-- Список клиентов -->
<div class="card">
    <div class="card-body">
        <?php if (empty($clients)): ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; opacity: 0.3;"></i>
                <p class="mt-3 text-muted">Клиенты еще не созданы</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Логин</th>
                            <th>Имя</th>
                            <th>Email</th>
                            <th>Телефон</th>
                            <th>Лимит запросов</th>
                            <th>Виджетов</th>
                            <th>Статус</th>
                            <th>Последний вход</th>
                            <th>Создан</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($clients as $client): ?>
                            <tr>
                                <td><?php echo $client['id']; ?></td>
                                <td><strong><?php echo htmlspecialchars($client['username']); ?></strong></td>
                                <td><?php echo htmlspecialchars($client['full_name'] ?: '—'); ?></td>
                                <td><?php echo htmlspecialchars($client['email'] ?: '—'); ?></td>
                                <td><?php echo htmlspecialchars($client['phone'] ?: '—'); ?></td>
                                <td>
                                    <span class="badge bg-info"><?php echo number_format($client['request_limit'] ?? 20000); ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?php echo $client['widgets_count']; ?></span>
                                    <?php if ($client['widget_names']): ?>
                                        <small class="text-muted d-block"><?php echo htmlspecialchars(mb_substr($client['widget_names'], 0, 50)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($client['is_active']): ?>
                                        <span class="badge bg-success">Активен</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Неактивен</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($client['last_login']): ?>
                                        <small><?php echo date('d.m.Y H:i', strtotime($client['last_login'])); ?></small>
                                    <?php else: ?>
                                        <small class="text-muted">Никогда</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small><?php echo date('d.m.Y', strtotime($client['created_at'])); ?></small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="editClient(<?php echo $client['id']; ?>)" title="Редактировать">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-outline-warning" onclick="toggleClientStatus(<?php echo $client['id']; ?>, <?php echo $client['is_active'] ? 0 : 1; ?>)" title="<?php echo $client['is_active'] ? 'Деактивировать' : 'Активировать'; ?>">
                                            <i class="bi bi-<?php echo $client['is_active'] ? 'x-circle' : 'check-circle'; ?>"></i>
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="deleteClient(<?php echo $client['id']; ?>)" title="Удалить">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Модальное окно создания клиента -->
<div class="modal fade" id="createClientModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Создать клиента</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="createClientForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="username" class="form-label">Логин *</label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Пароль *</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                        <small class="text-muted">Минимум 6 символов</small>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    <div class="mb-3">
                        <label for="full_name" class="form-label">Полное имя</label>
                        <input type="text" class="form-control" id="full_name" name="full_name">
                    </div>
                    <div class="mb-3">
                        <label for="phone" class="form-label">Телефон</label>
                        <input type="text" class="form-control" id="phone" name="phone">
                    </div>
                    <div class="mb-3">
                        <label for="request_limit" class="form-label">Лимит запросов</label>
                        <input type="number" class="form-control" id="request_limit" name="request_limit" value="20000" min="0">
                        <small class="text-muted">Максимальное количество запросов для клиента</small>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                            <label class="form-check-label" for="is_active">
                                Активен
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                    <button type="submit" class="btn btn-primary">Создать</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Модальное окно редактирования клиента -->
<div class="modal fade" id="editClientModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Редактировать клиента</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editClientForm">
                <input type="hidden" id="edit_client_id" name="client_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_username" class="form-label">Логин *</label>
                        <input type="text" class="form-control" id="edit_username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_password" class="form-label">Новый пароль</label>
                        <input type="password" class="form-control" id="edit_password" name="password">
                        <small class="text-muted">Оставьте пустым, если не хотите менять пароль</small>
                    </div>
                    <div class="mb-3">
                        <label for="edit_email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="edit_email" name="email">
                    </div>
                    <div class="mb-3">
                        <label for="edit_full_name" class="form-label">Полное имя</label>
                        <input type="text" class="form-control" id="edit_full_name" name="full_name">
                    </div>
                    <div class="mb-3">
                        <label for="edit_phone" class="form-label">Телефон</label>
                        <input type="text" class="form-control" id="edit_phone" name="phone">
                    </div>
                    <div class="mb-3">
                        <label for="edit_request_limit" class="form-label">Лимит запросов</label>
                        <input type="number" class="form-control" id="edit_request_limit" name="request_limit" min="0">
                        <small class="text-muted">Максимальное количество запросов для клиента</small>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="edit_is_active" name="is_active">
                            <label class="form-check-label" for="edit_is_active">
                                Активен
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
                    <button type="submit" class="btn btn-primary">Сохранить</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Создание клиента
document.getElementById('createClientForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    data.is_active = document.getElementById('is_active').checked ? 1 : 0;
    
    fetch('/admin/ajax/create-client.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(data)
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showAlert('Клиент создан', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
});

// Редактирование клиента
function editClient(clientId) {
    fetch(`/admin/ajax/get-client.php?id=${clientId}`)
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const client = data.client;
                document.getElementById('edit_client_id').value = client.id;
                document.getElementById('edit_username').value = client.username;
                document.getElementById('edit_email').value = client.email || '';
                document.getElementById('edit_full_name').value = client.full_name || '';
                document.getElementById('edit_phone').value = client.phone || '';
                document.getElementById('edit_request_limit').value = client.request_limit || 20000;
                document.getElementById('edit_is_active').checked = client.is_active == 1;
                
                const modal = new bootstrap.Modal(document.getElementById('editClientModal'));
                modal.show();
            } else {
                showAlert('Ошибка: ' + data.error, 'danger');
            }
        });
}

document.getElementById('editClientForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    data.is_active = document.getElementById('edit_is_active').checked ? 1 : 0;
    
    fetch('/admin/ajax/update-client.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(data)
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showAlert('Клиент обновлен', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
});

// Изменение статуса клиента
function toggleClientStatus(clientId, newStatus) {
    fetch('/admin/ajax/toggle-client-status.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ client_id: clientId, is_active: newStatus })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showAlert('Статус изменен', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
}

// Удаление клиента
function deleteClient(clientId) {
    if (!confirm('Вы уверены, что хотите удалить этого клиента? Все связанные виджеты будут отвязаны.')) {
        return;
    }
    
    fetch('/admin/ajax/delete-client.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ client_id: clientId })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showAlert('Клиент удален', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

