<?php
/**
 * AJAX: Назначение раздела для URL
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $urlId = $_POST['url_id'] ?? null;
    $section = $_POST['section'] ?? null;
    
    if (!$urlId) {
        throw new Exception('URL ID is required');
    }
    
    $db = getDatabase();
    
    // Проверяем что URL существует
    $stmt = $db->prepare("SELECT * FROM discovered_urls WHERE id = ?");
    $stmt->execute([$urlId]);
    $url = $stmt->fetch();
    
    if (!$url) {
        throw new Exception('URL not found');
    }
    
    // Обновляем раздел
    $status = ($section && $section !== 'excluded') ? 'assigned' : 'new';
    
    $stmt = $db->prepare("
        UPDATE discovered_urls 
        SET assigned_section = ?, status = ?
        WHERE id = ?
    ");
    
    $stmt->execute([
        $section ?: null,
        $status,
        $urlId
    ]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Section assigned successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

