<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$job_id = $_GET['job_id'] ?? 0;

if (!$job_id) {
    echo json_encode(['success' => false, 'error' => 'Job ID не указан']);
    exit;
}

try {
    $db = getDatabase();
    $stmt = $db->prepare("SELECT * FROM parsing_jobs WHERE id = ?");
    $stmt->execute([$job_id]);
    $job = $stmt->fetch();
    
    if (!$job) {
        echo json_encode(['success' => false, 'error' => 'Задание не найдено']);
        exit;
    }
    
    $errors = json_decode($job['errors_json'], true) ?: [];
    
    echo json_encode([
        'success' => true,
        'status' => $job['status'],
        'total' => (int)$job['total_pages'],
        'processed' => (int)$job['processed_pages'],
        'errors' => $errors
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

