<?php
/**
 * AJAX: Найти позицию элемента в пагинации
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $section_id = $_GET['section_id'] ?? 0;
    $item_id = $_GET['item_id'] ?? 0;
    
    if (!$section_id || !$item_id) {
        throw new Exception('section_id and item_id are required');
    }
    
    $db = getDatabase();
    
    // Получаем раздел
    $stmt = $db->prepare("
        SELECT ws.*, w.id as widget_id
        FROM widget_sections ws
        JOIN widgets w ON ws.widget_id = w.id
        WHERE ws.id = ?
    ");
    $stmt->execute([$section_id]);
    $section = $stmt->fetch();
    
    if (!$section) {
        throw new Exception('Section not found');
    }
    
    // Проверяем существует ли элемент в этой секции
    $stmt = $db->prepare("
        SELECT id FROM parsed_items 
        WHERE id = ? AND widget_id = ? AND section_name = ? AND is_duplicate = 0
    ");
    $stmt->execute([$item_id, $section['widget_id'], $section['section_name']]);
    $item = $stmt->fetch();
    
    if (!$item) {
        echo json_encode([
            'found' => false,
            'error' => "Элемент с ID $item_id не найден в секции {$section['section_name']}"
        ]);
        exit;
    }
    
    // Определяем позицию элемента через подсчет с правильной сортировкой
    // Считаем сколько элементов создано ПОЗЖЕ текущего (больше created_at или равно но больше ID)
    $stmt = $db->prepare("
        SELECT 
            (SELECT COUNT(*) + 1
             FROM parsed_items pi2
             WHERE pi2.widget_id = ?
             AND pi2.section_name = ?
             AND pi2.is_duplicate = 0
             AND (
                 pi2.created_at > pi1.created_at 
                 OR (pi2.created_at = pi1.created_at AND pi2.id > pi1.id)
             )
            ) as position
        FROM parsed_items pi1
        WHERE pi1.id = ?
    ");
    $stmt->execute([$section['widget_id'], $section['section_name'], $item_id]);
    $position = $stmt->fetchColumn();
    
    if (!$position) {
        throw new Exception("Could not determine position for item $item_id");
    }
    
    // Вычисляем номер страницы (50 элементов на страницу)
    $per_page = 50;
    $page = ceil($position / $per_page);
    
    echo json_encode([
        'found' => true,
        'page' => $page,
        'position' => $position,
        'item_id' => (int)$item_id
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

