<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$widget_id = $input['widget_id'] ?? 0;

if (!$widget_id) {
    echo json_encode(['success' => false, 'error' => 'Widget ID не указан']);
    exit;
}

try {
    $db = getDatabase();
    
    // Удаляем виджет (CASCADE удалит все связанные данные)
    $stmt = $db->prepare("DELETE FROM widgets WHERE id = ?");
    $stmt->execute([$widget_id]);
    
    logInfo("Widget deleted: ID $widget_id");
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    logError("Widget deletion error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

