<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$item_ids = $input['item_ids'] ?? [];

if (empty($item_ids)) {
    echo json_encode(['success' => false, 'error' => 'Не выбраны элементы для удаления']);
    exit;
}

try {
    $db = getDatabase();
    
    // Удаляем элементы (CASCADE удалит parsed_fields)
    $placeholders = str_repeat('?,', count($item_ids) - 1) . '?';
    $stmt = $db->prepare("DELETE FROM parsed_items WHERE id IN ($placeholders)");
    $stmt->execute($item_ids);
    
    echo json_encode(['success' => true, 'deleted' => $stmt->rowCount()]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

