<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$item_ids_to_keep = $input['item_ids_to_keep'] ?? [];

if (empty($item_ids_to_keep) || !is_array($item_ids_to_keep)) {
    echo json_encode(['success' => false, 'error' => 'Некорректные данные']);
    exit;
}

try {
    $db = getDatabase();
    
    // Если передано менее 2 элементов, нечего удалять
    if (count($item_ids_to_keep) < 2) {
        echo json_encode(['success' => true, 'deleted_count' => 0, 'message' => 'Нет дубликатов для удаления']);
        exit;
    }
    
    // Первый элемент оставляем, остальные удаляем
    $item_id_to_keep = $item_ids_to_keep[0];
    $item_ids_to_delete = array_slice($item_ids_to_keep, 1);
    
    // Удаляем элементы (CASCADE удалит parsed_fields)
    $placeholders = str_repeat('?,', count($item_ids_to_delete) - 1) . '?';
    $stmt = $db->prepare("DELETE FROM parsed_items WHERE id IN ($placeholders)");
    $stmt->execute($item_ids_to_delete);
    
    $deleted_count = $stmt->rowCount();
    
    echo json_encode([
        'success' => true,
        'deleted_count' => $deleted_count,
        'kept_id' => $item_id_to_keep
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
