<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не разрешен']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$username = trim($data['username'] ?? '');
$password = $data['password'] ?? '';
$email = trim($data['email'] ?? '');
$full_name = trim($data['full_name'] ?? '');
$phone = trim($data['phone'] ?? '');
$request_limit = isset($data['request_limit']) ? (int)$data['request_limit'] : 20000;
$is_active = isset($data['is_active']) ? (int)$data['is_active'] : 1;

if (empty($username) || empty($password)) {
    echo json_encode(['success' => false, 'error' => 'Логин и пароль обязательны']);
    exit;
}

if (strlen($password) < 6) {
    echo json_encode(['success' => false, 'error' => 'Пароль должен быть не менее 6 символов']);
    exit;
}

try {
    $db = getDatabase();
    
    // Проверяем, не существует ли уже такой логин
    $stmt = $db->prepare("SELECT id FROM client_users WHERE username = ?");
    $stmt->execute([$username]);
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'error' => 'Клиент с таким логином уже существует']);
        exit;
    }
    
    // Создаем клиента
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $db->prepare("
        INSERT INTO client_users (username, password_hash, email, full_name, phone, request_limit, is_active)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->execute([$username, $password_hash, $email ?: null, $full_name ?: null, $phone ?: null, $request_limit, $is_active]);
    
    echo json_encode(['success' => true, 'client_id' => $db->lastInsertId()]);
} catch (Exception $e) {
    logError("Create client error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Ошибка создания клиента']);
}

