<?php
/**
 * AJAX: Запуск краулинга
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $widgetId = $_POST['widget_id'] ?? null;
    $clearExisting = isset($_POST['clear_existing']) && $_POST['clear_existing'] === 'true';
    
    if (!$widgetId) {
        throw new Exception('Widget ID is required');
    }
    
    $db = getDatabase();
    
    // Получаем виджет
    $stmt = $db->prepare("SELECT * FROM widgets WHERE id = ?");
    $stmt->execute([$widgetId]);
    $widget = $stmt->fetch();
    
    if (!$widget) {
        throw new Exception('Widget not found');
    }
    
    // Получаем настройки
    $stmt = $db->prepare("SELECT * FROM widget_settings WHERE widget_id = ?");
    $stmt->execute([$widgetId]);
    $settings = $stmt->fetch();
    
    if (!$settings) {
        throw new Exception('Widget settings not found');
    }
    
    // Проверяем что краулинг включен
    if (!$settings['crawler_enabled']) {
        throw new Exception('Crawler is not enabled for this widget');
    }
    
    // Формируем start_url
    $startUrl = $widget['site_domain'];
    if (strpos($startUrl, 'http') !== 0) {
        $startUrl = 'https://' . $startUrl;
    }
    
    // Создаем задание краулинга
    $stmt = $db->prepare("
        INSERT INTO crawler_jobs 
        (widget_id, start_url, max_depth, max_urls, timeout_seconds, status)
        VALUES (?, ?, ?, ?, ?, 'running')
    ");
    
    $stmt->execute([
        $widgetId,
        $startUrl,
        $settings['crawler_max_depth'],
        $settings['crawler_max_urls'],
        $settings['crawler_timeout']
    ]);
    
    $jobId = $db->lastInsertId();
    
    // Запускаем краулер в фоне
    $phpBin = '/usr/bin/php';
    $scriptPath = __DIR__ . '/../../parser/run-crawler.php';
    $clearFlag = $clearExisting ? '1' : '0';
    $logFile = __DIR__ . '/../../logs/crawler.log';
    
    $command = sprintf(
        '%s %s %d %s >> %s 2>&1 &',
        escapeshellcmd($phpBin),
        escapeshellarg($scriptPath),
        $jobId,
        $clearFlag,
        escapeshellarg($logFile)
    );
    
    exec($command);
    
    echo json_encode([
        'success' => true,
        'job_id' => $jobId,
        'message' => 'Crawler started successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

