<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

function formatBytes($size, $precision = 2) {
    if ($size == 0) return '0 B';
    $base = log($size, 1024);
    $suffixes = array('B', 'KB', 'MB', 'GB', 'TB');
    return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
}

try {
    $backup_dir = WIDGET_ROOT . '/backups';
    $log_file = LOG_DIR . '/backup.log';
    
    // Получаем список локальных бэкапов
    $local_backups = [];
    if (is_dir($backup_dir)) {
        $files = glob($backup_dir . '/ai-widget-backup-*-full.tar.gz');
        foreach ($files as $file) {
            $local_backups[] = [
                'filename' => basename($file),
                'size' => filesize($file),
                'size_human' => formatBytes(filesize($file)),
                'created' => date('Y-m-d H:i:s', filemtime($file)),
                'path' => $file
            ];
        }
        // Сортируем по дате создания (новые первыми)
        usort($local_backups, function($a, $b) {
            return strcmp($b['created'], $a['created']);
        });
    }
    
    // Получаем последние строки лога
    $log_content = '';
    if (file_exists($log_file)) {
        $log_lines = file($log_file);
        $log_content = implode('', array_slice($log_lines, -50)); // Последние 50 строк
    }
    
    // Проверяем, запущен ли процесс бэкапа
    $is_running = false;
    exec("pgrep -f 'daily_backup.sh'", $pids);
    if (!empty($pids)) {
        $is_running = true;
    }
    
    echo json_encode([
        'success' => true,
        'local_backups' => $local_backups,
        'log_content' => $log_content,
        'is_running' => $is_running,
        'backup_dir' => $backup_dir
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
