<?php

// AI Widget Configuration
define('WIDGET_ROOT', __DIR__);

// Домен
define('WIDGET_DOMAIN', 'https://wtest.medmaps.ru');

// Конфигурация базы данных
define('DB_HOST', 'localhost');
define('DB_NAME', 'ai_widget');
define('DB_USER', 'telegram_bot');
define('DB_PASS', 'bot_password_2025');
define('DB_CHARSET', 'utf8mb4');

// Конфигурация Claude API (резервный вариант)
define('CLAUDE_API_KEY', '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');
define('CLAUDE_API_URL', 'https://api.anthropic.com/v1/messages');
define('CLAUDE_MODEL', 'claude-haiku-4-5-20251001');
define('CLAUDE_MAX_RETRIES', 3); // Количество попыток при ошибках
define('CLAUDE_RETRY_DELAYS', [2, 4, 8]); // Задержки между попытками в секундах
define('CLAUDE_CACHE_TTL', '1h'); // TTL для prompt caching: '5m' или '1h'

// Конфигурация OpenRouter API (основной провайдер)
define('OPENROUTER_API_KEY', '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');
define('OPENROUTER_API_URL', 'https://openrouter.ai/api/v1/chat/completions');
define('OPENROUTER_MODEL', 'qwen/qwen3-235b-a22b-2507'); // Модель с указанием провайдера
define('OPENROUTER_MAX_RETRIES', 3); // Количество попыток при ошибках
define('OPENROUTER_RETRY_DELAYS', [2, 4, 8]); // Задержки между попытками в секундах
define('USE_OPENROUTER_FIRST', true); // Использовать OpenRouter как основной провайдер

// Прокси для OpenRouter (HTTPS)
define('OPENROUTER_PROXY_ENABLED', true);
define('OPENROUTER_PROXY_HOST', '45.145.57.235');
define('OPENROUTER_PROXY_PORT', '10926');
define('OPENROUTER_PROXY_USER', 'MCRC7V');
define('OPENROUTER_PROXY_PASS', '6xZ3LV');

// Конфигурация локального GPU сервера (для LLM запросов в runtime)
define('GPU_LLM_ENABLED', true); // Включить использование GPU для LLM
define('GPU_LLM_API_URL', 'http://87.228.124.163:8000/v1/chat/completions');
define('GPU_LLM_MODEL', 'Qwen/Qwen2.5-7B-Instruct'); // Модель на GPU сервере
// Большие промпты + torch.compile на GPU могут занимать несколько минут.
define('GPU_LLM_TIMEOUT', 600); // Таймаут для GPU запросов (секунды)
define('GPU_LLM_MAX_RETRIES', 3); // Количество попыток при ошибках
define('GPU_LLM_RETRY_DELAYS', [2, 4, 8]); // Задержки между попытками в секундах

// Конфигурация Embedding API (GPU Server)
define('EMBEDDING_MODEL', 'intfloat/multilingual-e5-large'); // Модель для создания embedding векторов
define('EMBEDDING_API_URL', 'http://87.228.124.163:8001/embed'); // URL GPU embedding сервера
define('USE_EMBEDDING_SEARCH', true); // Embedding через GPU
define('EMBEDDING_SEARCH_LIMIT', 20); // Количество результатов при embedding поиске

// Конфигурация Gemini API через OpenRouter (для категоризации)
define('GEMINI_MODEL', 'google/gemini-2.5-flash-lite'); // Модель для категоризации услуг
define('GEMINI_API_URL', 'https://openrouter.ai/api/v1/chat/completions'); // Используем OpenRouter
define('GEMINI_MAX_RETRIES', 3); // Количество попыток при ошибках
define('GEMINI_RETRY_DELAYS', [2, 4, 8]); // Задержки между попытками в секундах
// Gemini API использует тот же прокси, что и OpenRouter (OPENROUTER_PROXY_*)

// Конфигурация Yandex GPT API (для Stage 1, по умолчанию отключено)
define('YANDEXGPT_API_URL', 'https://llm.api.cloud.yandex.net/foundationModels/v1/completion');
define('YANDEXGPT_API_KEY', 'AQVNyLNY29KlsKhI8LKwe5HKMEl4Bqayj8I9I8fC'); // Секретный ключ API
define('YANDEXGPT_FOLDER_ID', 'b1gqogohv4tgsmbj9gb4'); // Folder ID из модели gpt://b1gqogohv4tgsmbj9gb4/yandexgpt-lite/latest
define('YANDEXGPT_MAX_RETRIES', 3); // Количество попыток при ошибках
define('YANDEXGPT_RETRY_DELAYS', [2, 4, 8]); // Задержки между попытками в секундах
define('USE_YANDEXGPT_FIRST', false); // Использовать Yandex GPT как основной провайдер для всех этапов (по умолчанию выключено)
define('YANDEXGPT_TIMEOUT', 30); // Таймаут для Yandex GPT API в секундах

// Конфигурация GigaChat API
define('GIGACHAT_AUTH_KEY', 'MDE5YTgxYmItM2YwMi03ODQ2LThhZWItMTI3OTFiYjM3MjE5OjBkYTIwNGI1LTg3ODktNDRhNS05NDk2LTdiNjEzMDEwYWU5NA=='); // Authorization key
define('GIGACHAT_CLIENT_ID', '019a81bb-3f02-7846-8aeb-12791bb37219'); // Client ID
define('GIGACHAT_MODEL', 'GigaChat-2'); // Модель
define('GIGACHAT_OAUTH_URL', 'https://ngw.devices.sberbank.ru:9443/api/v2/oauth'); // URL для получения токена
define('GIGACHAT_API_URL', 'https://gigachat.devices.sberbank.ru/api/v1/chat/completions'); // URL API
define('GIGACHAT_SCOPE', 'GIGACHAT_API_PERS'); // Scope для токена
define('GIGACHAT_TOKEN_CACHE_TIME', 1800); // Время кэширования токена в секундах (30 минут)

// Настройки для токенов
define('MAX_TOKENS_RESPONSE', 800); // Уменьшено для ускорения генерации (Фаза 1 оптимизации)

/**
 * Нормализует название модели в формат OpenRouter
 * Преобразует человекочитаемое название в формат API
 * Например: "Qwen: Qwen3 235B A22B Instruct 2507" -> "qwen/qwen3-235b-a22b-2507"
 */
function normalizeModelName($model) {
    if (empty($model)) {
        return null;
    }
    
    // Если модель уже в формате API (содержит /), возвращаем как есть
    if (strpos($model, '/') !== false || strpos($model, 'gpt://') === 0) {
        return $model;
    }
    
    // Преобразуем "Qwen: Qwen3 235B A22B Instruct 2507" -> "qwen/qwen3-235b-a22b-2507"
    if (preg_match('/Qwen.*?Qwen3\s+235B\s+A22B\s+Instruct\s+2507/i', $model)) {
        return 'qwen/qwen3-235b-a22b-2507';
    }
    
    // Преобразуем "Qwen: Qwen2.5 14B Instruct" -> "qwen/qwen2.5-14b-instruct"
    if (preg_match('/Qwen.*?Qwen2\.5\s+14B\s+Instruct/i', $model)) {
        return 'qwen/qwen2.5-14b-instruct';
    }
    
    // Преобразуем "Qwen: Qwen2.5 7B Instruct" -> "qwen/qwen2.5-7b-instruct"
    if (preg_match('/Qwen.*?Qwen2\.5\s+7B\s+Instruct/i', $model)) {
        return 'qwen/qwen2.5-7b-instruct';
    }
    
    // Если не распознано, возвращаем как есть (может быть уже в правильном формате)
    return $model;
}

// Таймауты
define('PARSER_TIMEOUT', 10); // Таймаут загрузки страницы в секундах
define('CLAUDE_TIMEOUT', 30); // Таймаут запроса к Claude в секундах

// Rate limiting
define('RATE_LIMIT_REQUESTS', 60); // Максимум запросов
define('RATE_LIMIT_PERIOD', 60); // За период в секундах

// Пути
define('PARSER_CONFIG_DIR', WIDGET_ROOT . '/parser/configs');
define('LOG_DIR', WIDGET_ROOT . '/logs');
define('PARSER_LOG', LOG_DIR . '/parser.log');
define('WIDGET_LOG', LOG_DIR . '/widget.log');
define('STAGE1_PROCESS_LOG', LOG_DIR . '/stage1-process.log'); // Лог процесса обработки Stage1

// Функция для подключения к БД
function getDatabase() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
            $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
        } catch (PDOException $e) {
            logError("Database connection failed: " . $e->getMessage());
            throw $e;
        }
    }
    
    return $pdo;
}

// Функция для логирования
function logMessage($message, $logFile = WIDGET_LOG) {
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] $message\n";
    
    // Создаем директорию если не существует
    $logDir = dirname($logFile);
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    // Проверяем права на запись
    if (!is_writable($logDir)) {
        error_log("LOG ERROR: Directory $logDir is not writable");
        return false;
    }
    
    $result = @file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
    if ($result === false) {
        error_log("LOG ERROR: Failed to write to $logFile. Check permissions.");
        // Пытаемся записать в системный лог PHP
        error_log("LOG MESSAGE: $message");
    }
    return $result !== false;
}

function logError($message, $logFile = WIDGET_LOG) {
    logMessage("ERROR: $message", $logFile);
}

function logInfo($message, $logFile = WIDGET_LOG) {
    logMessage("INFO: $message", $logFile);
}

function logParser($message) {
    logMessage($message, PARSER_LOG);
}

/**
 * Логирование процесса обработки Stage1 в отдельный файл
 * Структурированное логирование с разделителями для удобного чтения
 */
function logStage1Process($section, $data = []) {
    $timestamp = date('Y-m-d H:i:s');
    $logFile = STAGE1_PROCESS_LOG;
    
    // Создаем директорию если не существует
    $logDir = dirname($logFile);
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $logEntry = "\n" . str_repeat('=', 80) . "\n";
    $logEntry .= "[$timestamp] === $section ===\n";
    $logEntry .= str_repeat('-', 80) . "\n";
    
    // Форматируем данные
    foreach ($data as $key => $value) {
        if (is_array($value)) {
            $logEntry .= "$key:\n";
            foreach ($value as $subKey => $subValue) {
                $logEntry .= "  $subKey: " . (is_string($subValue) ? $subValue : json_encode($subValue, JSON_UNESCAPED_UNICODE)) . "\n";
            }
        } else {
            $logEntry .= "$key: " . (is_string($value) ? $value : json_encode($value, JSON_UNESCAPED_UNICODE)) . "\n";
        }
    }
    
    $logEntry .= str_repeat('=', 80) . "\n";
    
    @file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
}

// Функция для оценки количества токенов
function estimateTokens($text) {
    // Приблизительная оценка: 1 токен ≈ 4 символа для русского текста
    return (int)ceil(mb_strlen($text) / 4);
}

// Функция для получения IP адреса
function getClientIP() {
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $ip = trim($ips[0]);
    } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }
    
    return $ip;
}

// Функция для получения User Agent
function getUserAgent() {
    return $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
}

// Функция для очистки HTML с сохранением безопасных тегов
function cleanHTML($text) {
    // Разрешаем только безопасные теги
    $allowedTags = '<b><i><br>';
    $cleaned = strip_tags($text, $allowedTags);
    
    // Удаляем лишние пробелы
    $cleaned = preg_replace('/\s+/', ' ', $cleaned);
    $cleaned = trim($cleaned);
    
    return $cleaned;
}

// Функция для генерации slug
function generateSlug($text) {
    // Транслитерация русских букв
    $transliteration = [
        'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd',
        'е' => 'e', 'ё' => 'yo', 'ж' => 'zh', 'з' => 'z', 'и' => 'i',
        'й' => 'y', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n',
        'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't',
        'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'ts', 'ч' => 'ch',
        'ш' => 'sh', 'щ' => 'sch', 'ъ' => '', 'ы' => 'y', 'ь' => '',
        'э' => 'e', 'ю' => 'yu', 'я' => 'ya',
    ];
    
    $text = mb_strtolower($text, 'UTF-8');
    $text = strtr($text, $transliteration);
    $text = preg_replace('/[^a-z0-9\s-]/', '', $text);
    $text = preg_replace('/\s+/', '-', $text);
    $text = trim($text, '-');
    
    return $text;
}

// Функция для конвертации относительных URL в абсолютные
function makeAbsoluteUrl($url, $baseUrl) {
    if (empty($url)) {
        return $url;
    }
    
    // Уже абсолютный URL
    if (preg_match('/^https?:\/\//i', $url)) {
        return $url;
    }
    
    $parsedBase = parse_url($baseUrl);
    $scheme = $parsedBase['scheme'] ?? 'https';
    $host = $parsedBase['host'] ?? '';
    
    // Относительный URL от корня
    if ($url[0] === '/') {
        return $scheme . '://' . $host . $url;
    }
    
    // Относительный URL от текущей страницы
    $basePath = dirname($parsedBase['path'] ?? '/');
    return $scheme . '://' . $host . $basePath . '/' . $url;
}

// Функция для проверки CORS
function checkCORS($widgetKey, $origin) {
    $db = getDatabase();
    $stmt = $db->prepare("
        SELECT ws.allowed_domains 
        FROM widgets w
        JOIN widget_settings ws ON w.id = ws.widget_id
        WHERE w.widget_key = ?
    ");
    $stmt->execute([$widgetKey]);
    $settings = $stmt->fetch();
    
    if (!$settings) {
        return false;
    }
    
    $allowedDomains = json_decode($settings['allowed_domains'], true);
    
    if (empty($allowedDomains)) {
        return false;
    }
    
    // Проверяем origin в списке разрешенных доменов
    return in_array($origin, $allowedDomains);
}

/**
 * Настраивает curl для использования прокси OpenRouter (если включено)
 * @param resource $ch curl handle
 */
function configureOpenRouterProxy($ch) {
    if (defined('OPENROUTER_PROXY_ENABLED') && OPENROUTER_PROXY_ENABLED) {
        $proxyUrl = OPENROUTER_PROXY_HOST . ':' . OPENROUTER_PROXY_PORT;
        curl_setopt($ch, CURLOPT_PROXY, $proxyUrl);
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, OPENROUTER_PROXY_USER . ':' . OPENROUTER_PROXY_PASS);
        curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP); // Для HTTPS прокси используется HTTP тип
        curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1); // Туннелирование для HTTPS
    }
}

/**
 * Извлекает JSON из markdown code block (```json ... ```)
 * GPU модели часто возвращают JSON в таком формате
 */
function extractJSONFromMarkdown($text) {
    // Убираем markdown code blocks: ```json ... ``` или ``` ... ```
    $text = trim($text);
    
    // Паттерн для markdown code block
    if (preg_match('/^```(?:json)?\\s*\\n(.*)\\n```$/s', $text, $matches)) {
        return trim($matches[1]);
    }
    
    // Если нет markdown, возвращаем как есть
    return $text;
}

