<?php
/**
 * API endpoint для тестирования кастомного API
 * POST /api/custom-api-test.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }

    $apiUrl = $input['api_url'] ?? '';
    $apiKey = $input['api_key'] ?? '';
    $requestData = $input['request_data'] ?? [];

    if (empty($apiUrl)) {
        throw new Exception('API URL is required');
    }

    if (empty($requestData)) {
        throw new Exception('Request data is required');
    }

    // Формируем заголовки
    $headers = [
        'Content-Type: application/json'
    ];

    if (!empty($apiKey)) {
        // Если ключ начинается с "Bearer ", используем как есть, иначе добавляем
        if (strpos($apiKey, 'Bearer ') === 0) {
            $headers[] = 'Authorization: ' . $apiKey;
        } else {
            $headers[] = 'Authorization: Bearer ' . $apiKey;
        }
    }

    // Опциональные заголовки
    $headers[] = 'HTTP-Referer: https://w.medmaps.ru';
    $headers[] = 'X-Title: AI Widget';

    // Отправляем запрос к кастомному API
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
    curl_setopt($ch, CURLOPT_TIMEOUT, 60); // Таймаут 60 секунд
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        throw new Exception('cURL error: ' . $curlError);
    }

    // Парсим ответ
    $responseData = json_decode($response, true);
    
    if ($httpCode !== 200) {
        throw new Exception("API returned HTTP $httpCode: " . substr($response, 0, 500));
    }

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON response: ' . json_last_error_msg());
    }

    // Извлекаем текст ответа из формата OpenAI
    $responseText = null;
    if (isset($responseData['choices'][0]['message']['content'])) {
        $responseText = trim($responseData['choices'][0]['message']['content']);
    } elseif (isset($responseData['content'])) {
        $responseText = trim($responseData['content']);
    } elseif (isset($responseData['text'])) {
        $responseText = trim($responseData['text']);
    } elseif (isset($responseData['response'])) {
        $responseText = trim($responseData['response']);
    }

    // Извлекаем статистику токенов
    $tokens = null;
    if (isset($responseData['usage'])) {
        $tokens = $responseData['usage'];
    } elseif (isset($responseData['tokens'])) {
        $tokens = $responseData['tokens'];
    }

    // Формируем успешный ответ
    echo json_encode([
        'success' => true,
        'http_status' => $httpCode,
        'api_response' => $responseData,
        'response_text' => $responseText,
        'tokens' => $tokens,
        'full_response' => $response
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

