#!/bin/bash

# Скрипт загрузки бэкапа на SFTP и ротации (хранение последних 100)
# Использование: ./upload_to_ftp.sh <путь_к_файлу_бэкапа>

set -e

# Конфигурация SFTP
SFTP_HOST="u68159.storage.na4u.ru"
SFTP_USER="u68159"
SFTP_PASS="Tn9OJ4OWBj1EU99"
SFTP_DIR="виджет тест"
MAX_BACKUPS=100

# Проверяем аргумент
if [ -z "$1" ]; then
    echo "ОШИБКА: Укажите путь к файлу бэкапа!"
    echo "Использование: $0 <путь_к_файлу_бэкапа>"
    exit 1
fi

BACKUP_FILE="$1"

if [ ! -f "${BACKUP_FILE}" ]; then
    echo "ОШИБКА: Файл бэкапа не найден: ${BACKUP_FILE}"
    exit 1
fi

BACKUP_FILENAME=$(basename "${BACKUP_FILE}")

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Начало загрузки на SFTP..."

# Проверяем наличие sshpass для автоматической передачи пароля
if ! command -v sshpass &> /dev/null; then
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Установка sshpass для автоматической передачи пароля..."
    apt-get update -qq && apt-get install -y sshpass > /dev/null 2>&1 || {
        echo "[$(date '+%Y-%m-%d %H:%M:%S')] ОШИБКА: Не удалось установить sshpass. Установите вручную: apt-get install sshpass"
        exit 1
    }
fi

# Создаем временный скрипт для SFTP команд
SFTP_SCRIPT=$(mktemp)
cat > "${SFTP_SCRIPT}" << EOF
mkdir "${SFTP_DIR}" 2>/dev/null || true
cd "${SFTP_DIR}"
put "${BACKUP_FILE}" "${BACKUP_FILENAME}"
quit
EOF

# Загружаем файл на SFTP
echo "[$(date '+%Y-%m-%d %H:%M:%S')] Создание директории '${SFTP_DIR}' (если не существует)..."
echo "[$(date '+%Y-%m-%d %H:%M:%S')] Загрузка файла ${BACKUP_FILENAME}..."

# Используем sshpass для автоматической передачи пароля
SFTP_OUTPUT=$(sshpass -p "${SFTP_PASS}" sftp -o StrictHostKeyChecking=no -o BatchMode=no "${SFTP_USER}@${SFTP_HOST}" < "${SFTP_SCRIPT}" 2>&1)
SFTP_EXIT_CODE=$?

# Проверяем наличие ошибок
if [ ${SFTP_EXIT_CODE} -ne 0 ] || echo "${SFTP_OUTPUT}" | grep -qi "error\|failed\|permission denied\|connection refused"; then
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] ОШИБКА при загрузке на SFTP:"
    echo "${SFTP_OUTPUT}" | grep -i "error\|failed\|permission\|connection\|refused" || echo "${SFTP_OUTPUT}"
    rm -f "${SFTP_SCRIPT}"
    exit 1
fi

if [ ${SFTP_EXIT_CODE} -eq 0 ]; then
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Файл успешно загружен на SFTP"
else
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] ПРЕДУПРЕЖДЕНИЕ: Неопределенный статус загрузки, проверьте вручную"
    echo "${SFTP_OUTPUT}"
fi

rm -f "${SFTP_SCRIPT}"

# Ротация: удаляем старые бэкапы, оставляем только последние MAX_BACKUPS
echo "[$(date '+%Y-%m-%d %H:%M:%S')] Проверка ротации бэкапов (максимум ${MAX_BACKUPS})..."

# Используем SFTP для получения списка и удаления
TEMP_LIST=$(mktemp)

# Создаем скрипт для получения списка файлов
SFTP_LIST_SCRIPT=$(mktemp)
cat > "${SFTP_LIST_SCRIPT}" << EOF
cd "${SFTP_DIR}"
ls -1
quit
EOF

# Получаем список файлов с SFTP
sshpass -p "${SFTP_PASS}" sftp -o StrictHostKeyChecking=no -o BatchMode=no "${SFTP_USER}@${SFTP_HOST}" < "${SFTP_LIST_SCRIPT}" 2>/dev/null | grep "ai-widget-backup-.*-full\.tar\.gz" > "${TEMP_LIST}" || true

# Извлекаем только файлы бэкапов, отсортированные по дате (старые первыми)
sort "${TEMP_LIST}" > "${TEMP_LIST}.sorted" 2>/dev/null || true

# Подсчитываем количество файлов
FILE_COUNT=$(wc -l < "${TEMP_LIST}.sorted" 2>/dev/null | tr -d ' ' || echo "0")

if [ "${FILE_COUNT}" -gt "${MAX_BACKUPS}" ]; then
    FILES_TO_DELETE=$((FILE_COUNT - MAX_BACKUPS))
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Найдено ${FILE_COUNT} бэкапов, удаляем ${FILES_TO_DELETE} старых..."
    
    # Удаляем старые файлы (первые в списке)
    head -n "${FILES_TO_DELETE}" "${TEMP_LIST}.sorted" | while read -r file; do
        if [ -n "${file}" ]; then
            echo "[$(date '+%Y-%m-%d %H:%M:%S')] Удаление старого бэкапа: ${file}"
            SFTP_DELETE_SCRIPT=$(mktemp)
            cat > "${SFTP_DELETE_SCRIPT}" << EOF
cd "${SFTP_DIR}"
rm "${file}"
quit
EOF
            sshpass -p "${SFTP_PASS}" sftp -o StrictHostKeyChecking=no -o BatchMode=no "${SFTP_USER}@${SFTP_HOST}" < "${SFTP_DELETE_SCRIPT}" > /dev/null 2>&1 || true
            rm -f "${SFTP_DELETE_SCRIPT}"
        fi
    done
    
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Ротация выполнена (оставлено ${MAX_BACKUPS} бэкапов)"
else
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Количество бэкапов (${FILE_COUNT}) не превышает лимит (${MAX_BACKUPS}), ротация не требуется"
fi

rm -f "${TEMP_LIST}" "${TEMP_LIST}.sorted" "${SFTP_LIST_SCRIPT}" 2>/dev/null || true

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Загрузка на SFTP завершена успешно!"

exit 0

