<?php
$page_title = 'Настройка полей раздела';
require_once __DIR__ . '/includes/header.php';

$section_id = $_GET['section_id'] ?? 0;
$error = '';
$success = '';

// Получаем раздел и виджет
$db = getDatabase();
$stmt = $db->prepare("
    SELECT ws.*, w.name as widget_name, w.id as widget_id
    FROM widget_sections ws
    JOIN widgets w ON ws.widget_id = w.id
    WHERE ws.id = ?
");
$stmt->execute([$section_id]);
$section = $stmt->fetch();

if (!$section) {
    header('Location: /admin/');
    exit;
}

$section_names = [
    'specialists' => 'Специалисты',
    'services' => 'Услуги',
    'specializations' => 'Специализации',
    'articles' => 'Статьи'
];

// Обработка сохранения
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'save_section') {
        $url_pattern = trim($_POST['url_pattern'] ?? '');
        $test_limit = (int)($_POST['test_limit'] ?? 10);
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        
        try {
            $stmt = $db->prepare("
                UPDATE widget_sections 
                SET url_pattern = ?, test_limit = ?, is_active = ?
                WHERE id = ?
            ");
            $stmt->execute([$url_pattern, $test_limit, $is_active, $section_id]);
            $success = 'Настройки раздела сохранены';
        } catch (Exception $e) {
            $error = 'Ошибка сохранения: ' . $e->getMessage();
        }
    }
    
    if ($_POST['action'] === 'save_fields') {
        $field_ids = $_POST['field_id'] ?? [];
        $field_names = $_POST['field_name'] ?? [];
        $css_selectors = $_POST['css_selectors'] ?? [];
        $use_in_prompt = $_POST['use_in_prompt'] ?? [];
        $show_in_widget = $_POST['show_in_widget'] ?? [];
        $split_into_items = $_POST['split_into_items'] ?? [];
        $item_container_selector = $_POST['item_container_selector'] ?? [];
        $max_length = $_POST['max_length'] ?? [];
        
        // Дочерние поля
        $child_fields = $_POST['child_fields'] ?? [];
        
        try {
            $db->beginTransaction();
            
            // Обновляем существующие поля
            foreach ($field_ids as $i => $field_id) {
                if (empty($field_names[$i])) continue;
                
                $max_len = !empty($max_length[$i]) ? (int)$max_length[$i] : null;
                
                $stmt = $db->prepare("
                    UPDATE section_fields 
                    SET field_name = ?, css_selectors = ?, 
                        use_in_prompt = ?, show_in_widget = ?, field_order = ?,
                        split_into_items = ?, item_container_selector = ?, max_length = ?
                    WHERE id = ? AND section_id = ?
                ");
                $stmt->execute([
                    $field_names[$i],
                    $css_selectors[$i],
                    in_array($field_id, $use_in_prompt) ? 1 : 0,
                    in_array($field_id, $show_in_widget) ? 1 : 0,
                    $i,
                    in_array($field_id, $split_into_items) ? 1 : 0,
                    $item_container_selector[$i] ?? '',
                    $max_len,
                    $field_id,
                    $section_id
                ]);
                
                // Удаляем старые дочерние поля
                $stmt = $db->prepare("DELETE FROM section_child_fields WHERE field_id = ?");
                $stmt->execute([$field_id]);
                
                // Добавляем новые дочерние поля если включен split_into_items
                if (in_array($field_id, $split_into_items) && !empty($child_fields[$field_id])) {
                    $order = 0;
                    foreach ($child_fields[$field_id] as $childField) {
                        if (empty($childField['name']) || empty($childField['selector'])) continue;
                        
                        $stmt = $db->prepare("
                            INSERT INTO section_child_fields 
                            (field_id, child_field_name, child_css_selector, use_in_prompt, show_in_widget, field_order)
                            VALUES (?, ?, ?, ?, ?, ?)
                        ");
                        $stmt->execute([
                            $field_id,
                            $childField['name'],
                            $childField['selector'],
                            !empty($childField['use_in_prompt']) ? 1 : 0,
                            !empty($childField['show_in_widget']) ? 1 : 0,
                            $order++
                        ]);
                    }
                }
            }
            
            // Добавляем новые поля (аналогично)
            $new_field_names = $_POST['new_field_name'] ?? [];
            $new_css_selectors = $_POST['new_css_selectors'] ?? [];
            $new_use_in_prompt = $_POST['new_use_in_prompt'] ?? [];
            $new_show_in_widget = $_POST['new_show_in_widget'] ?? [];
            
            foreach ($new_field_names as $i => $field_name) {
                if (empty($field_name)) continue;
                
                $stmt = $db->prepare("
                    INSERT INTO section_fields (section_id, field_name, css_selectors, use_in_prompt, show_in_widget, field_order)
                    VALUES (?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([
                    $section_id,
                    $field_name,
                    $new_css_selectors[$i] ?? '',
                    in_array($i, $new_use_in_prompt) ? 1 : 0,
                    in_array($i, $new_show_in_widget) ? 1 : 0,
                    count($field_ids) + $i
                ]);
            }
            
            $db->commit();
            $success = 'Поля сохранены';
        } catch (Exception $e) {
            $db->rollBack();
            $error = 'Ошибка сохранения полей: ' . $e->getMessage();
        }
    }
    
    // Перезагружаем данные
    $stmt = $db->prepare("
        SELECT ws.*, w.name as widget_name, w.id as widget_id
        FROM widget_sections ws
        JOIN widgets w ON ws.widget_id = w.id
        WHERE ws.id = ?
    ");
    $stmt->execute([$section_id]);
    $section = $stmt->fetch();
}

// Получаем поля
$stmt = $db->prepare("
    SELECT * FROM section_fields 
    WHERE section_id = ? 
    ORDER BY field_order
");
$stmt->execute([$section_id]);
$fields = $stmt->fetchAll();

// Загружаем дочерние поля для каждого поля
$childFieldsByField = [];
if (!empty($fields)) {
    $fieldIds = array_column($fields, 'id');
    $placeholders = str_repeat('?,', count($fieldIds) - 1) . '?';
    $stmt = $db->prepare("
        SELECT * FROM section_child_fields 
        WHERE field_id IN ($placeholders)
        ORDER BY field_id, field_order
    ");
    $stmt->execute($fieldIds);
    
    while ($childField = $stmt->fetch()) {
        $childFieldsByField[$childField['field_id']][] = $childField;
    }
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-pencil"></i> <?php echo $section_names[$section['section_name']]; ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/sections-list.php?widget_id=<?php echo $section['widget_id']; ?>" class="btn btn-sm btn-outline-secondary me-2">
            <i class="bi bi-arrow-left"></i> К разделам
        </a>
        <a href="/admin/section-test.php?section_id=<?php echo $section_id; ?>" class="btn btn-sm btn-info">
            <i class="bi bi-play"></i> Тестировать
        </a>
    </div>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <!-- Настройки раздела -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">Настройки раздела</h5>
            </div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="action" value="save_section">
                    
                    <div class="mb-3">
                        <label for="url_pattern" class="form-label">URL Pattern (маска фильтрации)</label>
                        <input type="text" class="form-control" id="url_pattern" name="url_pattern" required value="<?php echo htmlspecialchars($section['url_pattern']); ?>" placeholder="/specialists/">
                        <div class="form-text">Из sitemap будут выбраны только URL содержащие этот паттерн</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="test_limit" class="form-label">Лимит тестирования (страниц)</label>
                        <input type="number" class="form-control" id="test_limit" name="test_limit" value="<?php echo $section['test_limit']; ?>" min="1" max="50">
                        <div class="form-text">Количество страниц для тестового парсинга</div>
                    </div>
                    
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" <?php echo $section['is_active'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="is_active">Раздел активен</label>
                    </div>
                    
                    <button type="submit" class="btn btn-primary mt-3">
                        <i class="bi bi-save"></i> Сохранить настройки раздела
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Поля раздела -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Поля раздела</h5>
            </div>
            <div class="card-body">
                <form method="POST" id="fieldsForm">
                    <input type="hidden" name="action" value="save_fields">
                    
                    <div id="existingFields">
                        <?php foreach ($fields as $field): ?>
                            <div class="card mb-3">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label class="form-label">Название поля</label>
                                            <input type="hidden" name="field_id[]" value="<?php echo $field['id']; ?>">
                                            <input type="text" class="form-control" name="field_name[]" value="<?php echo htmlspecialchars($field['field_name']); ?>" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">CSS Селекторы (через запятую)</label>
                                            <input type="text" class="form-control" name="css_selectors[]" value="<?php echo htmlspecialchars($field['css_selectors']); ?>" placeholder=".doctor-name, h1, .title">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Макс. символов</label>
                                            <input type="number" class="form-control" name="max_length[]" value="<?php echo $field['max_length'] ?? ''; ?>" placeholder="Без ограничения" min="1">
                                            <div class="form-text small">Оставить пусто для неограниченного текста</div>
                                        </div>
                                        <div class="col-md-1">
                                            <label class="form-label d-block">Использование</label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="use_in_prompt[]" value="<?php echo $field['id']; ?>" id="prompt_<?php echo $field['id']; ?>" <?php echo $field['use_in_prompt'] ? 'checked' : ''; ?>>
                                                <label class="form-check-label small" for="prompt_<?php echo $field['id']; ?>">
                                                    Промпт
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="show_in_widget[]" value="<?php echo $field['id']; ?>" id="widget_<?php echo $field['id']; ?>" <?php echo $field['show_in_widget'] ? 'checked' : ''; ?>>
                                                <label class="form-check-label small" for="widget_<?php echo $field['id']; ?>">
                                                    Виджет
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Настройки разбиения на отдельные элементы -->
                                    <div class="mt-3 border-top pt-3">
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input split-items-toggle" type="checkbox" name="split_into_items[]" value="<?php echo $field['id']; ?>" id="split_<?php echo $field['id']; ?>" <?php echo $field['split_into_items'] ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="split_<?php echo $field['id']; ?>">
                                                <strong>Разбить на отдельные элементы</strong>
                                            </label>
                                        </div>
                                        
                                        <div class="split-items-settings" id="split_settings_<?php echo $field['id']; ?>" style="display: <?php echo $field['split_into_items'] ? 'block' : 'none'; ?>;">
                                            <div class="mb-2">
                                                <label class="form-label small">Контейнер элемента списка</label>
                                                <input type="text" class="form-control form-control-sm font-monospace" name="item_container_selector[]" value="<?php echo htmlspecialchars($field['item_container_selector'] ?? ''); ?>" placeholder=".new-prais-item, .service-item">
                                            </div>
                                            
                                            <div class="border rounded p-2 mb-2" style="background-color: rgba(255,255,255,0.02);">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <label class="small mb-0"><strong>Поля дочерних элементов:</strong></label>
                                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="addChildField(<?php echo $field['id']; ?>)">
                                                        <i class="bi bi-plus"></i> Добавить поле
                                                    </button>
                                                </div>
                                                
                                                <div id="childFields_<?php echo $field['id']; ?>" class="child-fields-container">
                                                    <?php 
                                                    $childFields = $childFieldsByField[$field['id']] ?? [];
                                                    foreach ($childFields as $childField): 
                                                    ?>
                                                        <div class="child-field-row mb-2 p-2 border rounded">
                                                            <div class="row g-1">
                                                                <div class="col-md-3">
                                                                    <input type="text" class="form-control form-control-sm" 
                                                                           name="child_fields[<?php echo $field['id']; ?>][<?php echo $childField['id']; ?>][name]" 
                                                                           value="<?php echo htmlspecialchars($childField['child_field_name']); ?>" 
                                                                           placeholder="Название">
                                                                </div>
                                                                <div class="col-md-5">
                                                                    <input type="text" class="form-control form-control-sm font-monospace" 
                                                                           name="child_fields[<?php echo $field['id']; ?>][<?php echo $childField['id']; ?>][selector]" 
                                                                           value="<?php echo htmlspecialchars($childField['child_css_selector']); ?>" 
                                                                           placeholder="CSS селектор">
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <div class="form-check form-check-inline">
                                                                        <input class="form-check-input" type="checkbox" 
                                                                               name="child_fields[<?php echo $field['id']; ?>][<?php echo $childField['id']; ?>][use_in_prompt]" 
                                                                               <?php echo $childField['use_in_prompt'] ? 'checked' : ''; ?>>
                                                                        <label class="form-check-label small">Промпт</label>
                                                                    </div>
                                                                    <div class="form-check form-check-inline">
                                                                        <input class="form-check-input" type="checkbox" 
                                                                               name="child_fields[<?php echo $field['id']; ?>][<?php echo $childField['id']; ?>][show_in_widget]" 
                                                                               <?php echo $childField['show_in_widget'] ? 'checked' : ''; ?>>
                                                                        <label class="form-check-label small">Виджет</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="this.closest('.child-field-row').remove()">
                                                                        <i class="bi bi-x"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                                
                                                <div class="alert alert-info alert-sm mt-2 mb-0 small">
                                                    <i class="bi bi-info-circle"></i> Каждый элемент списка станет отдельной записью в базе. Используйте селектор <code>href</code> или <code>@href</code> для извлечения ссылок.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <button type="button" class="btn btn-sm btn-outline-danger mt-2" onclick="deleteField(<?php echo $field['id']; ?>, this)">
                                        <i class="bi bi-trash"></i> Удалить поле
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div id="newFields"></div>
                    
                    <button type="button" class="btn btn-outline-secondary mb-3" onclick="addNewField()">
                        <i class="bi bi-plus-circle"></i> Добавить поле
                    </button>
                    
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-save"></i> Сохранить все поля
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0">Справка по CSS селекторам</h6>
            </div>
            <div class="card-body small">
                <p><strong>Примеры селекторов:</strong></p>
                <ul class="mb-3">
                    <li><code>.doctor-name</code> - класс</li>
                    <li><code>#name</code> - ID</li>
                    <li><code>h1</code> - тег</li>
                    <li><code>div.main h1</code> - вложенность</li>
                    <li><code>img[src*="doctor"]</code> - атрибут</li>
                </ul>
                
                <p><strong>Fallback через запятую:</strong></p>
                <p class="mb-3">Селекторы проверяются по порядку. Если первый не найден, пробуется второй и т.д.</p>
                
                <p><strong>Разбиение на отдельные элементы:</strong></p>
                <p class="mb-2">Если на странице есть список элементов:</p>
                <ul class="mb-3">
                    <li><strong>Контейнер</strong> - CSS селектор каждого элемента списка</li>
                    <li><strong>Дочерние поля</strong> - поля для извлечения из каждого элемента</li>
                    <li>Используйте <code>href</code> или <code>@href</code> для извлечения ссылок</li>
                    <li>Каждый элемент станет отдельной записью в базе</li>
                </ul>
                
                <p><strong>Специальное значение:</strong></p>
                <p class="mb-0"><code>current</code> - текущий URL страницы (для поля url)</p>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Дефолтные поля</h6>
            </div>
            <div class="card-body small">
                <p class="mb-2"><strong>Specialists:</strong> name, photo, description, url</p>
                <p class="mb-2"><strong>Services:</strong> name, price, description, url</p>
                <p class="mb-2"><strong>Articles:</strong> title, content, date, url</p>
                <p class="mb-0"><strong>Specializations:</strong> name, description, url</p>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle split items settings
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.split-items-toggle').forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
            const fieldId = this.id.replace('split_', '');
            const settings = document.getElementById('split_settings_' + fieldId);
            if (settings) {
                settings.style.display = this.checked ? 'block' : 'none';
            }
        });
    });
});

// Счетчик для уникальных ID новых дочерних полей
let childFieldCounter = 1000;

// Добавить дочернее поле
function addChildField(fieldId) {
    const container = document.getElementById('childFields_' + fieldId);
    const uniqueId = 'new_' + (childFieldCounter++);
    
    const html = `
        <div class="child-field-row mb-2 p-2 border rounded">
            <div class="row g-1">
                <div class="col-md-3">
                    <input type="text" class="form-control form-control-sm" 
                           name="child_fields[${fieldId}][${uniqueId}][name]" 
                           placeholder="Название">
                </div>
                <div class="col-md-5">
                    <input type="text" class="form-control form-control-sm font-monospace" 
                           name="child_fields[${fieldId}][${uniqueId}][selector]" 
                           placeholder="CSS селектор">
                </div>
                <div class="col-md-3">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" 
                               name="child_fields[${fieldId}][${uniqueId}][use_in_prompt]" checked>
                        <label class="form-check-label small">Промпт</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" 
                               name="child_fields[${fieldId}][${uniqueId}][show_in_widget]" checked>
                        <label class="form-check-label small">Виджет</label>
                    </div>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="this.closest('.child-field-row').remove()">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
    
    container.insertAdjacentHTML('beforeend', html);
}

let newFieldIndex = 0;

function addNewField() {
    const html = `
        <div class="card mb-3" id="newField${newFieldIndex}">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Название поля</label>
                        <input type="text" class="form-control" name="new_field_name[]" placeholder="название">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">CSS Селекторы</label>
                        <input type="text" class="form-control" name="new_css_selectors[]" placeholder=".selector, h1">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label d-block">Использование</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="new_use_in_prompt[]" value="${newFieldIndex}" checked>
                            <label class="form-check-label">В промпте</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="new_show_in_widget[]" value="${newFieldIndex}" checked>
                            <label class="form-check-label">В виджете</label>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-sm btn-outline-danger mt-2" onclick="document.getElementById('newField${newFieldIndex}').remove()">
                    <i class="bi bi-trash"></i> Удалить
                </button>
            </div>
        </div>
    `;
    document.getElementById('newFields').insertAdjacentHTML('beforeend', html);
    newFieldIndex++;
}

function deleteField(fieldId, button) {
    if (!confirm('Удалить это поле? Это также удалит все спарсенные данные этого поля.')) {
        return;
    }
    
    fetch('/admin/ajax/delete-field.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ field_id: fieldId })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            button.closest('.card').remove();
            showAlert('Поле удалено', 'success');
        } else {
            showAlert('Ошибка: ' + data.error, 'danger');
        }
    });
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

