<?php
$page_title = 'Связывание специалистов с услугами';
require_once __DIR__ . '/../includes/header.php';

$widget_id = $_GET['id'] ?? 0;

// Получаем виджет
$db = getDatabase();
$stmt = $db->prepare("SELECT id, name FROM widgets WHERE id = ?");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    header('Location: /admin/');
    exit;
}

// Получаем статистику
$stmt = $db->prepare("
    SELECT COUNT(*) as total_specialists
    FROM parsed_items
    WHERE widget_id = ? AND section_name = 'specialists' AND is_duplicate = 0
");
$stmt->execute([$widget_id]);
$totalSpecialists = $stmt->fetch()['total_specialists'];

$stmt = $db->prepare("
    SELECT COUNT(DISTINCT ss.specialist_id) as linked_specialists
    FROM specialist_services ss
    WHERE ss.widget_id = ?
");
$stmt->execute([$widget_id]);
$linkedSpecialists = $stmt->fetch()['linked_specialists'];

$stmt = $db->prepare("
    SELECT COUNT(*) as total_links
    FROM specialist_services ss
    WHERE ss.widget_id = ?
");
$stmt->execute([$widget_id]);
$totalLinks = $stmt->fetch()['total_links'];
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <i class="bi bi-link-45deg"></i> Связывание специалистов с услугами: <?php echo htmlspecialchars($widget['name']); ?>
    </h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/widget-settings.php?id=<?php echo $widget_id; ?>" class="btn btn-sm btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Назад
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Статистика</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h3><?php echo number_format($totalSpecialists); ?></h3>
                                <p class="mb-0">Всего специалистов</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h3><?php echo number_format($linkedSpecialists); ?></h3>
                                <p class="mb-0">Связано специалистов</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h3><?php echo number_format($totalLinks); ?></h3>
                                <p class="mb-0">Всего связей</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Генерация связей</h5>
            </div>
            <div class="card-body">
                <form id="linkForm">
                    <input type="hidden" name="widget_id" value="<?php echo $widget_id; ?>">
                    
                    <div class="mb-3">
                        <label for="batch_size" class="form-label">Размер батча</label>
                        <input type="number" class="form-control" id="batch_size" name="batch_size" value="10" min="1" max="50" required>
                        <small class="form-text text-muted">Количество специалистов, обрабатываемых за один запрос (рекомендуется 10)</small>
                    </div>
                    
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary" id="startBtn">
                            <i class="bi bi-play-fill"></i> Начать связывание
                        </button>
                        <button type="button" class="btn btn-danger" id="stopBtn" style="display: none;">
                            <i class="bi bi-stop-fill"></i> Остановить
                        </button>
                    </div>
                </form>
                
                <div id="progressContainer" style="display: none;">
                    <div class="progress mb-3">
                        <div class="progress-bar" id="progressBar" role="progressbar" style="width: 0%">0%</div>
                    </div>
                    <div id="progressText" class="text-muted"></div>
                </div>
                
                <div id="logContainer" style="display: none;">
                    <h6>Лог обработки:</h6>
                    <pre id="logOutput" class="bg-dark text-light p-3 rounded" style="max-height: 400px; overflow-y: auto; font-size: 12px;"></pre>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let shouldStop = false;
let processedTotal = 0;
let totalSpecialists = <?php echo $totalSpecialists; ?>;

document.getElementById('linkForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const batchSize = parseInt(document.getElementById('batch_size').value);
    const startBtn = document.getElementById('startBtn');
    const stopBtn = document.getElementById('stopBtn');
    const progressContainer = document.getElementById('progressContainer');
    const logContainer = document.getElementById('logContainer');
    const progressBar = document.getElementById('progressBar');
    const progressText = document.getElementById('progressText');
    const logOutput = document.getElementById('logOutput');
    
    startBtn.disabled = true;
    stopBtn.style.display = 'inline-block';
    progressContainer.style.display = 'block';
    logContainer.style.display = 'block';
    shouldStop = false;
    processedTotal = 0;
    logOutput.textContent = '';
    
    let offset = 0;
    
    while (!shouldStop) {
        try {
            const response = await fetch('/admin/ajax/link-specialist-services-batch.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    widget_id: <?php echo $widget_id; ?>,
                    batch_size: batchSize,
                    offset: offset
                })
            });
            
            if (!response.ok) {
                throw new Error('HTTP ' + response.status);
            }
            
            const data = await response.json();
            
            if (!data.success) {
                throw new Error(data.error || 'Unknown error');
            }
            
            processedTotal += data.processed;
            offset += data.processed;
            
            const percent = totalSpecialists > 0 ? Math.round((processedTotal / totalSpecialists) * 100) : 0;
            progressBar.style.width = percent + '%';
            progressBar.textContent = percent + '%';
            progressText.textContent = `Обработано: ${processedTotal} из ${totalSpecialists} специалистов`;
            
            if (data.log) {
                logOutput.textContent += data.log + '\n';
                logOutput.scrollTop = logOutput.scrollHeight;
            }
            
            if (data.processed === 0 || processedTotal >= totalSpecialists) {
                break;
            }
            
            // Небольшая задержка между батчами
            await new Promise(resolve => setTimeout(resolve, 500));
            
        } catch (error) {
            logOutput.textContent += 'Ошибка: ' + error.message + '\n';
            logOutput.scrollTop = logOutput.scrollHeight;
            break;
        }
    }
    
    startBtn.disabled = false;
    stopBtn.style.display = 'none';
    
    if (processedTotal >= totalSpecialists) {
        progressText.textContent = 'Готово! Все специалисты обработаны.';
        progressText.className = 'text-success';
    }
});

document.getElementById('stopBtn').addEventListener('click', function() {
    shouldStop = true;
    this.disabled = true;
});
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

