-- Таблица для хранения настроек и результатов оптимизаций
CREATE TABLE IF NOT EXISTS `widget_optimizations` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `widget_id` INT(11) NOT NULL,
    `section_name` VARCHAR(50) NOT NULL COMMENT 'Раздел: specialists, services, articles, specializations',
    `optimization_type` VARCHAR(50) NOT NULL COMMENT 'Тип оптимизации: prefilter, compress, minify, shorten, group',
    `is_enabled` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Включена ли оптимизация для применения при запросах',
    `model` VARCHAR(255) NOT NULL DEFAULT 'google/gemini-2.5-flash-lite' COMMENT 'Модель для оптимизации',
    `optimized_data` LONGTEXT NULL COMMENT 'Результат оптимизации (JSON или текст)',
    `original_count` INT(11) NULL COMMENT 'Количество записей до оптимизации',
    `optimized_count` INT(11) NULL COMMENT 'Количество записей после оптимизации',
    `original_tokens` INT(11) NULL COMMENT 'Количество токенов до оптимизации',
    `optimized_tokens` INT(11) NULL COMMENT 'Количество токенов после оптимизации',
    `test_question` TEXT NULL COMMENT 'Вопрос, на котором тестировалась оптимизация',
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `widget_section_type` (`widget_id`, `section_name`, `optimization_type`),
    KEY `idx_widget_id` (`widget_id`),
    KEY `idx_section_type` (`section_name`, `optimization_type`),
    KEY `idx_enabled` (`is_enabled`),
    CONSTRAINT `fk_widget_optimizations_widget` FOREIGN KEY (`widget_id`) REFERENCES `widgets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Настройки и результаты оптимизаций промптов';

-- Таблица для маппинга симптомов → специальностей (для Варианта 1: Предварительная фильтрация)
CREATE TABLE IF NOT EXISTS `symptom_specialty_mapping` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `widget_id` INT(11) NOT NULL,
    `symptom_keyword` VARCHAR(255) NOT NULL COMMENT 'Ключевое слово симптома (например, "спина")',
    `specialty_keyword` VARCHAR(255) NOT NULL COMMENT 'Ключевое слово специальности (например, "невролог")',
    `priority` INT(11) NOT NULL DEFAULT 0 COMMENT 'Приоритет маппинга (чем выше, тем важнее)',
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_widget_id` (`widget_id`),
    KEY `idx_symptom` (`symptom_keyword`),
    KEY `idx_specialty` (`specialty_keyword`),
    CONSTRAINT `fk_symptom_mapping_widget` FOREIGN KEY (`widget_id`) REFERENCES `widgets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Маппинг симптомов к специальностям для предварительной фильтрации';

-- Таблица для хранения категорий элементов данных (для динамической фильтрации)
CREATE TABLE IF NOT EXISTS `item_categories` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `widget_id` INT(11) NOT NULL,
    `section_name` VARCHAR(50) NOT NULL,
    `item_id` INT(11) NOT NULL,
    `category` VARCHAR(255) NOT NULL COMMENT 'Категория, определенная AI (например, "болит спина", "неврология")',
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `widget_section_item_category` (`widget_id`, `section_name`, `item_id`, `category`),
    KEY `idx_widget_section` (`widget_id`, `section_name`),
    KEY `idx_category` (`category`),
    KEY `idx_item_id` (`item_id`),
    CONSTRAINT `fk_item_categories_widget` FOREIGN KEY (`widget_id`) REFERENCES `widgets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Категории элементов данных для динамической фильтрации';

