<?php
$page_title = 'Логи тестирования промпта';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/includes/auth.php';

$widget_id = $_GET['widget_id'] ?? 0;
$log_id = $_GET['log_id'] ?? 0;

$db = getDatabase();

// Получаем виджет
$stmt = $db->prepare("SELECT id, widget_key, name FROM widgets WHERE id = ?");
$stmt->execute([$widget_id]);
$widget = $stmt->fetch();

if (!$widget) {
    die('Виджет не найден');
}

// Если указан конкретный лог - показываем детали
if ($log_id > 0) {
    $stmt = $db->prepare("SELECT * FROM prompt_test_logs WHERE id = ? AND widget_id = ?");
    $stmt->execute([$log_id, $widget_id]);
    $log = $stmt->fetch();
    
    if (!$log) {
        die('Лог не найден');
    }
    
    include __DIR__ . '/includes/header.php';
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2>Детали лога тестирования</h2>
                <p><a href="?widget_id=<?php echo $widget_id; ?>">← Назад к списку логов</a></p>
                
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Основная информация</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Вопрос:</strong> <?php echo htmlspecialchars($log['question']); ?></p>
                        <p><strong>Дата:</strong> <?php echo date('d.m.Y H:i:s', strtotime($log['created_at'])); ?></p>
                    </div>
                </div>
                
                <?php if ($log['stage1_prompt'] || $log['stage1_response']): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Этап 1: Быстрый текстовый ответ</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($log['stage1_request']): ?>
                        <h6>Запрос:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 200px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage1_request']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage1_prompt']): ?>
                        <h6>Промпт:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 300px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage1_prompt']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage1_response']): ?>
                        <h6>Ответ:</h6>
                        <pre class="bg-dark text-success p-3" style="max-height: 300px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage1_response']); ?></pre>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($log['stage2_prompt'] || $log['stage2_response']): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Этап 2: Извлечение медицинских терминов</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($log['stage2_request']): ?>
                        <h6>Запрос:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 200px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage2_request']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage2_prompt']): ?>
                        <h6>Промпт:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 300px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage2_prompt']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage2_response']): ?>
                        <h6>Ответ:</h6>
                        <pre class="bg-dark text-success p-3" style="max-height: 300px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage2_response']); ?></pre>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($log['stage3_prompt'] || $log['stage3_response']): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Этап 3: Основной запрос</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($log['stage3_request']): ?>
                        <h6>Запрос:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 200px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage3_request']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage3_prompt_before']): ?>
                        <h6>Промпт ДО оптимизации:</h6>
                        <pre class="bg-dark text-warning p-3" style="max-height: 400px; overflow-y: auto; font-size: 11px;"><?php echo htmlspecialchars($log['stage3_prompt_before']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage3_prompt_after']): ?>
                        <h6>Промпт ПОСЛЕ оптимизации:</h6>
                        <pre class="bg-dark text-info p-3" style="max-height: 400px; overflow-y: auto; font-size: 11px;"><?php echo htmlspecialchars($log['stage3_prompt_after']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage3_prompt'] && !$log['stage3_prompt_before']): ?>
                        <h6>Промпт:</h6>
                        <pre class="bg-dark text-light p-3" style="max-height: 400px; overflow-y: auto; font-size: 11px;"><?php echo htmlspecialchars($log['stage3_prompt']); ?></pre>
                        <?php endif; ?>
                        
                        <?php if ($log['stage3_response']): ?>
                        <h6>Ответ:</h6>
                        <pre class="bg-dark text-success p-3" style="max-height: 400px; overflow-y: auto;"><?php echo htmlspecialchars($log['stage3_response']); ?></pre>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($log['final_response']): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Финальный ответ</h5>
                    </div>
                    <div class="card-body">
                        <pre class="bg-dark text-success p-3" style="max-height: 400px; overflow-y: auto;"><?php 
                            $final = json_decode($log['final_response'], true);
                            echo htmlspecialchars(json_encode($final, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)); 
                        ?></pre>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($log['debug_info']): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h5>Отладочная информация</h5>
                    </div>
                    <div class="card-body">
                        <pre class="bg-dark text-light p-3" style="max-height: 400px; overflow-y: auto;"><?php 
                            $debug = json_decode($log['debug_info'], true);
                            echo htmlspecialchars(json_encode($debug, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)); 
                        ?></pre>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php
    include __DIR__ . '/includes/footer.php';
    exit;
}

// Список логов
$page = $_GET['page'] ?? 1;
$per_page = 20;
$offset = ($page - 1) * $per_page;

$stmt = $db->prepare("SELECT COUNT(*) as total FROM prompt_test_logs WHERE widget_id = ?");
$stmt->execute([$widget_id]);
$total = $stmt->fetch()['total'];
$total_pages = ceil($total / $per_page);

$stmt = $db->prepare("
    SELECT id, question, created_at, 
           CASE WHEN stage1_response IS NOT NULL THEN 1 ELSE 0 END as has_stage1,
           CASE WHEN stage2_response IS NOT NULL THEN 1 ELSE 0 END as has_stage2,
           CASE WHEN stage3_response IS NOT NULL THEN 1 ELSE 0 END as has_stage3
    FROM prompt_test_logs 
    WHERE widget_id = ? 
    ORDER BY created_at DESC 
    LIMIT ? OFFSET ?
");
$stmt->execute([$widget_id, $per_page, $offset]);
$logs = $stmt->fetchAll();

include __DIR__ . '/includes/header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h2>Логи тестирования промпта</h2>
            <p><strong>Виджет:</strong> <?php echo htmlspecialchars($widget['name']); ?> (<?php echo htmlspecialchars($widget['widget_key']); ?>)</p>
            
            <?php if (empty($logs)): ?>
            <div class="alert alert-info">
                Логи тестирования отсутствуют. Логи создаются автоматически при тестировании промпта в режиме отладки.
            </div>
            <?php else: ?>
            <div class="table-responsive">
                <table class="table table-dark table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Вопрос</th>
                            <th>Этапы</th>
                            <th>Дата</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?php echo $log['id']; ?></td>
                            <td><?php echo htmlspecialchars(mb_substr($log['question'], 0, 100)); ?><?php echo mb_strlen($log['question']) > 100 ? '...' : ''; ?></td>
                            <td>
                                <?php if ($log['has_stage1']): ?><span class="badge bg-primary">1</span><?php endif; ?>
                                <?php if ($log['has_stage2']): ?><span class="badge bg-info">2</span><?php endif; ?>
                                <?php if ($log['has_stage3']): ?><span class="badge bg-success">3</span><?php endif; ?>
                            </td>
                            <td><?php echo date('d.m.Y H:i:s', strtotime($log['created_at'])); ?></td>
                            <td>
                                <a href="?widget_id=<?php echo $widget_id; ?>&log_id=<?php echo $log['id']; ?>" class="btn btn-sm btn-primary">Просмотр</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($total_pages > 1): ?>
            <nav>
                <ul class="pagination">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                        <a class="page-link" href="?widget_id=<?php echo $widget_id; ?>&page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                    <?php endfor; ?>
                </ul>
            </nav>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php
include __DIR__ . '/includes/footer.php';



